"Under They Thunder" by Amos and Abel Fay

the story headline is "A text adventure from OkayCo. New? Ooh, Nay".

the story description is "An ol' stray stroll".

release along with a website.

release along with an interpreter.

include Under They Thunder Definitions by Andrew Schultz.

include Under They Thunder Globals by Andrew Schultz.

include Under They Thunder Tables by Andrew Schultz.

include Trivial Niceties by Andrew Schultz.

include Intro Restore Skip by Andrew Schultz.

include Punctuation Stripper by Andrew Schultz.

include undo output control by Erik Temple.

include conditional undo by Jesse McGrew.

include Bypass Disambiguation by Climbing Stars.

include Zap Trace by Andrew Schultz.

use American dialect.

the monty rules are a rulebook.

section testing modules - not for release

include Under They Thunder Tests by Andrew Schultz.

include property checking for UTT by Emily Short. [not a big deal what I changed.]

volume i6 modification(s)

section What Do You Want to X

Include (-
Replace LanguageVerb;
-) after "Definitions.i6t".

Include (-
[ LanguageVerb i;
	switch (i) {
	'i//','inv','inventory': print "take inventory";
	'l//':   print "look";
	'x//':   print "examine";
	'z//':   print "wait";
	'rf//':  print "read fully";
	'about':  print "see info about the game";
	'credits': print "see the credits";
	'r//': "reach to or read";
	't//', 'greet', 'ta', 'talk': print "talk to";
	'ease', 'please', 'harder', 'ardor': "toggle hinting nudges";
	'gt', 'go to', 'goto':   print "go to";
	'help':  print "ask for HELP";
	'opt', 'opts':  print "read options";
	'verb', 'verbs', 'v//':  print "see useful verbs";
	'v//', 'verbs', 'verb':  print "see basic verbs";
	'xyzzy', 'plugh', 'yoho': print "say a silly spell";
	default: rfalse;
    }
    rtrue;
];
-) after "Language.i6t".

volume player and utilities

The print final score rule is not listed in for printing the player's obituary.

K is a person. The player is K. "It's you, K. You should never see this."

understand "aryn/aaron/erin" and "aryn/aaron/erin k" as K.

description of player is "You! Ooh, yay! Your name is Aaron, or Aryn, or Erin, K.[one of] Because there are already too many weird abstract literary works where the protagonist's name is K, so why not make one more. [or] [stopping]You're ... [']ere, hey?"

the haul all hey is a proper-named automatic thing. printed name is "your Haul-All-Hey". description of Haul All Hey is "It just carries everything. You don't need to do anything with it."

instead of doing something with Haul All Hey: say "Your Haul All Hey just carries everything. It looks quite sturdy, and you don't need to refer to it explicitly. You can see what's in there with [b]I[r] for inventory, saving keystrokes.";

the aid fey fade is an automatic thing. printed name is "Aid-Fey-Fade". description is "This thing will, apparently, be able to detect when an item isn't useful any more and can be recycled. The internal details are unimportant. It does everything by itself, too, so you don't have to (U)se it."

instead of doing something with Fade Aid Fey: say "You will use the Fade Aid Fey to recycle items you no longer need. You don't need to refer to it explicitly.";

volume trays

to warn-use (x - a win-tray):
	if x is not warned:
		now x is warned;
		let pn be printed name of x in upper case;
		say "You can just U [word number 1 in pn] or U [pn] if it's easier.[line break]";
	try useing x;

chapter the puzzle

to wipe-clear (r - a trayroom):
	now got-right of location of player is 0;
	repeat through table of traytries:
		if trm entry is location of player and validtry entry is true, now triedyet entry is false;

check useing a win-tray:
	if location of player is not a trayroom, say "You can't seem to use [the noun] explicitly here. It seems to be built for navigating tricky places without clear solutions." instead;
	if location of player is finished, say "You already took care of things here." instead;
	repeat through table of traytries:
		if trm entry is location of player:
			if mytray entry is noun:
				if validtry entry is false:
					wipe-clear location of player;
					break;
				else:
					if triedyet entry is false, increment got-right of location of player;
					now triedyet entry is true;
					break;
	if got-right of location of player is 4:
		say "Suddenly, [location of player] rearranges itself a bit. You have used the trays correctly here!";
		now location of player is finished;
		if number of finished trayrooms is 3:
			say "[line break]That's all three, isn't it? You wait around for something to happen. Nothing does. Then you look behind you. There's ... yet another book. [plan].[paragraph break]You look to the heavens, or maybe to the upper right of the status line, for acknowledgement, or even a single last lousy point. But it is not forthcoming. A voice booms: 'Sometimes you must do things without regard for personal gain!'[paragraph break]You briefly consider joining the [flame] over this, but the feeling passes. You realize you haven't been quite so good about that.";
			now player has Plan An Play;
	else:
		say "[location of player] shifts almost imperceptibly. For better or worse, or even neutrally, you can't be sure.";
	the rule succeeds;

chapter ace tray / trace

the ace tray is a win-tray. description is "Well, you're not sure what it's useful for." [a]

section traceing

traceing is an action applying to nothing.

understand "trace" as traceing when player has ace tray.

carry out traceing:
	if ace tray is not warned:
		now ace tray is warned;
		say "You can just U ACE or U ACE TRAY if it's easier.[line break]";
	try useing ace tray instead;

chapter ends tray / trends

the ends tray is a win-tray. description is "You feel a bit more perceptive just looking at the ends tray." [e]

section trending

trending is an action applying to nothing.

understand "trend" and "trends" as trending.

carry out trending:
	warn-use ends tray instead;

chapter icky tray / tricky

the icky tray is a win-tray. description is "It's not too icky to hold, but all the same, the sooner you can find what it's used for so you can get rid of it, the better." [i]

section trickying

trickying is an action applying to nothing.

understand "tricky" and "trick" and "tricks" as trickying.

carry out trickying:
	warn-use icky tray instead;

chapter ol' tray / trounce

the ol' tray is a win-tray. description is "Charmingly vintage, or whatever. You could probably annoy people by showing off what a valuable antique you have, if you weren't the hero of a text adventure as snazzy as this.". [o]

section trolling

trolling is an action applying to nothing.

understand "troll" as trolling.

carry out trolling:
	warn-use ol' tray instead;

chapter rusting tray / trusting

the rusting tray is a win-tray. description is "It's not rusted through. It's still functional, you guess.". [u]

section trusting

trusting is an action applying to nothing.

understand "trust" and "trusty" and "trusting" as trusting.

carry out trusting:
	warn-use rusting tray instead;

chapter eyeing tray / trying

the eyeing tray is a win-tray. description is "The eyeing tray is shiny enough for you to see passages reflected in it.". [y]

section trying

trying is an action applying to nothing.

understand "try" as trying.

carry out trying:
	warn-use eyeing tray instead;

volume Am Hey Ham

book Start Art Stay

Start Art Stay is a room in Am Hey Ham. shorttext is "Start". "On one wall are several examples of heart art, HEY! While they're not pretty, they're quite realistic, and a [strip] below them indicates their names[if reach each ray is touchable]. The Reach Each Ray is equipped to, well, [b]REACH[r] any of them[end if].[paragraph break]You can also go [look-desc of inside], [look-desc of north][if did-raid-aid-ray is true], [look-desc of east][end if][if sco-use-rod-ray is true], [look-desc of south][end if] or [look-desc of west]. There's also a way [look-desc of outside][if id say side is in Start Art Stay][side-desc][end if][if which say switch is in Start Art Stay][one of]. And you can also (U)se the [stay stop] to change the adventure at any time.[paragraph break]Ah, so that's what [covert] uncovered: a [switch] and a [wait], both of which you could probably USE[or]. There's also the [switch] and [wait] on one wall[stopping][end if]. From a passage above, you hear [if sco-use-saw-slumber is false]tired whining[whine-score]. [whine-or-stop][else]contented chatter, now everyone can get rest[end if].". noway-text is "You can go pretty much any way here, but not [noun].". [nopunc]

after printing the locale description of Start Art Stay when Ernie J is moot:
	if last-room of Brain Reign Bay is Start Art Stay, say "Ernie left you a lot to look at and think about once you returned from [Breeding]. Looks like REACHing somewhere new might really start your adventure.";
	continue the action;

check going in Art Stay:
	if noun is down, say "Yes, under they thunder, but too far down to just rap on the floor and yell BE QUIET or something.[paragraph break]Also, the [flame] wouldn't just stay three feet under for so long. They'd have invaded and conquered, or something. But they are below. Deep below." instead;
	if noun is east and did-raid-aid-ray is false, say "[if opt-stay-stop is true]There's no passage there yet, and in fact, it's not available when [the stop] is set[else]There will be something there. Work with the Raid Aid Ray first[end if]." instead;
	if noun is south and sco-use-rod-ray is false, say "[if opt-stay-stop is true]There's no passage there yet, and in fact, it's not available when [the stop] is set[else]Not yet. Work with the Raid Aid Ray some more[end if]." instead;

to say whine-score:
	if score < 30, say ", but it sounds like it's been going on for a while, so you might not be able to quiet it for a bit"

to say whine-or-stop:
	say "[if opt-stay-stop is true]Perhaps the [stop] will help you end it sooner, without addressing it directly[else]You probably don't want to join the whining, but maybe you can fix it[end if]"

to say side-desc:
	say ". And also, now you saw it, you can't un-see the [say side], leading [if Ere Say Seer is unvisited]somewhere suspicious[else]to [seer] and [cheater][end if]"

to say look-desc of (di - a direction):
	let x be the room di of location of player;
	say "[di] to [if x is visited][x][else][gen-desc of x]";

section Op Stay Stop

the Op Stay Stop is scenery. printed name is "Op-Stay-Stop". "The [stay stop] is there to stop you from going places not strictly relevant for a fully streamlined adventuring experience, on the off-chance you really want to get through with this in two hours so you won't be too exhausted for other wonderful and different journies. Currently it is [on-off of opt-stay-stop], meaning you will [if opt-stay-stop is false]not [end if]be taking the quick way through."

definition: a room (called rm) is introductory:
	if rm is Ope Nay Nope or rm is Oft Lay Loft, no;
	if rm is Start Art Stay or rm is adjacent to Start Art Stay, yes;
	if rm is Bleak Leak Bay or rm is Oats Bay or rm is Bruise Rues Bay or rm is Blight Light Bay or rm is Whale Ail Way, yes;
	no;

check going when opt-stay-stop is true (this is the stay-stop rule):
	let RLN be the room noun of the location of player;
	if RLN is nowhere, continue the action;
	if RLN is not introductory, say "You feel a tingling in your lower legs. Not painful, just, it must be the [stop] acting to cue you that whatever's there is unnecessary to complete the [stop]-streamlined version of Under They Thunder[if sco-use-cable-blower is true]. In fact, you may wish to OP HEY HOP now, since you've completed what you need to do[end if]." instead;
	if RLN is Sing Ing Say and did-warn-sing is false:
		now did-warn-sing is true;
		say "You feel a small cramp in one leg. You get the sense this room doesn't have anything critical to offer, though it might be fun to poke around.";
	if RLN is Ovel Nay Novel and did-warn-Novel is false:
		now did-warn-Novel is true;
		say "You feel a cramp in both legs, as if warning you this will could be a serious waste of time but ultimately a harmless one.";

section ossing

ossing is an action applying to nothing.

understand "op stay stop" and "op stay" and "op stop" and "stay top" and "op" and "stay" as ossing when player is in Start Art Stay.

carry out ossing: try useing op stay stop instead;

chapter Id Say Side

procedural rule while entering Id Say Side: ignore the can't enter what's not enterable rule.

the Id Say Side is scenery. "It was hidden in the wall, but you see it now. All your good guesses that didn't quite work have paid off.". printed name is "I'd-Say Side".

check entering Id Say Side:
	if global-good-guesses < 5, say "It's jammed a bit. Maybe you need to look around first before it opens again." instead;
	move player to Ere Say Seer;
	the rule succeeds;

chapter Trip Say Strip

the Trip Say Strip is scenery in Start Art Stay. "[b]OUT! STAY STOUT![r] is in big letters on the first line. Below it, you see the places you can go out[check-all-none]:[paragraph break][avail-places].". printed name is "Trip-Say Strip".

to say check-all-none:
	if number of rayable visited rooms is 0, say "--you haven't been anywhere yet";
	if number of rayable unvisited rooms is 0, say ", to refresh your memory, since you've been everywhere"

chapter heart art hey

the Heart Art Hey is scenery in Start Art Stay. printed name of Heart Art Hey is "Heart Art (Hey)". "The [heart] has a [if rayables < 3]couple[else]selection of [rayables in words][end if] locations to visit. The [strip] below it has more information on their names."

does the player mean examining Heart Art Hey: it is very likely.

after examining Heart Art Hey when last-out-room is not Start Art Stay:	say "[line break][last-out-room], the last place you visited, is particularly bright. A reminder you can go back with MO."

to say avail-places:
	let X be number of rayable visited rooms;
	say "You [if x is 0]haven't visited any locations outside Am-Hey-Ham yet[else]have already visited [list of rayable visited rooms][end if]. ";
	now X is number of rayable unvisited rooms;
	say "You [if X is 0]have visited all the rooms you can jump to[else]haven't yet tried to REACH [list of rayable unvisited rooms][end if]";
	if ever-om-mo is true, say ". Or you can go back to the last place you visited ([last-out-room]) with [b]MO[r]"

check entering Heart Art Hey: say "Try REACHing one of the locations instead." instead;

chapter Reach Each Ray

the Reach Each Ray is scenery. "To use the Reach Each Ray, you can [b]R[r] or [b]REACH[r] any location displayed in [heart].". printed name is "Reach-Each Ray".

after printing the locale description (this is the last room tracking rule):
	if mrlp is omable, now last-room of mrlp is location of player;
	if note-rchar-commands is false:
		if mrlp is omable and mrlp is not Brain Reign Bay:
			bold-note "There's an additional shortcut to MO now. You can type [b]RB[r] for the last visited room in Brain Reign Bay, and you can type [b][reach-abbrev of mrlp in upper case][r] to return to the last visited room in [mrlp]. But only if you're here in [start]. The second letter is the most often appearing first letter of the locations in the area.";
			now note-rchar-commands is true;
	continue the action;

definition: a region (called reg) is any-visited:
	if number of visited rooms in reg > 0, yes;
	no;

section reaching

farxing is an action applying to one visible thing.
reaching is an action applying to one visible thing.

to decide whether r-is-reaching:
	if reach each ray is not off-stage and mrlp is Am Hey Ham, yes;
	no;

understand the command "r" as something new.

understand "x [any rayable room]" as farxing when r-is-reaching.
understand "examine [any rayable room]" as farxing when r-is-reaching.

understand "r [any rayable room]" as reaching when r-is-reaching.
understand "reach [any rayable room]" as reaching when r-is-reaching.
understand "enter [any rayable room]" as reaching when r-is-reaching.

carry out farxing:
	say "You can't really see [the noun] in detail, but nothing's stopping you from REACHing it[if noun is visited] again[end if].";
	the rule succeeds;

carry out reaching:
	if reach each ray is moot, say "The reach each ray is no longer available." instead;
	if player is not in Start Art Stay, say "You walk over to Start Art Stay...";
	say "You point the Reach Each Ray at the picture of [noun]. You are teleported [if noun is visited]back[else]somewhere new[end if]...";
	move player to noun;
	if note-om-mo is false:
		bold-note "you can invoke the universal peaceful incantation [om-help] to return to Start Art Stay at any time, unless there is a critical event. [mo-help] will send you from Start Art Stay to where you last were.";
		now note-om-mo is true;
	the rule succeeds;

to say om: say "[b]OM[r]"

to say mo: say "[b]MO[r]"

to say om-help: say "[b]OM HEY HOME[r] or just [om]"

to say mo-help: say "[b]OH MAY MO[r] or just [mo]"

chapter Ernie J

Ernie J is a person. "[if player has who ooh hey]Ernie J nods. 'Ah, good. You have enough to get you oriented. There are two rays that will help you: the Reach Each Ray I just brought in here will help you go places, and the Raid Aid Ray to the west will help you be different, or find different items. You have to sort of tell it what you want, though. I may be around for encouragement later, or I may not.'[paragraph break]Ernie J waves as he walks away.[else]Ernie J waits here, smiling. [should-next].[end if]". talk-text of Ernie J is "Ernie J welcomes you profusely. 'Welcome to Am-Hey-Ham! It's not super exciting, but it works well enough. It's home to OkayCo, where people can just be themselves and that's okay! It's ... no, really, it's exciting, but it's not, like agitating! Anyway, let's get you oriented, first. Here's a Haul-All-Hey. It'll help you carry stuff. And the [fade] will make sure that stuff you don't need anymore is disposed of ecologically and efficiently.[paragraph break]'That should be enough stuff to get started. But you need knowledge, too. So you may wish to go [b]IN[r] and check there.'[paragraph break]Ernie J turns to leave but then whirls around. 'Oh, wait. A couple more things. First, a [please]. It will help you know what to do with obstacles, but you can USE it to turn it off. Second, the [op stay stop] on the wall is currently on. That'll make things quicker. In the extremely unlikely case you only have, oh, two hours to spend for this whole adventure and maybe have others to see. If you've got other cool stuff to do, I respect that.[paragraph break]'We felt guilty even offering these to you. Then we had a weird squabble about setting them on by default. We worried it might insult your intelligence. But ... there's a lot to do out there.'". description is "Ernie J smiles at you. You smile back reflexively[if ernie j is not talked-to or Breeding Reading Bay is visited]. You probably want to TALK to him to get things going, though[end if].". [nopunc]

to say should-next: say "[if ernie j is talked-to]But he jerks his head, cuing you should probably go IN right now[else]Perhaps you should [b]T(ALK)[r] to him[end if]";

after talking Ernie J when Haul All Hey is off-stage:
	now player has Haul All Hey;
	now player has Aid Fey Fade;
	now player has Please Ease Play;
	move Op Stay Stop to Start Art Stay;
	now opt-stay-stop is true;
	now opt-ease-play is true;
	bold-note "there's no penalty for using the [please], and you don't miss a special ending if you keep the [stop] set. This game defaults to the speed and help options because of the very real possibility you may be overwhelmed at first without them.";
	continue the action;

check going in Start Art Stay:
	if Ernie J is not talked-to, say "Ernie J seems to want to [b]TALK[r] to you." instead;
	if Ernie J is touchable and noun is not inside, say "Ernie J points inside. You have no reason not to trust him." instead;

after looking in Art Stay:
	if Ernie J is off-stage:
		say "As you get your bearings, someone comes by and introduces themselves as [ernie].[paragraph break]You should probably [b]TALK[r] to Ernie J to help you get started. You can abbreviate this with [b]T[r].";
		move Ernie J to Start Art Stay;
	else if Ernie J is in Start Art Stay and Breeding Reading Bay is visited:
		moot Ernie J;
		move Reach Each Ray to Trip Say Strip;
	continue the action;

chapter Please Ease Play

the Please Ease Play is a thing. description is "It looks a bit odd. You have no clue how it works, but it seems sturdy. Currently it's [if ever-ease-play is false]on, and you may want to keep it that way unless you like a real challenge, you may wish to turn it on[else if opt-ease-play is true]on, so you can get an idea of how to tackle that next obstacle. You can point it at anything you see, even yourself, if you are having trouble deciphering what it means[else]off, so you have the maximum challenge[end if].". printed name is "Please-Ease-Play".

understand "pep" as please ease play when player has please ease play.

after talking:
	if opt-ease-play is true and noun is not ordinary, try peping the noun;
	continue the action;

section peping

peping is an action applying to one thing.

understand the command "pep" as something new.

understand "pep" as peping.
understand "pep [thing]" as peping.

understand "please ease play" and "please ease" and "please play" and "ease play" and "please" and "ease" as peping.

rule for supplying a missing noun when reading:
	try useing please ease play;

carry out peping:
	if opt-ease-play is false, say "You need to (U)se the [please] to turn it on before using the PEP command." instead;
	if noun is the player, say "There is no shortcut to self-enlightenment." instead;
	if noun is please ease play, say "You gain no insight into either how the [please] was created or why its creator didn't take it and go on this quest, here. Also, you receive no complete beginning-to-end set of instructions to win out." instead;
	if noun is ooh hey who, say "[who], being (or trying to be) totally factual, isn't receptive to the [please]. Eh, it's handy enough." instead;
	if noun is a latinable:
		if noun is allscored, say "The [please] remains silent. You did all you could." instead;
		say "A bunch of word-pairs pop up in your mind. Perhaps [the noun] requires one or both of such magic pairs to [if noun is unscored]start[else]continue[end if] helping you." instead;
	if noun is automatic, say "You don't ever have to (U)se [the noun] explicitly." instead;
	say "The [please] [if noun is songy]lets off a few notes[else if noun is booky]makes a noise like pages rustling[else if noun is needy]makes a noise like an old-fashioned cash register ringing[else if noun is moody]makes a noise like--well, a ray zapping something[else if noun is complex]beeps wildly--no quick solution here[else if noun is mystical]glows, as if you need some magic to dispel [the noun][else]doesn't make any noise. Hmm. Maybe you don't have to do anything to or with [the noun] directly[end if].";
	the rule succeeds.

chapter oming

oming is an action applying to nothing.

understand the command "om" as something new.
understand the command "home" as something new.
understand the command "om hey home" as something new.

understand "om" as oming.
understand "home" as oming.
understand "om hey home" as oming.

this is the can-i-om rule:
	abide by the can-i-goto rule;

carry out oming:
	if last-out-room is Aced Way, say "You can't use [b]OM[r] until you've used the Reach Each Ray to get somewhere outside OkayCo." instead;
	if mrlp is Am Hey Ham, say "You already are in the home region. [om] sends you back home--perhaps you meant to say [mo], instead, which would send you to [last-out-room]." instead;
	abide by the can-i-om rule;
	say "You warp back to Start Art Stay[one of]. (Nothing has changed much, so I won't print the full description even if you're in verbose mode.)[or].[stopping]";
	now ever-om-mo is true;
	now last-out-room is location of player;
	drop-player-at Start Art Stay;
	if Cold Old Cay is not rayable:
		if score > got-score of raid aid ray:
			say "Ernie J stops by briefly. 'Nice job! You're making progress! Here, watch this.' He taps the Reach Each Ray, which buzzes. Another location appears in the [heart].[paragraph break]'The [cold]. It is the northwest part of [Clout], an island equal in size to [brain].'";
			now Cold Old Cay is rayable;
	now sta-announced-trays is true;
	the rule succeeds.

chapter moing

moing is an action applying to nothing.

understand the command "mo" as something new.
understand the command "oh may mo" as something new.

understand "mo" as moing.
understand "oh may mo" as moing.
understand "mo oh may" as moing.

this is the can-i-mo rule:
	do nothing;

carry out moing:
	if mrlp is not Am Hey Ham, say "You need to be back in the home region for [mo] to work and send you to, well, a more adventuresome area like here. Perhaps you meant to say [om]." instead;
	if ever-om-mo is false, say "You haven't been outside [Am Hey Ham], so this command doesn't work yet." instead;
	if last-out-room is Aced Way, say "You can't go back to where you were." instead;
	abide by the can-i-mo rule;
	say "You [if player is not in Start Art Stay]walk over to Start Art Stay and [end if]return to your main adventure.";
	move player to last-out-room;
	the rule succeeds;

chapter hour pay power rules

the Alt Say Salt is a useful thing. description is "This small packet fell out when the [switch], [wait] and [hour] merged together. You wonder what use it could have.". indefinite article is "some". printed name is "Alt-Say Salt".

every turn when pay-power-used is 4:
	process the power-drained rule;

this is the power-drained rule:
	if player is in Start Art Stay and player has hour pay power and pay-power-used is 4 and chase ace che is moot and imp prey primp is moot and Clothing Loathing Cay is ever-alt:
		say "You feel a spark coming from the [hour]. It reaches out to the [switch] and [wait]. A triangle of blue electricity buzzes, then the [hour] bursts into flame, briefly. It splits apart, revealing a packet of [salt]. You have some guesses as to what it can do.";
		now the player has Alt Say Salt;
		moot wait eight way;
		moot which say switch;
		moot hour pay power;

this is the power-first-drained rule:
	say "You sort of expect the [fade] to zap the [hour], but it doesn't. Hmm[if player is in Sci I Say]. But wait...[else].[end if]";
	process the power-drained rule;

book Sci I Say

Sci I Say is west of Start Art Stay. It is in Am Hey Ham. "[if raid aid ray is unscored]It smells a bit funny here, and if you strain your ears and LISTEN, you can hear something unusual[else]You feel more at home here now you've figured what to do[end if]. The only way out is back east. [ray-status].". gen-desc of Sci I Say is "a lab". shorttext is "Sci". printed name is "Sci, I Say". [nwdef]

after printing the locale description when player is in Sci I Say:
	set the pronoun it to Raid Aid Ray;
	continue the action;

to say ray-status:
	if sta-just-fixed-ray is true:
		say "The Raid Aid Ray is humming along again. Looks like your trip to [ray rile] fixed it";
		now sta-just-fixed-ray is false;
		continue the action;
	say "The [raid] sits here, [if ray-needs-rile]broken from your first two actions[else if ray-needs-rod]missing a critical part[else if did-raid-aid-ray is true]ready for further operation[else]inactive. Ernie J said it was up to you to figure how to use it[end if]"

The raid aid ray is a latinable in Sci I Say. "It's currently set to [raid-setting]. [if did-raid-aid-ray is true]You can read it to see setting details[else]The settings are hopelessly smudged, so you can't READ anything meaningful at the moment[end if]. It has a handle attached to it[if got-score of raid aid ray is 0]. But [ernie] said you needed to think of what the ray could give you, then say it[end if].[paragraph break]It was created by Rollin['] Olin Raye, Roscoe 'Osco' Raye, Rantin['] Anton Raye, Ready Eddie Raye, and Randy Andy Raye. Take that, Wright Brothers![paragraph break]There's also thanks to a special contributor on the [handle].". printed name is "[if ray-needs-rile]ringing ray[else]Raid Aid Ray[end if]". guess-table is table of raid aid ray guesses. help-verb is "R". known-rule of raid aid ray is raid-known rule. preuse-text of raid aid ray is "The [raid] seems to have a lot of settings that need discovering.".

this is the raid-known rule: [this could for most practical purposes be the trivially true rule since the ankh and sheet need the raid aid ray. And the ship allows fewer than five good guesses at the moment. But let's make sure.]
	if Sci I Say is visited, the rule succeeds;
	the rule fails;

after examining raid aid ray:
	if ray-needs-rod, say "The Raid Aid Ray is missing a part.";
	continue the action;

The Handle Andle Hey is scenery in Sci I Say. "The handle is labeled Handle? [']Andle! Hey! which seems useless and convoluted, but then, it might be a weird clue for a weird machine.[paragraph break]It's actually a pretty big handle, so much that engraved thanks to [']Owly Ray Rowley, for, well, howling at them fits. They'd never have though of those two powerful, colloquial settings without him!". printed name is "Handle? [']Andle! Hey!"

understand "ringing/ring/ing" and "ringing/ring/ing ray" as raid aid ray when ray-needs-rile.

understand "rumble/umble ray" and "rumble/umble" and "rumble umble" and "rumble umble ray" as raid aid ray when ray-is-working.

to say raid-setting:
	repeat through table of Raid Aid Ray Guesses:
		if is-set entry is true:
			say "[firstof of w1 entry] [firstof of w2 entry]";
			continue the action;
	say "nothing, yet"

chapter items the ray produces

section Eel May Meal

the Eel May Meal is an ingredient. description is "It looks like it might be delicious, but you don't need exotic food right now.". printed name is "Eel-May-Meal".

section Rover Over Ray

the Rover Over Ray is a useful thing. description is "It's a flashlight, really. It [if sco-use-rover-clamp-clay is true]is charged now[else]seems dead. There must be a way to charge it. The [raid] wouldn't give you something useless[end if].". printed name is "Rover-Over Ray".

understand "flashlight" and "flash/light" as Rover Over Ray when player has Rover Over Ray.

section Able Kay Cable

an Able Kay Cable is a useful thing. printed name is "'Able, [']Kay?' cable". indefinite article of Able Kay Cable is "an". description is "It looks like pretty sturdy rope.".

section Hoarder Order Hey

the Hoarder Order Hey is a loneuse thing. description is "It's a rake, really. It could clean up some messy place.". printed name of Hoarder Order Hey is "Hoarder-Order, HEY"

section Unny Bay Bunny

the Unny Bay Bunny is an ingredient. description is "It's dead, and it's a bunny, and it was evil, or as evil as bunnies can be.". printed name is "[']Unny Bay Bunny"

book Breeding Reading Bay

Breeding Reading Bay is inside of Start Art Stay. It is in Am Hey Ham. "You see two bookshelves here. A tidier one is labeled Tough-Say-Stuff. A messier one is the Ack Stay Stack. This place is pretty enclosed. You can really only go out.". noway-text of Breeding Reading Bay is "There are no secret passages to any other rooms. You can really only go back OUT to [start].". gen-desc of Breeding Reading Bay is "a small library". shorttext is "Breeding". [nopunc]

Shelf Elf Shay is a person in Breeding Reading Bay. "[one of]'Hi! I'm Shelf Elf Shay. You can [b]TALK[r] to me to get an idea of what to read next.'[or]Shelf Elf Shay leans against [tough], waiting to give [if shelf elf shay is talked-to]more [end if]general help[if ernie j is not moot], though you've probably got enough for now[end if].[stopping]". description of Shelf Elf Shay is "Shelf Elf Shay is leaning up against [stuff]. It's several times his size.". talk-text of Shelf Elf Shay is "[one of]'Hello! So, you're here to help us? Well, here's something that can help you.' Shelf Elf Shay hands you a copy of [who ooh hey]. 'This will help you identify mysterious people and things as you go on your quest. The other books are more specialized. They may help in certain places.'[or][shelf-help].[stopping]". [nopunc]

to say shelf-help:
	if last-helpbook is Aid Fray Fraid and opt-hinter-reading is false:
		say "[shelf] points out there are no wrong books to read, though [thought] is light on strategy and heavy on history. There is no wrong choice to start reading";
	else if opt-stay-stop is true:
		say "'Maybe I shouldn't say this, but since the [stop] is on, you [if sco-talk-thump is true]have done all you need here[else]might only need one of these books[end if].' You're momentarily impressed by this and wondering why [shelf] isn't out there adventuring instead of you";
	else:
		say "'Being bookish and all, I'm not so good with direct chat, but I [if opt-hinter-reading is true]will[else]can[end if] cut in to remind you if a book you're flipping through is still necessary.' You remember HINTER is currently [on-off of opt-hinter-reading] and can be turned off with INTER HEY";

after talking Shelf Elf Shay for the first time:
	say "'Oh, also, I can give hints if you want. It doesn't matter either way. Just let me know.'[paragraph break]You can type [b]HINTER[r] for [shelf elf] to kibitz on your book choice, and you can disable this with [b]INTER HEY[r]. These and other options will be available in [b]OPTS[r] if you forget them.";

check going outside in Breeding Reading Bay:
	if player does not have Who Ooh Hey, say "You may wish to [b]TALK[r] to Shelf Elf Shay first." instead;

ever-helpbook is a truth state that varies.

last-helpbook is a helpbook that varies.

check examining a helpbook when opt-hinter-reading is true (this is the shelf elf book nudge rule):
	if undone-helpbooks is 0, say "[shelf] shrugs. 'You've gotten all you could from these books.'[paragraph break]If you want to read them again without [shelf] bugging you, you'll need to type [b]INTER HEY[r] to undo the [b]HINTER[r] command you used." instead;
	process the finished-reading-rule of the noun;
	if the rule succeeded, say "'[shelf elf] coughs. 'I think you've gotten enough from [noun]. No need to re-read it[if noun is last-helpbook]. Pack your head with knowledge from another book[end if].' Seems fair. You nod." instead;
	process the help-useful-rule of the noun;
	if last-helpbook is noun, say "Re-reading is an important activity in the real world. However, here in Am-Hey-Ham, it doesn't have any practical effect. You understand [noun] well enough." instead;

after examining a helpbook (this is the remember which helpbook you read rule):
	if ever-helpbook is false:
		say "Well. Your brain feels pretty full after that.";
		now ever-helpbook is true;
		now last-helpbook is noun;
		continue the action;
	if last-helpbook is not noun:
		say "As you finish reading [noun], you realize you've forgotten the knowledge from [last-helpbook]. [if last-helpbook is undone]These aren't very big books--pamphlets, even--but they're dense enough, you can only really keep focused on one at a time[else]But [last-helpbook] has probably served you well enough[end if].";
		now last-helpbook is noun;
	continue the action;

check going up in Start Art Stay:
	now Oft Lay Loft is visited;
	if sco-use-saw-slumber is true, say "You don't need to rest, now. You fixed [loft]." instead;
	if think-saw-slumber is true, say "A bunch of people are trying to sleep here but failing. You remember that construction project you tried with the [saw] and the [slumber]. Hmm." instead;
	say "As you go up to [loft], you hear complaining. Everyone is tired, but nobody is comfortable enough to sleep. Demoralizing the enemy has, apparently, been very effective for the [flame].[paragraph break]You head back down before you join the complainers. Maybe you'll find something to help them once you go exploring." instead;

check taking a helpbook:
	if shelf elf shay is not talked-to, say "It'd be rude to take anything without talking first." instead;
	say "[shelf elf] wags a finger. 'The books aren't to be removed. You can READ them, though.'" instead;

check taking a bookshelf: say "You can't take any of the books in [the noun], and you can't take the whole [noun], either." instead;

check taking scenery (this is the creative scenery reject rule):
	if player is in Ovel Nay Novel, say "Don't disrupt the disruptive art![paragraph break]You can really only examine the scenery here, or anywhere. And everything here is just for amusement." instead;
	if noun is raid aid ray or noun is reach each ray, say "The [noun] is too heavy, but it'll do all it needs to for you, here." instead;
	say "That is scenery, so you don't need to TAKE it. Perhaps I should have a more specific reject, but I don't." instead;

section Oft Lay Loft

Oft Lay Loft is above Start Art Stay. It is in Am Hey Ham. shorttext is "[if sco-use-saw-slumber is true]Snooze[else]Loft[end if]". printed name is "[if sco-use-saw-slumber is true]News-Say-Snooze[else]Oft-Lay Loft[end if]". description is "This is a fake room designated for sleeping.". [nwdef]

understand "news say snooze" and "news say" and "news/say snooze" and "news/say" as Oft Lay Loft when sco-use-saw-slumber is true.

chapter Aid Fray Fraid

Aid Fray Fraid is a helpbook in Aced Way. description is "It should not be seen.". finished-reading-rule is trivially true rule. printed name is "Aid Fray-[']Fraid".

chapter Flatter At Er Flay

Flatter At Er Flay is a helpbook in Breeding Reading Bay. description is "It provides insights on how to recognize when flattery is meant to cut you down or hold you back, along with simple techniques to deal with it without feeling guilty.". finished-reading-rule is finished-flatter-at-er-flay rule. printed name is "Flatter? At [']Er, Flay". help-useful-rule is useful-flatter-at-er-flay rule.

this is the finished-flatter-at-er-flay rule:
	if sco-talk-simp is true, the rule succeeds;
	the rule fails;

this is the useful-flatter-at-er-flay rule:
	if Brag Agh Brae is unvisited:
		say "'You don't need that yet, but I won't stop you.'";
	else:
		say "[shelf] nods at your choice, trying not to, uh, be too flattering. But obviously approving."

chapter I Slay Sly

I Slay Sly is a helpbook in Breeding Reading Bay. description is "It's a semi-Machiavellian offer that straddles the line nicely between being too positive and being too bummed.". finished-reading-rule is finished-i-slay-sly rule. help-useful-rule is useful-i-slay-sly rule. printed name is "I Slay, Sly"

this is the finished-i-slay-sly rule:
	if sco-talk-should is true, the rule succeeds;
	the rule fails;

this is the useful-i-slay-sly rule:
	if Cruddy Ruddy Cay is not visited:
		say "'You might need some more progress before reading that.'";
	else:
		say "'You could do something with that.'";

chapter Nerd Erd Nay

Nerd Erd Nay is a helpbook in Breeding Reading Bay. description is "It contains helpful advice on dealing with people who want to overintellectualize things to disrupts others['] good times or, indeed, who want to force others who seem to be having a good time to overintellectualize.". printed name is "Nerd [']Erd? NAY". finished-reading-rule is finished-nerd-erd-nay rule. help-useful-rule is useful-nerd-erd-nay rule.

this is the finished-nerd-erd-nay rule:
	if sco-talk-dork is true, the rule succeeds;
	the rule fails;

this is the useful-nerd-erd-nay rule:
	if Fill Ill Fey is unvisited:
		say "'You're still a [if Frowned Round Fey is visited]bit[else]good ways[end if] away from needing that.'";
	else:
		say "'A good choice for now.";

chapter Oft Say Soft

Oft Say Soft is a helpbook in Breeding Reading Bay. description is "A useful tome on defusing arguments or even just getting people to stop being such a headache. It contains sections on what happens if they escalate things, as well as other useful pointers for not feeling guilty you aren't the shouty type, with reminders a quiet life is still worth living.". finished-reading-rule is finished-oft-say-soft rule. help-useful-rule is useful-oft-say-soft rule. [nopunc]

this is the finished-oft-say-soft rule:
	if sco-talk-stim is true, the rule succeeds;
	the rule fails;

this is the useful-oft-say-soft rule:
	let prog be (boolval of sco-use-quill-stink) + (boolval of sco-use-clear-ear-clay);
	if prog is 0:
		say "'You're a ways from needing that.'";
	else if prog is 1:
		say "'You'll need to do a bit more before that is truly useful.'";
	else:
		say "'That looks QUITE useful now.'"

chapter Shut Hut Say

Shut Hut Say is a helpbook in Breeding Reading Bay. description is "A nice, aggressive approach to shutting people up, especially the passive-aggressive types.". printed name is "Shut! Hut! Say!". finished-reading-rule is finished-shut-hut-say rule. help-useful-rule is useful-shut-hut-say rule.

this is the finished-shut-hut-say rule:
	if sco-talk-skid is true, the rule succeeds;
	the rule fails;

this is the useful-shut-hut-say rule:
	if sco-use-cable-blower is false:
		say "'You're a ways from needing that.'";
	else if Was Us Way is unvisited:
		say "'You might not need that book. Maybe soon, though.'";
	else:
		say "'Seems like a pretty good choice.'"

chapter Strife Rife Stay

Strife Rife Stay is a helpbook in Breeding Reading Bay. description is "You learn techniques for not fleeing without feeling frozen in place.". finished-reading-rule is finished-strife-rife-stay rule. printed name is "Strife Rife? STAY". help-useful-rule is useful-strife-rife-stay rule.

this is the finished-strife-rife-stay rule:
	if sco-talk-thump is true, the rule succeeds;
	the rule fails;

this is the useful-strife-rife-stay rule:
	say "[shelf] nods enthusiastically as you riffle through [strife].";

chapter Urchin Say Searchin

Urchin Say Searchin is a helpbook in Breeding Reading Bay. description is "You learn better, if slightly, abstruse ways to search things by just X/EXAMINE-ing them. You feel like you've internalized them, unless you find other profound knowledge.". finished-reading-rule is finished-urchin-say-searchin rule. the help-useful-rule is the useful-urchin-say-searchin rule. printed name is "Urchin, Say? Searchin[']".

this is the finished-urchin-say-searchin rule:
	if sco-use-stick-clumsy is true, the rule succeeds;
	the rule fails;

this is the useful-urchin-say-searchin rule:
	let prog be boolval of (whether or not Clues Lose Cay is visited) + boolval of (whether or not player has ick stay stick);
	if prog is 0:
		say "'You might be a good way from needing that.'";
	else if prog is 1:
		say "'Hmm, that might be useful in the near future, but you need to do more.'";
	else if prog is 2:
		say "'You've done what you need for that to be useful.'";

chapter Where Say Swear

Where Say Swear is a helpbook in Breeding Reading Bay. description is "Where Say Swear goes into the details of saying profanity: when and how, and its diminishing return to scale. It concludes that, while profanity is mostly unnecessary, one shouldn't completely avoid it, it should seem natural and never punch down and, most importantly, never use it to distract someone you are in an argument with. Think [i]The Big Lebowski[r] or [i]Blues Brothers[r] or, even, ironically, [i]The Room[r]. If you aren't close to them, forget it.[paragraph break]Also, this does not make you equivalent to the keyboard warriors who claimed they just had to use ten sentences in a row with profanity, because someone else was mean to them.". finished-reading-rule is finished-where-say-swear rule. the help-useful-rule is the useful-where-say-swear rule. printed name is "Where-Say-Swear".

this is the finished-where-say-swear rule:
	if sco-talk-prude is true, the rule succeeds;
	the rule fails;

this is the useful-where-say-swear rule:
	if Charred Hard Cay is visited:
		say "'Hmm, worth a try.'";
	else:
		say "'That book is only of theoretical importance at the moment, though it may gain practical relevance shortly.'";

chapter Wrong Stay Strong

Wrong Stay Strong is a helpbook in Breeding Reading Bay. description is "[strong] is a motivational book designed to help you where or when you get frustrated. It advertises itself as more rigorous than [i]Up, Yay, Yup[r], and you do indeed glean some useful pointers about keeping your head up when things go bad.". finished-reading-rule is finished-wrong-stay-strong rule. help-useful-rule is useful-wrong-stay-strong rule. printed name is "Wrong? Stay Strong".

this is the finished-wrong-stay-strong rule:
	if sco-talk-thump is true, the rule succeeds;
	the rule fails;

this is the useful-wrong-stay-strong rule:
	if Bruise Rues Bay is visited:
		say "'Hmm, that seems like a very good choice.";
	else:
		say "'A good choice to get started[if done-helpbooks > 1], but I'm impressed you used another first[end if].'";

chapter Yawn On Yay

Yawn On Yay is a helpbook in Breeding Reading Bay. description is "A book on how to let someone 'exciting' know they are really just agitating and exhausting, without being rude, and without escalating things.". finished-reading-rule is finished-yawn-on-yay rule. help-useful-rule is useful-yawn-on-yay rule. printed name is "Yawn On, Yay".

this is the finished-yawn-on-yay rule:
	if sco-talk-self is true, the rule succeeds;
	the rule fails;

this is the useful-yawn-on-yay rule:
	if location of Elf Say Self is unvisited:
		say "'That might not be immediately useful to you.'";
	else:
		say "'You know, I bet you could do something with that, now.'";

chapter Who Ooh Hey

Who Ooh Hey is a plainbook. printed name is "Who? Ooh, Hey". description is "[who ooh hey] will automatically help you identify people and things. For instance, you might recognize a machine that insults people as an App-Slay-Slap.[paragraph break]So you won't ever need to properly READ or EXAMINE some things to know their names.".

chapter App May Map

the App May Map is scenery in Breeding Reading Bay. "It's a map of everywhere you've been and could be. Maybe not so directly useful for you, but with [b]HINTER[r] on, [shelf elf] can see where you've been and help you.[paragraph break][map-visited].". printed name is "App-May-Map".

to say map-visited:
	if Ernie J is not moot:
		say "Nothing's filled in yet. You haven't really started your adventure, anyway";
	else if Lack Ack Ley is visited:
		say "Every map area is lit up";
	else if Lack Ack Ley is unvisited:
		say "One small remaining chunk to the side is not lit up yet";
	else if Frowned Round Fey is unvisited:
		say "While two large squarish islands are filled in, two smaller chunks to the side are not lit up";
	else if Cold Old Cay is unvisited:
		say "One squarish island is partially filled in, but the other isn't";
	else if Berth Earth Bay is unvisited or Bleak Leak Bay is unvisited:
		say "Very little is filled in. You remember you haven't looked at both original places [reach] showed you";
	else:
		say "Nothing is filled in yet, because you haven't used the [reach]";

check examining App May Map for the first time:
	say "'Oh yeah. this map keeps track of where you've been and where you'll go. I hope it's not too intrusive. But it helps me give you hints if you want it.' Shay apologizes for such intrusiveness and also feels embarrassed that, for all their technical knowledge, OkayCo can't stand up effectively to the [flame]. They are all planning and no action.";

chapter Tough Say Stuff

Tough Say Stuff is a proper-named bookshelf in Breeding Reading Bay. description is "Tough Say Stuff is loaded with many small books: [list of helpbooks in Breeding Reading Bay]. There's also a big one, [ought they thought].". printed name is "Tough-Say Stuff".

chapter Ought They Thought

Ought They Thought is a pagedbook in Breeding Reading Bay. description is "While light on advice, it appears to be a history of OkayCo and the Feys that wish to destroy it. READing may give more details.". book-pages of Ought They Thought is table of oughts. printed name is "Ought-They-Thought".

table of oughts
read-yet	my-page
false	"You read of the history of OkayCo, located in the humble town of Am-Hey-Ham, and of the people that said it wasn't really okay for ... just being okay. It didn't faze OkayCo for a while. They outnumbered the trolls. Until the trolls formed an unholy union."
false	"For so long, the [factual] regarded OkayCo as stupid and uninteresting and dull and yet completely unable to live in the real world. OkayCo wasn't even fun to feel better than any more! They didn't even TRY to be fun to feel better than! What was up with that? But OkayCo recognized the FAF as such, and they managed to ignore them."
false	"The [fight] took a different angle from the [factual]. They found OkayCo to be putzes. Again, OkayCo could deal with them on their own. There was enough static between the FIF and FAF that OkayCo survived. Until ..."
false	"It was [spread] who brought them together. Enough bluster for the loudmouths, enough guile for the subtler trolls. With his rise, the thunder under became truly worrisome."
false	"And what's more, the FIF and FAF enjoyed being ordered around that way. He showed them a path to ordering others around more effectively! This gained their loyalty. They joined forces to become ... the [printed name of flame in upper case]. The combined attacks eventually wore OkayCo down. People stopped having fun. After a while, the incessant mix of 'Oh, we're just making suggestions' and 'Don't you know how lame you are?' got to OkayCo. But it had been so long since real conflict. Everyone in OkayCo had grown complacent and unable to act. Even people who suspected they knew what to do ... didn't try. They didn't think they were dynamic enough."
false	"The FLF had OkayCo boxed in: if OkayCo didn't respond to their taunts, they didn't WANT to get better. If they did, it showed they knew how awful they were."
false	"And, isolated, OkayCo had no reason to believe that there were other groups out there like them. They didn't know where to look. And if they did find any such groups -- well, wasn't that saying 'Hey, you're boring and lame, too?' Yes. Yes it did. Or it seemed to."
false	"And yet some members of OkayCo built devices and defenses and such. They just didn't use them fully. Perhaps they believed they were not interesting enough to use their interesting devices. And as the FLF's attacks grew more strident and bold, OkayCo residents felt less able to act ... or think. The FAF shut down OkayCo's arguments, and the FIF shut down OkayCo's actions. The machinery -- well, it didn't make things paradise, but it helped them survive. But each day that survival grew tougher. [spread] grew stronger."
false	"[spread] has found out, to his chagrin, OkayCo has its defenses. They know what to do and even how to do it, but hey don't know how to act to get rid of him. He has found from experience that direct attacks fail. With nothing to do but fight, when OkayCo's backs are against the wall, that they do. They manage to scrape by. They're almost not worth pushing around! Almost."
false	"OkayCo residents, sick of the fear, felt reduced to waiting for a hero. It was embarrassing, but they had no other choice. Nobody stepped up. They needed someone who hadn't been burnt by the FLF but still cared. Perhaps that someone is you!"

chapter Ack Stay Stack

the Ack Stay Stack is a bookshelf in Breeding Reading Bay. "One random book is [i][next-rand of table of books][r]. You flip through it a bit but then forget it[one of], since it doesn't seem practical right now, even though you're fighting for this sort of art to be produced in peace[or][stopping].". printed name is "Ack-Stay Stack".

after examining Ack Stay Stack for the first time:
	say "You don't have time to read pages and pages of frivolous text now, though. Well, probably not. Eventually, you'll need to get on with all this adventuring stuff!";
	continue the action;

book Ovel Nay Novel

Ovel Nay Novel is outside of Start Art Stay. "This is a disorganized yet comfortable place, full of weird stuff that can't possibly be useful[if did-talk-sham is false]. You'd need someone to guide you ... and someone, indeed, is here[else], but it's fun. You could lose hours of time paging through, if you wanted: Ads Chez Chad's describe shopping you don't have time for, Odder Fey Fodder tells of other weird lands and places, and the Blab Lab Bay has small talk you REALLY don't have time for.[paragraph break]There's an ESP PSA, for the goody-goody, and an ashtray, for the ... not so goody[end if]. You can only go back [look-desc of inside].". It is in Am Hey Ham. printed name of Ovel Nay Novel is "[']Ovel? Nay, Novel". shorttext is "Novel". noway-text of Ovel Nay Novel is "There are no secret passages to any other rooms. You can go back IN to Start Art Stay.". gen-desc of Ovel Nay Novel is "a place of odds and ends".

chapter Sham Ham Shay

Sham Ham Shay is a person in Ovel Nay Novel. "[one of]'Hi! I'm Sham Ham Shay. I'm responsible for ... everything here. Absolutely nothing here is critical to your quest, but it's, like, representative of the culture you'll be helping to preserve. [b](T)[r]alk to me if you want details.'[or]Sham Ham Shay waits here[if did-talk-sham is false], perhaps for you to (T)alk[end if].[stopping]". talk-text of Sham Ham Shay is "[one of]Sham Ham Shay shows you the Ads Chez Chad's, Odder Fey Fodder and Blab Lab Bay. Even an ESP PSA and, for licentious types, an ashtray[or]Sham Ham Shay shows you through his works again. He seems glad anyone is interested[stopping]. 'Remember, nothing is useful here! Nothing at all!'". description is "Dressed in motley. He probably can't help you with your quest, but maybe he can provide entertainment if you need a break.". [nopunc]

after printing the locale description for Ovel Nay Novel when player was in Start Art Stay and Ovel Nay Novel was visited:
	say "'Ah, back for more useless entertainment? This does help me feel good about myself.'";
	continue the action;

chapter ESP PSA

an ESP PSA is scenery. "It's blank. But as you look at it, you think you hear a smother mother and her husband (it must be dad-add day) say 'Crack? Ack! Cray!' What a cold-say scold![paragraph break]Seriously, though, the more time you spend on chemical addictions, the less time you will have for your text adventure addictions. And that'd be a tragedy.". [nopunc]

chapter ashtray

an ashtray is randscen. "You look at the ashtray, and previously empty, it begins to swirl. [next-rand of table of ashtray visions] goes through your head for a moment, and then it's back to normal.". [nopunc]

check examining the ashtray for the first time: say "Hmm. A brief glance shows that if you want a less, err, dirty experience, you may not want to examine the ashtray again. It's an ashy tray, all right." instead;

chapter This Is They

There is randscen called This is They. "[one of]'Um, slay slum.'[paragraph break]One[or]Another[stopping] person who failed is [next-rand of table of dead people].". [nopunc]

chapter Odder Fey Fodder

Odder Fey Fodder is randscen. "You read suggestions of [next-rand of table of awful locations], a bit too weird even for here.". [nopunc]

chapter Ads Chez Chad's

Ads Chez Chad's is randscen. "[one of]One[or]Another[stopping] ad is for [next-rand of table of ads].". [nopunc]

chapter Blab Lab Bay

Blab Lab Bay is randscen. "[one of]One[or]Another[stopping] random comment is [next-rand of table of lab blab]". [nopunc]

after examining blab lab bay for the first time: say "[sham] notes that nothing you find here will be accessible from the [reach]. It's just supposed to be fun.";

book Singing Say

Sing Ing Say is north of Start Art Stay. it is in Am Hey Ham. "[if songs-left is 1]There's only one song left to hear[else if songs-left is 0]It's silent now that you've heard and used all the songs[else]You hear several different songs here. They seem to switch every minute[end if]. You could LISTEN to one at random, or X one you remember. What's more, there's a list of songs titled [croons], in case you don't want to wait to hear one.[paragraph break]The only way out is back south.". printed name of Sing Ing Say is "Singing, Say". shorttext of Sing Ing Say is "Singing". gen-desc of Sing Ing Say is "the source of some music". [nwdef]

understand "singing" and "singing say" as Sing Ing Say.

chapter Croons Runes K

Croons Runes K is scenery in Sing Ing Say. "You read the entire list of songs on offer: [list of songs in Sing Ing Say].". printed name is "Croons Runes, K?"

chapter Itty day Ditty

Itty Day Ditty is a song in Aced Way. description is "This is the default song, so it should not come up.". [Itty Day Ditty is the default song] [nopunc]

chapter Our Bay Bar

Our Bay Bar is a song in Sing Ing Say. description is "It's sort of like the [i]Cheers[r] theme song, only modernized. It makes you feel at home.". [nopunc]

chapter Lo Gay Glow

Lo Gay Glow is a song in Sing Ing Say. description is "You feel a little embarrassed to like something so slightly cheesy, then you get over it. It works, to make you feel better.". printed name is "Lo, Gay Glow".

chapter Pure Your Pay

Pure Your Pay is a song in Sing Ing Say. description is "A bit too moral, it revolves around doing nice things for people just because. It could probably rankle the right, or maybe the wrong, sort of person.". printed name is "Pure, Your Pay"

chapter Smiled Mild Say

Smiled Mild Say is a song in Sing Ing Say. description is "Unlike many songs about eternal fiery love, this is one about friendship and decency and tolerance.". printed name is "Smiled Mild, Say".

chapter Stone Tone Say

Stone Tone Say is a song in Sing Ing Say. description is "A purposefully off-key song, but not without a sense of humor.". printed name is "Stone Tone, Say".

book Ere Say Seer

check entering Ere Say Seer:
	abide by the cant-use-cheater rule;

Ere Say Seer is a room in Am Hey Ham. "It's cramped in here. Obviously this place isn't built for show. You can exit OUT.". printed name is "[']Ere-Say Seer". shorttext is "Seer".

Cheater Eater Che is a person in Ere Say Seer. "[one of]'Psst! I'm Cheater Eater Che. If you want some help, TALK to me. You sort of have to use a code.'[or]Cheater Eater Che sits here, waiting for you to [if cheater eater che is talked-to]request a specific hint[else]TALK to him about cheating in general[end if].[stopping]". talk-text is "'Hey there. If you need some help, there are a few things I've heard about. Don't ask me how. I can give [global-good-guesses / 5 in words] hint[if global-good-guesses >= 10]s[end if] right now.". description is "[cheater] looks totally unconcerned whether or not you want his help.". printed name is "Cheater-Eater Che".

to decide whether all-hints-gone:
	repeat with LA running through latinables:
		if need-score of LA > 0, no;
	yes;

to decide whether current-hints-gone:
	repeat with LA running through latinables:
		if need-score of LA > 0:
			process the known-rule of LA;
			if the rule succeeded, no;
	yes;

this is the cant-use-cheater rule:
	if global-good-guesses < 5:
		if player is in Start Art Stay:
			say "You can't find a way in like you did before. Maybe you need to perform more good guesswork.";
		say "'That's all I can give you now. Keep up the good work and the good guesses. Maybe you can come back for more.'";
		move-if-not Start Art Stay;
		the rule succeeds;
	if all-hints-gone:
		if player is in Ere Say Seer:
			say "Cheater Eater Che pushes you out. 'You don't need me any more! Way to go!'[paragraph break]You turn around once back in [start art], but you can't find the [say side] any more. Well, it must be a good sign you don't need it.";
		else:
			say "You don't seem to need to go back in."; [?? make this disappear]
		move-if-not Start Art Stay;
		moot Id Say Side;
		the rule succeeds;
	if current-hints-gone:
		if player is in Ere Say Seer:
			say "Cheater Eater Che gestures toward the door. 'I can't help you any more right now, but maybe later.";
		else:
			say "You feel okay about your progress so far. You don't need to go visiting anywhere for hints.";
		move-if-not Start Art Stay;
		the rule succeeds;

after talking Cheater Eater Che:
	repeat with LA running through latinables:
		process the known-rule of LA;
		if the rule failed, next;
		if LA is not allscored, say "'You can ask for [help-verb of LA] [paren-range of need-score of LA] for a clue to [the LA].";
	say "'I can't tell you what hint is most valuable to you, but I won't tell you what you already know, and I will get things right.'[one of][line break](An example command would thus be [b]A 1[r]. If you want to make sure you ask for something you really need, you can ask for HELP for more detail.)[or][stopping]";
	continue the action;

chapter helping

helping is an action applying to nothing.

understand the command "help" as something new.

understand "help" as helping when player is in Sci I Say or player is in Seer.

carry out helping:
	if player is in seer:
		say "If you had, for instance:[line break](?) (?)[line break]Known clue[line break](?) (?)[line break]Known clue[line break](?) (?)[paragraph break]and the item name started with C, then C 1 would tell you the first entry, C 2 would tell you the third, and C 3 would tell you the last.[paragraph break]You can go back and READ the item you wish to change (e.g. the [raid] to see the list, and then pick something you haven't figured, yet.";
	else if player is in Sci I Say:
		say "[one of]The [raid] has a special power related to Pig Latin.[or]It gives a reek (eek).[or]The names of its creators are in Pig Latin.[or]Also, LISTENing lets you hear it is a Road Ode Ray.[or]You need to find a word starting with R that, when converted to Pig Latin, manes sense. At least sort of.[stopping]";
	else:
		say "There is no help specific to this area.";
	the rule succeeds.

chapter rhinting

rhinting is an action applying to one number.

understand "r [number]" as rhinting when player is in Ere Say Seer and raid aid ray is not allscored.

carry out rhinting: cheat-eat raid aid ray and number understood instead;

chapter ihinting

ihinting is an action applying to one number.

understand "i [number]" as ihinting when player is in Ere Say Seer and hip say ship is not allscored.

carry out ihinting: cheat-eat hip say ship and number understood instead;

chapter ahinting

ahinting is an action applying to one number.

understand "a [number]" as ahinting when player is in Ere Say Seer and ankh is not allscored.

carry out ahinting: cheat-eat ankh bay bank and number understood instead;

chapter cheat-eat stub

to cheat-eat (la - a latinable) and (idx - a number):
	if idx < 1 or idx > not-guessed of la:
		say "The number needs to be [between-only of not-guessed of la].";
		continue the action;
	let temp be 0;
	repeat through guess-table of la:
		if can-work entry is true and tried-yet entry is false and worked-yet entry is false, increment temp;
		if temp is idx:
			say "'Hmm, you might be able to manipulate [the la] with [firstof of w1 entry] or [firstof of w2 entry].'";
			now tried-yet entry is true;
			decrease global-good-guesses by 5;
			abide by the cant-use-cheater rule;
			the rule succeeds;
	say "There's a bug here. I'm not sure how, but there is.";
	the rule succeeds.

book Ope Nay Nope

Ope Nay Nope is east of Start Art Stay. It is in Am Hey Ham. shorttext is "[if sco-talk-quiet is true]Dope[else]Nope[end if]". "You see [if did-ramp-amp is true]an incline down[else]a steep drop[end if] to the east, and Start Art Stay is back west.". printed name is "[if sco-talk-quiet is false][']Ope? Nay, Nope![else][']Ope! Day! Dope![end if]". gen-desc is "that place [ernie] opened up for you"

check going east in Ope Nay Nope:
	if sco-talk-quiet is false, say "Wyatt shakes his head, pointing to the [if did-ramp-amp is true]ramp, which does still look a little steep[else]steep drop down to the east[end if]." instead;
	if did-ramp-amp is false, say "It's too steep a drop. But maybe you could level it out a bit." instead;

Quiet Wyatt K is a moody person in Ope Nay Nope. "Quiet Wyatt K blocks your way east, though. You need to find some way to move him.". talk-text is "'[']Ope? May mope!'[paragraph break][wyatt] doesn't seem like he wants to respond to reason, or music, or gifts, or even a nice loud, slangy greeting.". description is "[wyatt] shushes you, even though you didn't say anything. He doesn't seem to want to have to deal with noise. He's wearing a yellow t-shirt that says '[']Ello? Yay?! YELLOW!'". [nopunc]

book Rue Gay Grue

Rue Gay Grue is east of Ope Nay Nope. "[if sco-use-rover-clamp-clay is false]Unfortunately, you can't see very far here, because you hear the laughter of grues. Maybe, with a working light source, you could do more[else][one of]Now you have a reliable light source, you realize you can go[or]The [rover] reveals lighted passages[stopping] east, south and back west[end if].". It is in Am Hey Ham. shorttext is "Grue". [nopunc]

check going in Rue Gay Grue:
	if sco-use-rover-clamp-clay is false and noun is not west, say "You don't want to risk going any crazy directions." instead;
	if noun is south and sco-got-stew is true, say "[Chef F Chez] is closed to the public while [feedin] whips up some tasty meals. Perhaps if you help OkayCo achieve their freedom, more people will be able to enjoy what she has to offer.[paragraph break]Anyway, the whole hi-thanks-bye-again thing would be awkward, too." instead;

after printing the locale description when player is in Rue Gay Grue:
	if It Lay Lit is off-stage:
		say "Oh my! It looks like some poor soul brought some matches for light here but never used them. You pick them up. The brand, of course, is It-Lay-Lit.";
		now player has It Lay Lit;
	continue the action;

chapter It Lay Lit

the It Lay Lit is a useful thing. printed name is "It-Lay-Lit". description is "Really just a book of matches. They seem dry and functional. You can probably USE them on something combustible."

book Chef F Chez

Chef F Chez is south of Rue Gay Grue. It is in Am Hey Ham. "You can exit back to the north of this eatery. Anything else is probably for employees only.". printed name of Chef F Chez is "[if sco-got-stew is true]Baker Acre Bay[else]Chef F (Chez)[end if]". shorttext of Chef F Chez is "[if sco-got-stew is true]Baker[else]Chez[end if]".

understand "baker acre bay" and "baker acre" and "baker/acre bay" and "baker/acre" as Chef F Chez when sco-got-stew is true.

Feedin Eden Faye is a needy person in Chef F Chez. printed name is "Feedin['] Eden Faye". description is "She is in her cooking apron, waiting for [if sco-use-spot-feedin is false]some cooking apparatus[else]ingredients to put in the [spot][end if].". "[one of]A woman walks up to you and shakes your hand. 'I'm [feedin], and I'd love to cook something nice, but my business has fallen on hard times. I don't even have anything to cook anything in. If you could help me, I'd be grateful.'[or][feedin] waits for help here.[stopping]".

The Ooh Stay Stew is a useful thing. description is "It looks delicious. Too much for you to even start eating.". printed name is "Ooh-Stay Stew".

book Ere Nay Near

Ere Nay Near is east of Rue Gay Grue. It is in Am Hey Ham. printed name of Ere Nay Near is "[if sco-use-gizmo-jelly is true]Ye're [']Ere, Yay[else][']Ere-Nay-Near[end if]". shorttext of Ere Nay Near is "[if sco-use-gizmo-jelly is true]Ye're[else]Near[end if]". "The only way out is back west[if sco-use-gizmo-jelly is true and did-use-covert is false]. With the J's, gone, you see a button labeled [covert] on the far wall[end if].".

understand "yere/yer ere yay" and "yere/yer ere" and "yere/ere/yer yay" and "yere/ere/yer" and "yay" as Ere Nay Near when sco-use-gizmo-jelly is true.

chapter Ellis J

Ellis J is a needy person in Ere Nay Near. talk-text is "Ellis J takes time out of arguing with Ellie J to glare at you for interrupting. What an unhappy person!". "[bug-together].". description is "About as unhappy looking as Ellie J.". [nopunc]

to say el-el: say "[one of]Ellis and Ellie[or]Ellie and Ellis[at random] J"

chapter Ellie J

Ellie J is a needy person in Ere Nay Near. talk-text is "Ellie J takes time out of arguing with Ellis J to glare at you for interrupting. What an unhappy person!". "[bug-together].". description is "About as unhappy looking as Ellis J.". [nopunc]

for printing a locale paragraph about a person (called per) in Ere Nay Near:
	if per is mentioned, continue the action;
	if per is Ellis J or per is Ellie J:
		say "[one of]Two people, seemingly brother and sister, squabble here over something unimportant. They can't believe ... anyway, they turn to you and seem upset you are not less miserable than they are. They introduce themselves as [el-el][or][el-el] continue to squabble[stopping].";
		now all people in Ere Nay Near are mentioned;
	continue the action;

chapter Covert Overt K

Covert Overt K is proper-named loneuse scenery. description is "Really, it's just asking to be pushed. Or in the context of this game, (U)sed or USEd.". printed name is "Covert? Overt, K!"

understand "button" as Covert Overt K when Covert Overt K is touchable.

book Blind Lined Bay

Blind Lined Bay is south of Start Art Stay. It is in Am Hey Ham. printed name of Blind Lined Bay is "[if sco-use-cliffy-small is true]Burgeon Urgin Bay.[else]Blind Lined Bay[end if]". shorttext of Blind Lined Bay is "[if sco-use-cliffy-small is true]Burgeon[else]Blind[end if]". "Not a scenic bay, but a loading bay, though nothing's being loaded right now. The only exit is back north[if sco-use-cliffy-small is true], and there's really nothing to do here. You'd like to avenge Cliffy for whatever happened to him[else if small mall say is in Blind Lined Bay]. There's a [small] off in a corner[end if]."

understand "burgeon urgin bay" and "burgeon urgin" and "burgeon/urgin bay" and "burgeon/urgin" as Blind Lined Bay when sco-use-cliffy-small is true.

chapter Ellen Say Sellin

Ellen Say Sellin is a needy person in Blind Lined Bay. printed name is "Ellen Say-Sellin[']". "[one of]A woman paces here, shaking her head. She looks up as you walk in 'Oh, hello. I'm [sellin]. But I haven't lived up to my name lately. Any help ... well, wow'[or][sellin] paces back and forth here, mumbling how she wants to live up to her name again.[stopping]". talk-text is "'Sales? Ails, say.'". description is "[sellin] looks pretty defeated. You'd like to help her, but you're not the sort of person to give a pep talk.".

chapter Small Mall Say

Small Mall Say is needy scenery. "It's not big enough for you to fit into. Maybe someone or something smaller.". printed name is "Small Mall (Say)".

chapter Aww Say Saw

the Aww Say Saw is a twoway thing. description is "It's some sort of mechanical saw, so neatly put together you can't help exclaiming 'Aww, say,' and it's [if did-use-power-saw is false]out of power[else]fully charged, now[end if].". printed name is "Aww-Say Saw".

understand "aw say saw" and "aw say/saw" and "aw" as aww say saw when player has aww say saw.

chapter scenery from Near Ere Nay

section which say switch

the which say switch is loneuse scenery. description is "The text THIS IS/THAT AT covers it. It's not clear who THEY are. You can probably USE it to try to operate it.". printed name is "which-say switch".

check taking which say switch: say "You can only USE it." instead;

wssing is an action applying to nothing.

understand "which say switch" and "which say" and "which switch" and "which" as wssing when which say switch is touchable.

carry out wssing: try useing the which say switch;

section wait eight way

the wait eight way is loneuse scenery. description is "It's a switch, like the [switch]. Perhaps you can USE it[if wait-count > 0] to reset the number above, which reads [wait-count][end if].". printed name is "wait-eight-way".

wewing is an action applying to nothing.

understand "wew" as wewing when wait eight way is touchable.

understand "eight" and "eight way" as wait eight way when wait eight way is touchable.

carry out wewing: try useing the wait eight way instead;

volume Brain Reign Bay

there is a backdrop called the all way wall. description is "It appears to be blocking your way to the center.". printed name is "all-way wall".

when play begins:
	move way wall backdrop to all wally rooms;

the edge way wedge is a useful thing. printed name is "edge-way wedge". description is "It's a sort of pickaxe, useful for helping you climb up solid but otherwise impassable surfaces."

definition: a room (called rm) is ray-doable:
	if rm is Bling Ling Bay or rm is Blown Lone Bay, yes;
	if rm is Cornery Ornery Cay or rm is Cracked Wracked Cay or rm is Claim Lame Cay, yes;
	no;

after printing the locale description of a beachroom:
	if location of player is ray-doable:
		if location of player is not rayable:
			bold-note "You will now be able to REACH this corner location from Am-Hey-Ham.";
			now location of player is rayable;
	continue the action;

chapter ankh coding

[we find the ankh at the first "Bay" room]

the ankh bay bank is a latinable. description is "The ankh bay bank[if did-skip-ankh is true] that popped into your hands just now[end if] pulses with mystical energy. The loopy bit is notched into [total-score of ankh bay bank] arcs, [got-score of ankh bay bank] of which [is-are of got-score of ankh bay bank] dark.[paragraph break]While it doesn't feel as powerful as the Raid Aid Ray, you expect it may work similarly[if ankh bay bank is not unscored].[paragraph break]You can READ the ankh to recall how you've used it so far[end if].". guess-table of ankh bay bank is table of ankh bay bank guesses. help-verb is "A". printed name is "ankh bay-bank". known-rule of ankh bay bank is ankh-known rule. clue-chunk of ankh bay bank is "arc". clue-chunk-plural of ankh bay bank is "arcs". preuse-text of ankh bay bank is "The ankh seems to need a word to invoke it, being kind of mystic and all.".

this is the ankh-known rule:
	if the player carries the ankh, the rule succeeds;
	the rule fails;

after printing the locale description of a beachroom in Brain Reign Bay:
	if did-ray-ankh is true and ankh is off-stage:
		say "Wait! What's this? It's the ankh you summoned! I suppose it had to pop up here, instead of just in your hands, so it could officially be an ankh-bay-bank. Anyway, it pulses with life and possibilities. A brief look at [who ooh hey] indicates that it is, indeed, an Ankh Cray-Crank, which can magically morph into other things or open new emotions and moods and possibilities, much like the ray that created it.";
		now player has ankh bay bank;
	continue the action;

chapter Eight Bay Bait

Eight Bay Bait is a useful edible thing. description is "It's a packet of a bunch of pellets that look unfit for human consumption.". [nopunc]

[?? map irrelevant words in room description to parser error]

after printing the locale description (this is the bait appears rule):
	if mrlp is not Brain Reign Bay, continue the action;
	if location of player is unvisited and number of visited rooms in Brain Reign Bay is 7: [the current room is not marked as visited yet]
		say "You look around. You find a small packet of ... well, EIGHT BAY BAIT. It must be useful for something. You take it.";
		now player has Eight Bay Bait;
	continue the action;

book Bleak Leak Bay 0 0

Bleak Leak Bay is a rayable beachroom in Brain Reign Bay. printed name of Bleak Leak Bay is "[if sco-use-clod-sleek is true]Bridge Ridge[else]Bleak Leak[end if] Bay". "[if sco-use-clod-sleek is false]Maybe you could go south or east here once things stopped leaking, but right now, you can't. In particular, a [sleek] seems to be the worst offender. Maybe you could plug it up[else]Now that you plugged the leak, you see bridges to the east and south[end if].". shorttext is "[if sco-use-clod-sleek is false]Bleak[else]Bridge[end if]".

understand "bridge ridge bay" and "bridge ridge" and "bridge/ridge bay" and "bridge/ridge" as Bleak Leak Bay when sco-use-clod-sleek is true.

check going in Bleak Leak Bay when sco-use-clod-sleek is false:
	if noun is south or noun is east, say "It's too leaky to go anywhere. Yet." instead;

book Bruise Rues Bay 1 0

Bruise Rues Bay is a beachroom in Brain Reign Bay. It is east of Bleak Leak Bay. "This is an east-west shoreline [if sco-talk-thump is false]you're too tense to appreciate[else]you're more able to appreciate now, with [thump] gone[end if].". shorttext is "[if sco-talk-thump is false]Bruise[else]Blues[end if]". printed name is "[if sco-talk-thump is false]Bruise Rues[else]Blues-Lose[end if] Bay". indir is south.

understand "blues lose bay" and "blues/lose bay" and "blues lose" and "blues/lose" as Bruise Rues Bay when sco-talk-thump is true.

check going east in Bruise Rues Bay when sco-talk-thump is false: say "No, you're too scared of a physical confrontation with [thump] at the moment. Perhaps you need to show [thump] you don't have fear." instead;

check going west in Bruise Rues Bay when sco-talk-thump is true and Blight Light Bay is unvisited: say "You suppress your curiosity about what [thump] was guarding, for more familiar terrain. Maybe later." instead;

[?? ruse ]

chapter Ump They Thump

Ump They Thump is a booky person in Bruise Rues Bay. "[one of]As you look around, you're surprised by a shove from behind. Someone much bigger than you immediately starts explaining how the hateful thoughts you had after you were pushed are far, far worse than you actually being pushed. You feel guilty falling for this[or][thump], who thumped you earlier, stands here, arms crossed, ready to thump you again. They seem to want a fight. Or perhaps they just enjoy being threatening, because that lasts longer than just beating someone up, and it takes less energy, too[stopping].". talk-text is "'Geek!' This is, of course, intended to make you get mad at what they didn't say, and also to 'prove' you're homophobic because you didn't want to hear the rest, even if [thump] isn't the sort of person who'd actually say 'Eek.'[paragraph break][book-didnt-work].". description is "[thump] seems to want a fight, and perhaps they might get bored if you were able to stand your ground. As it is, you feel nervous under their gaze, so it's more feeling paralyzed than not backing down. Perhaps if you showed [thump] you couldn't be pushed around... physical measures may not work here.". printed name is "Ump-They-Thump".

to say book-didnt-work:
	say "[if last-helpbook is Aid Fray Fraid]You can't get a read on what [the noun] wants, or what would disgust them into leaving. Perhaps there is a way or place to study possible options and methods to get past [the noun]. Maybe you've already been there[else]During that conversation, passages from [last-helpbook] went through your head, but none seemed to work"

check talking Ump They Thump:
	if last-helpbook is Strife Rife Stay:
		say "You try to apply the lessons of [strife] to your newfound bully. You feel like you haven't really internalized it, but it's ... well ... something. [thump] looks more taken aback than expected. When you stand your ground, [thump] immediately proclaims you a bore who's really not worth it, proceeding to explain they'll have to go pick on someone who's even worse at not being bullied, and their pain is your fault. It makes your head spin a bit, but [thump] is gone. You wait in fear for a few minutes to make sure [thump] doesn't come back. They don't.[paragraph break]The path east is clear now.";
		increment the score; [cmd:T UMP THEY THUMP]
		moot Ump They Thump;
		now sco-talk-thump is true;
		the rule succeeds;

book Blight Light Bay 2 0

Blight Light Bay is a beachroom in Brain Reign Bay. It is east of Bruise Rues Bay. shorttext is "[if sco-use-phone is true]Bright[else]Blight[end if]". "You can go back west, [if sco-use-phone is false]but the ways east and south are blocked by a massive Ark Day Dark, casting inexplicable darkness across the bay[else]or, with the Ark Day Dark gone, east or south[end if].". printed name is "[if sco-use-phone is false]Blight Light[else]Bright Right[end if] Bay". indir is south.

understand "bright right bay" and "bright right" and "bright/right bay" and "bright/right" as Blight Light Bay when sco-use-phone is true.

the Ark Day Dark is scenery in Blight Light Bay. "It's a source of unnatural darkness. All the wisdom or art in the world feel futile against it. How to dispel it?". printed name is "Ark Day-Dark".

check going in Blight Light Bay when Ark Day Dark is touchable:
	if noun is east or noun is south, say "It's too scary to enter the [ark day dark]! You'll need to neutralize it or get rid of it somehow." instead;

book Booze Ooze Bay 3 0

Booze Ooze Bay is a beachroom in Brain Reign Bay. It is west of Berth Earth Bay. It is east of Blight Light Bay. printed name of Booze Ooze Bay is "[if sco-use-cup-keg is true]Beer [']Ere Bay[else]Booze Ooze Bay". "You can go back west to [Blight Light Bay][if sco-use-cup-keg is false], but a large and disturbing and terribly smelly [keg] blocks your way east. Perhaps there were bars here once, but they are boarded up now[else] or east[berth-if-did]. You can also go inside to the [stale][end if]. [if sco-use-cup-keg is false]It's boozy and depressing here[else]Now you've used the cup on the booze, things are happier[end if].". shorttext is "[if sco-use-cup-keg is true]Beer[else]Booze[end if]". indir is south.

to say berth-if-did: if did-east-berth is true, say " to [berth]"

understand "beer ere bay" and "beer ere" and "beer/ere bay" and "beer/ere" as Booze Ooze Bay when sco-use-cup-keg is true.

check going east in Booze Ooze Bay (this is the open Berth from the west rule):
	if sco-use-cup-keg is false:
		say "The [keg] is much too big. It's blocking your way. Perhaps you could remove it." instead;
	if did-east-berth is false:
		say "Oh, hey. as you go east through the narrow passage, things look familiar. It's Berth Earth Bay! And what's more, your experience and skill in navigating narrow passages leads you to see another passage here to the south.";
		now did-east-berth is true;

chapter Ale Grey Grail

The Ale Gray Grail is a useful thing. printed name is "Ale Gray-Grail". description is "Well, it looks pretty classy, for alcohol. Too classy for you."

chapter Egg K Keg

The Egg K Keg is needy scenery in Booze Ooze Bay. "It's, well, a monstrous, smelly barrel blocks you from seeing what's east. You can see where the ale comes out, but you can't see any mechanism on the [keg].". printed name is "Egg-K Keg"

chapter Stale Ale Stay

Stale Ale Stay is scenery. "[stale] is [if sco-enter-stale is true]doing well. No need to disturb it further[else]a bit empty. Maybe you can figure a way to help it and ENTER it later[end if].". [nopunc]

check entering Stale Ale Stay:
	if sco-enter-stale is true, say "You entered [stale] already and helped it to become prosperous. You don't need to do any more. Bars aren't really your scene, anyway." instead;
	if last-song is not Our Bay Bar, say "You enter [stale], but boy, is it dead. You don't really have anything to add besides awkward conversation. You shuffle out." instead;
	say "Boy! It's quiet in here! Unconsciously, you begin whistling [our bay bar]. Out comes a bartender. 'That's great! Where did you find that?' You explain the [tone say stone], but before you get totally lost, they cut you off and ask you to just get on with repeating the tune. You do, and they even record it. From that song, they extrapolate a bunch of others that would make a good playlist. [stale] now has ambiance. They don't know how to thank you, so they hand you a [drum] along with a sort of mini-cooler: [dice].[paragraph break]You don't have time to waste in a bar, though. You can't afford to spend time off in some unreal dreamland. At least, not one you can't save. You exit, prepared for more adventure.";
	now player has Rum Day Drum;
	now player has Ice Day Dice;
	increment the score; [cmd:ENTER STALE ALE STAY]
	the rule succeeds;

chapter Ice Day Dice

the Ice Day Dice is a latinable. "It's cold to the touch and divided into [total-score of ice day dice in words] pie slice-shaped sectors. [got-score of ice day dice in words] [is-are of got-score of ice day dice] either filled, or ruined by whatever filled them[if ice day dice is not unscored and ice day dice is not allscored]. You can READ it to see what's been filled[end if].". guess-table of Ice Day Dice is table of oil guesses. help-verb is "O". midpart is "-Eat-". known-rule of Ice Day Dice is dice-known rule. clue-chunk of Ice Day Dice is "sector". clue-chunk-plural of Ice Day Dice is "sectors". preuse-text of ice day dice is "The [dice] can store what is needed. Then you can use whatever is in the [dice].". printed name is "Ice-Day Dice".

this is the dice-known rule:
	if player carries ice day dice, the rule succeeds;
	the rule fails;

chapter Rum Day Drum

the Rum Day Drum is a useful thing. description is "It's got a lot of rum in the drum. You'd have to love booze a lot in order to drink it. Or want to.". printed name is "Rum-Day Drum".

book Berth Earth Bay 4 0

Berth Earth Bay is a rayable beachroom in Brain Reign Bay. It is east of Booze Ooze Bay. "Odd clay lies around here[if sco-vg-clod is false], but how to take it? [else], and you can take more if need be with [b]CLOD[r]. [end if]You [if did-east-berth is false]don't see any other way out, but you can always [om][else]can finagle passage west or south[end if].". shorttext is "Berth". it is beachy. printed name is "Berth-Earth Bay".

the odd clay is scenery in Berth Earth Bay. "[if sco-vg-clod is false]Who knows when you might need clay? You suspect you need it in a certain amount or shape[else]You can take another CLOD [if-have-clay] you need[end if].". [nopunc]

check taking clay: say "You'd have to find the right thing to form it into." instead;

to say if-have-clay: say "[if already-clod]once[else]if[end if]"

check going west in Berth Earth Bay: if Booze Ooze Bay is unvisited, say "You can't find a way west. At least, not yet." instead;

chapter clod

the clod is a useful thing. description is "It's a clod of odd clay you broke off from Berth Earth Bay. Weirdly, if a small chunk falls off, a new one replaces it.". [nopunc]

understand "odd/clay clod" and "odd/clay" and "odd clay" and "odd clay clod" as clod when player is not in Berth Earth Bay and player has clod.

chapter all day doll

there is a thing called the all day doll. it is loneuse. description is "It's a clay lump shaped like a doll. Lifeless. For now.". printed name is "all-day doll".

chapter cloding

cloding is an action applying to nothing.

understand the command "clod" as something new.

understand "clod" as cloding when player is in Berth Earth Bay or sco-vg-clod is true.

carry out cloding:
	if sco-vg-clod is true and player is in Bleak Leak Bay and player has clod:
		say "You [b]USE[r] the clod...";
		try useing clod instead;
	if already-clod:
		say "You already have a clod you broke off. You need to figure where[if sco-use-clod-sleek is true] and with what[end if] to [b]USE[r] it." instead;
	if sco-vg-clod is false:
		say "Yes. That's how to break something off. You break off a clod of clay. By the way, you don't have to come back here next time you might need a clod. You can just type [b]CLOD[r].[paragraph break]Since clay has lots of potential uses, you figure there's probably somewhere you could USE it effectively.";
		now sco-vg-clod is true;
		increment the score; [cmd: clod]
		now player has clod;
		the rule succeeds;
	if day doll is off-stage:
		say "As you pick some more clay out, it morphs into -- well, a doll, but not a very good one.";
		now player has day doll;
	the rule succeeds.

book Oats Bay 0 1

this is the ship sails to you rule:
	if sta-just-used-ship is true:
		now sta-just-used-ship is false;
		continue the action;
	if player is not in Oats Bay:
		say "You can take the [b]SHIP[r] back to the mainland at any time, or you can look for another isle to explore.";
	else if hip say ship is not in location of player:
		if debug-state is true, say "DEBUG NOTE: [ship] in [location of hip say ship], you in [location of player].";
		say "The [ship] sails into view as you arrive. Hip! Say!";
		move hip say ship to location of player;

after printing the locale description when sco-vg-boats is true and location of player is shippy:
	process the ship sails to you rule;
	continue the action;

Oats Bay is a beachroom in Brain Reign Bay. It is south of Bleak Leak Bay. printed name of Oats Bay is "[if hip say ship is off-stage]Oats Bay[else]Boats[end if]". "A north-south shoreline. [if hip say ship is off-stage]You're not sure what oats are doing here. They aren't very natural for a bay. What could be more natural?[else if hip say ship is in Oats Bay]The [ship] is waiting for you to take it on a trip to an isle somewhere. Just say the word.[else if hip say ship is moot]You've done all you can here. The [ship] is long since gone.[else]You're back at Oats Bay. You remember leaving the [ship] elsewhere on an isle...[end if]". indir is east.

the hip say ship is a plural-named latinable. "The [ship] is waiting to take you wherever you need to go. Several lines of TO ISLE ? ? are written on its side, under the less helpful blurb 'Ailing? Say, SAILING!' [if got-score of hip say ship is 0]Perhaps you need to fill in one, or both, of the question marks, and the boats will follow orders. You keep thinking to yourself, 'Eh, I'll...' Which seems artificial. But maybe it will lead somewhere[else]You could READ the [ship] to see where you've been and where you could go[end if].". understand "boat" and "boats" as hip say ship. guess-table is table of isle guesses. help-verb is "I". known-rule of hip say ship is isles-known rule. printed name is "hip-say ship". preuse-text of hip say ship is "You need to find an isle for the [ship] to go to.".

this is the isles-known rule:
	if hip say ship is off-stage, the rule fails;
	the rule succeeds;

check going outside when mrlp is Eee Say Sea: try boatsing instead;

section sleek leak say

the sleek leak say is needy scenery in Bleak Leak Bay. "This leak seems particularly bad. If there were a way to gum it up, you bet you could plug the others easily.". printed name is "sleek leak (say)".

chapter boatsing

boatsing is an action applying to nothing.

understand the command "boats" as something new.
understand the command "boat" as something new.

understand "boats" as boatsing when hip say ship is off-stage and player is in Oats Bay.
understand "boat" as boatsing when hip say ship is off-stage and player is in Oats Bay.

carry out boatsing:
	now sta-just-used-ship is true;
	say "Of course boats belong here! Well, there aren't that many, and they appear to be auto-piloted somehow. You check each of them out. They all look sturdy, but only one seems to help you with where you want to go. It is obviously a [ship], and you should probably examine or read it to try and figure the places it can go![paragraph break]Also, you can say [b]SHIP[r] to summon it or go back to it, if somehow you lose track.";
	now sco-vg-boats is true;
	increment the score; [cmd: boats]
	move hip say ship to Oats Bay;
	the rule succeeds.

chapter shiping

shiping is an action applying to nothing.

understand the command "ship" as something new.
understand "boats" as shiping when can-see-ship.
understand "boat" as shiping when can-see-ship.
understand "ship" as shiping when can-see-ship.

carry out shiping:
	now sta-just-used-ship is true;
	if mrlp is Eee Say Sea:
		say "[if location of player is isle-no-ship]After a brief walk to Isle Tray Trial, y[else]Y[end if]ou take the [ship] back to the erstwhile Oats Bay.";
		move hip say ship to Oats Bay;
		move player to Oats Bay;
		the rule succeeds;
	if sco-vg-boats is true:
		if player is in Oats Bay, say "The [ship] is nearby, so you don't need to call it. You probably want to give it instructions on where to go. Which isle, in other words." instead;
		if mrlp is Brain Reign Bay:
			say "You walk over to the [ship] at [Oats Bay]...";
			drop-player-at Oats Bay;
			now sta-announced-trays is false;
		else:
			say "You can't physically reach the [ship] from here.";
		the rule succeeds;

book Weird Eared Way 1 1

Weird Eared Way is a room in Brain Reign Bay. shorttext is "Weird". "You can go back east. [ears fey fears][if ears fey fears are moot] no longer[end if] block your way south.". printed name is "Weird-Eared Way".

check going south in Weird Eared Way:
	if ears fey fears are not moot:
		say "The [ears fey fears] stretch out and block progress to the south. You probably can't attack them, but the right sound might disrupt them if you TALK to them." instead;

check talking Ears Fey Fears:
	if last-song is Stone Tone Say and raw-mood of "rage":
		say "You can't quite talk, but you can sing. And boy, do you sing! Not well, mind, but it's probably better that way. The ears crinkle up and vanish.";
		now sco-talk-fears is true;
		increment the score; [cmd: T EARS FEY FEARS]
		moot ears fey fears;
		the rule succeeds;
	if last-song is Stone Tone Say:
		say "[if did-ever-song is true]You whistle a tune as you go past, but the ears don't seem to mind it, even though it's off-key and planned that way[end if]." instead;
	if raw-mood of "rage":
		say "The [fears] seem to curl up for a moment but recover quickly." instead;

chapter Ears Fey Fears

The Ears Fey Fears are complex scenery in Weird Eared Way. printed name is "Ears-Fey-Fears". description is "They seem unusually attuned to you, as if waiting for you to breathe wrong.".

check talking Ears Fey Fears: say "The ears listen a bit but close ranks to show you they aren't moving aside from you. Maybe you need some less verbal cues, and more than one." instead;

book Whale Ail Way 2 1

Whale Ail Way is south of Blight Light Bay. It is in Brain Reign Bay. It is wally. It is east of Weird Eared Way. shorttext is "[if sco-use-cable-blower is true]Which[else]Whale[end if]". printed name is "[if sco-use-cable-blower is true]Which-Ich Way[else]Whale Ail Way[end if]". "[if sco-use-cable-blower is false][one of]Now you're getting somewhere, you hope! You've had enough of all these bays.[or]The only way back is north.[stopping][else if sco-use-pole-sink is false]You can now go east, west and north with the Lower Bay Blower gone, but an imposing [wall] blocks your way south. There is, however, some [sink] a few feet in front of it.[else]You can go in any direction now that you vaulted over the All-Way Wall.[end if]".

check going up in a wally room: say "The [wall] is too slippery to climb, and it's too high to jump on your own. But there's got to be some way over it."

check going south in Whale Ail Way:
	if sco-use-pole-sink is false, say "You can't climb up the [wall]." instead;

after printing the locale description for Whale Ail Way when sco-use-cable-blower is false:
	say "The [blower] [one of]sings[or]keeps singing an odd, enticing song[stopping]. Perhaps it's the only way it knows to ask for help.";
	continue the action;

understand "which ich way" and "which ich" and "which/ich way" and "which/ich" as Whale Ail Way when sco-use-cable-blower is true.

chapter lower bay blower

the Lower Bay Blower is a needy thing in Whale Ail Way. "[one of]As you walk south, you notice something splayed out in a huge semicircle. You consult your notes. It is a large sea animal: a Lower Bay Blower! It appears to be beached. Maybe you can help it. You'd probably need some help, or a tool, to do so[or]The Lower Bay Blower is flopped here, looking for help to get back to the water[stopping].". description is "Boy! It's big and stranded! It would be nice if you could find a safe way to drag it back to the sea.". [nopunc]

chapter All Way Wall

after printing the locale description:
	if location of player is wally:
		say "An [way wall] blocks your path to the center. It seems [if number of visited rooms in Brain Reign Bay < 22 and player does not have ol pay pole]a bit beyond you[else]somewhat less intimidating now[end if]."

chapter Ink Say Sink

the Ink Say Sink is needy scenery. "[if sco-use-pole-sink is false]It's not what's written, but rather, the shape of the depression. Three-dimensional, with two trapezoids--a short far one and a long near one--sharing a horizontal edge, and two triangles bordering on each of them. An odd shape. Where have you seen it before?[else]It's a pole-vaulter's pit, really, as you know, since you used it to jump over the [way wall].". printed name is "Ink-Say-Sink".

check taking Ink Say Sink: say "It's just ink, etched into the ground." instead;

book Whiffy Iffy Way 3 1

Whiffy Iffy Way is east of Whale Ail Way. It is in Brain Reign Bay. printed name of Whiffy Iffy Way is "[if sco-use-quill-stink is true]Wider Eider Way[else]Whiffy Iffy[end if] Way". shorttext of Whiffy Iffy Way is "[if sco-use-quill-stink is true]Wider[else]Whiffy[end if]". "This passage bends west to south[if sco-use-quill-stink is true]. The source of the smell is a sort of river: [one of]according to [ooh hey who], [or][stopping]the [stink][end if].".

understand "wider eider way" and "wider eider" and "wider/eider way" and "wider/eider" as Whiffy Iffy Way when sco-use-quill-stink is true.

chapter Ink Stay Stink

the Ink Stay Stink is needy scenery in Whiffy Iffy Way. printed name is "Ink-Stay-Stink". "It looks dark and forbidding. Even if it didn't smell, it'd get all over you. Yuck. You need something that could maybe siphon it out or clean it up or something."

book Bland Land Bay 4 1

Bland Land Bay is a beachroom in Brain Reign Bay. It is south of Berth Earth Bay. "[if sco-use-sod-brute is false]A mean [brute] blocks your way south. It's a pretty aggressive plant. Until it's gone, you can only go back north[else]It's nicer here with the [brute] gone, but you can really only go north or south[end if].". indir is west. printed name is "[if sco-use-sod-brute is true]Bland Land Bay[else]Bloom Loom Bay[end if]". shorttext is "[if sco-use-sod-brute is true]Bloom[else]Bland[end if]".

understand "bloom loom bay" and "bloom loom" and "bloom/loom bay" and "bloom/loom" as Bland Land Bay when sco-use-sod-brute is true.

check going south in Bland Land Bay: if sco-use-sod-brute is false, say "The [brute] rises up and lashes out at you. Before it can grab and choke you, you move back north." instead;

chapter Root Bay Brute

the Root Bay Brute is needy scenery in Bland Land Bay. "It's kind of mobile and hostile. If you managed to bury it back in the dirt, or with dirt, perhaps it would be slowed down, and it would grow into something more productive and interesting.". [nopunc]

chapter Rose Gay Grows

The Rose Gay Grows is a useful thing. printed name is "Rose Gay-Grows". description is "Simple and natural and beautiful and, bonus, no thorns! You'd have to be a really uncultured thug not to appreciate this. Of course, it smells nice, too.".

book Bawl All Bay 0 2

Bawl All Bay is a renameable beachroom in Brain Reign Bay. It is south of Oats Bay. shorttext is "[if sco-use-bat is true]Blather[else][bawl-ball][end if]". printed name is "[if sco-use-bat is true]Blather Lather[else][bawl-ball] All[end if] Bay". indir of Bawl All Bay is east. "A north-south shoreline[if sco-use-bat is true]. The blather-lather is thick here. You can't do much about it. Especially since you recognize it as just talk[end if].".

to say bawl-ball: say "[if sco-use-bat is true]Blather[else if bawl all bay is altnamed]Ball[else]Bawl[end if]"

understand "ball" and "ball all/bay" and "ball all bay" as Bawl All Bay when Bawl All Bay is ever-alt.

understand "blather lobbyist bay" and "blather lobbyist" and "blather/lobbyist bay" and "blather/lobbyist" as bawl all bay when sco-use-bat is true.

chapter at bay bat

The at bay bat is a loneuse thing. description is "The bat is rather large and lightweight. It's probably better for defense than offense.". printed name is "at-bay bat". "[one of]An at-bay bat lies here. You didn't see it before. It must've been the [switch] that sent it here, now that you changed things from Bawl to Ball[or]The at-bat bat you managed to summon lies here. Perhaps you should just TAKE it[stopping]."

book What Hut Way 1 2

What Hut Way is south of Weird Eared Way. It is in Brain Reign Bay. It is wally. description is "You can go north and south[if eat chez sheet is touchable]. A [sheet] here advertises places to eat, but they're rubbed out, and you'll have to figure them[end if].". printed name of What Hut Way is "[if eat chez sheet is allscored]Waste-Aced Way[else unless eat chez sheet is unscored]Wise-Eyes Way[else]What Hut Way[end if]". shorttext of What Hut Way is "[if eat chez sheet is allscored]Waste[else unless eat chez sheet is unscored]Wise[else]What[end if]".

understand "wise eyes way" and "wise eyes" and "wise/eyes way" and "wise/eyes" as What Hut Way when eat chez sheet is not unscored.

understand "wise eyes way" and "wise eyes" and "wise/eyes way" and "wise/eyes" as What Hut Way when eat chez sheet is allscored.

check going south in What Hut Way: if Eat Chez Sheet is not allscored, say "As you go south, you look back at the [sheet]. Perhaps there is more to do later. But for now, onward!"

chapter Eat Chez Sheet

the Eat Chez Sheet is a latinable in What Hut Way. guess-table is table of eat chez sheet guesses. help-verb is "E". midpart is "-Eat-". "It's a sheet of metal, upright. It [if eat chez sheet is unscored]is completely illegible, much like the [raid]'s settings before you figured any out, so READing it isn't a help at the moment[else if eat chez sheet is allscored]is all filled in[else]has some places you figured out filled in[end if].". known-rule of Eat Chez Sheet is sheet-known rule. preuse-text of eat chez sheet is "You need to discover what places should be listed on the [sheet].". printed name is "Eat-Chez Sheet".

this is the sheet-known rule:
	if What Hut Way is visited and Eat Chez Sheet is not moot, the rule succeeds;
	the rule fails;

check taking Eat Chez Sheet: say "It's a metal sheet, not a bedsheet or sheet of paper. So, no." instead;

section Treat Eat Tray

the Treat Eat Tray is a useful thing. description is "All sorts of goodies that would put an adventurer like you out of shape. I mean, if you started to eat just one, you'd eat them all. Okay, I would. They're that tasty-looking and that tasty!". printed name is "Treat-Eat Tray".

section Seat Eat Say

the Seat Eat Say is a useful thing. description is "Well, it's not just one seat, but a bunch compacted very efficiently. You're not sure how it works. Perhaps some sort of fourth-dimensional physics is involved. I mean, you already have the [please], here, and that's weird enough.". printed name is "Seat-Eat-Say".

section Ughs Bay Bugs

the Ughs Bay Bugs is a singular-named useful thing. description is "Maybe this packet is tasty if you're not a person.". [nopunc]

section Red Bay Bread

the Red Bay Bread is an ingredient. description is "You can't tell one sort of bread from another most of the time, but this stuff looks pretty ritzy. Of course, the founder of the company was a chap named Ed Brey.". indefinite article is "some". [nopunc]

book Air Stay Stare 2 2

Air Stay Stare is a room in Brain Reign Bay. It is south of Whale Ail Way. printed name is "[if sco-use-pole-sink is true]Center: Enter, Say[else]Air-Stay-Stare[end if]". shorttext is "[if sco-use-pole-sink is true]Center[else]Stall[end if]". "Perhaps this was an All-Stay Stall before you vaulted over the [wall]. [if sco-use-pole-sink is false]But there must be more to here than just a place for a alpha-male to have others stare at how great he is. That's all that's happening here now, though[else]With [swill] gone, the view is rather nice, but you need to be moving on[end if]. With the [wall] collapsed, you can go back north[if sco-use-dove-swill is true] or, with [swill] gone, down[end if].".

understand "center/enter say" and "center/enter/say" and "center enter" as Air Stay Stare when sco-use-pole-sink is true.

chapter Will Say Swill

Will Say Swill is a needy person in Air Stay Stare. printed name is "Will-Say-Swill". "[one of]A man talks to himself here loud enough to be overheard. When he sees you he introduces himself as [swill], which he's appropriated ironically from all the losers and haters. He waits for acknowledgement of his cleverness. When he gets none, he suggests you will learn, unless you are one of those cheesy do-gooders.[or][swill] continues to sort of talk to himself, sincerely hoping you can appreciate his honesty. Or bluntness. Whichever.[stopping]". talk-text is "You can't seem to get a word in edgewise. But he does bang on about how traditional boring niceniks and sheeple need to come to the dark side and see the light, and that's just common sense.". description is "He's dressed like regular folk. He looks like regular folk. Except for the whole driving you to confusion with what he is saying.[paragraph break]Oh. And he has a tattoo. Not just of any animal, but of an I-Purvey Viper. He probably prefers animals like that."

book Wit It Way 3 2

Wit It Way is south of Whiffy Iffy Way. It is in Brain Reign Bay. It is wally. printed name is "[if sco-talk-stim is true]Wit['] It[else]Worthy Earthy[end if] Way". shorttext is "[if sco-talk-stim is true]Worthy[else]Wit['][end if]". "A north-south passage.".

understand "worthy earthy way" and "worthy earthy" and "worthy/earthy way" and "worthy/earthy" as Wit It Way when sco-talk-stim is true.

section blocking your way here

this is the wit-it-block rule:
	if sco-use-quill-stink is false or sco-use-clear-ear-clay is false, say "You encounter a fellow introducing himself as [stim]. He somehow argues that since you haven't figured both ways to [wit], you aren't truly with-it, and you need to go back where you came from. Somehow, you agree with this. [stim] stalks back away [the best route from the location of the player to Wit it Way]." instead;

check going north in Waffle Awful Way: abide by the wit-it-block rule;

check going south in Whiffy Iffy Way: abide by the wit-it-block rule;

chapter Tim Say Stim

Tim Say Stim is a booky person in Wit It Way. "[one of]A hyperactive fellow stands here. You're jealous of his energy. He's all about the backslapping and zest for life and all that sort of thing, and he'd really like you to want to be like him, or you are wasting your life and you belong with no-fun OkayCo[or][stim] continues to shadow-box some unseen (and likely less in-your-face) foe and practice motivational mantras so you can hear them[stopping].". printed name of Tim Say Stim is "Tim Say-Stim". talk-text is "He begins a depressing paean to his girlfriend, Ellen-Yay-Yellin['], who has almost as much zest for life as he does. 'WHOAH THERE, YOU SEEM JEALOUS, BUT THAT'S OKAY. I'M A POSITIVE KIND OF GUY,' he follows up. Ugh.". description is "A cut-rate Tony Robbins. Ugh."

check talking Tim Say Stim:
	if last-helpbook is Oft Say Soft:
		say "Usually, if you talked softly, it would be seen as intimidation. But now it's a bit more like jujitsu. You break down [stim]'s aphorisms into something that could work even if you're less hyper. He's rather upset by this. It's a shortcut and an unfair one at that. As his voice grows louder, you grow calmer. He berates you for being a concern troll, and he lets you know one day -- one day -- you'll wish you were more exciting and took his advice. But he is not going to waste time on you.[paragraph break]Behind him you see an unusual tool: an [ever lay lever]. Probably part of some useless motivational rubbish, but it could be practical. You take it.";
		now sco-talk-stim is true;
		moot tim say stim;
		increment the score; [cmd: t tim say stim]
		now player has ever lay lever;
		the rule succeeds;

chapter Ever Lay Lever

the ever lay lever is a useful thing. description is "Who knows what it could move, where?". printed name is "ever-lay lever".

book Brood Rude Bay 4 2

Brood Rude Bay is a beachroom in Brain Reign Bay. It is south of Bland Land Bay. "This is a north-south stretch[if sco-talk-cross is true], a nice place, but not much to do here with Cross Ross K gone[end if].". shorttext is "[if sco-talk-cross is true]Bare[else]Brood[end if]". printed name is "[if sco-talk-cross is true]Brood Rude Bay[else]Bare Air Bay[end if]". indir is west.

understand "bare air bay" and "bare air" and "bare/air bay" and "bare/air" as Brood Rude Bay when sco-talk-cross is true.

chapter Cross Ross K

Cross Ross K is a moody person in Brood Rude Bay. "Cross Ross K blocks your passage south. He seems to be complaining about anything and everything, and no amount of commiseration (or lack) would seem to stop him.". description is "Cross Ross K scowls at you, and after you take a step back, he complains about your body language for a bit.". talk-text of Cross Ross K is "'Nerd [']eard? NAY!' moans Cross Ross K, in a fit of self-pity. It's pretty obvious he can go on like this if not stopped, and it's also obvious the way to stop him is not to escalate things.". [nopunc]

check going south in Brood Rude Bay:
	if Cross Ross K is touchable, say "Cross Ross K blocks you with an 'Oh, Way, Whoah.'" instead;

book Blurring Luring Bay 0 3

Blurring Luring Bay is a beachroom in Brain Reign Bay. It is south of Bawl All Bay. printed name of Blurring Luring Bay is "[if sco-use-visor-blot is true]Bleary Leery Bay[else]Blurring Luring Bay[end if]". shorttext of Blurring Luring Bay is "[if sco-use-visor-blot is true]Bleary[else]Blurring[end if]". indir is east. "[if sco-use-visor-blot is true]While your eyes are fully in focus now, you can no longer see Blot Lot Bay, but you don't need to. You're worried what other tricks they might play on you[else]Ugh. It's tough to see much here, but [who ooh] indicates [blot] may be worth a look. You have to focus a bit, but ah, there it is[end if]. At least passage north or south seems safe."

understand "Bleary Leery Bay" and "bleary leery" and "bleary/leery bay" and "bleary/leery" as Blurring Luring Bay when sco-use-visor-blot is true.

chapter Blot Lot Bay

Blot Lot Bay is needy scenery in Blurring Luring Bay. "You can't really see it. It sort of wavers if you try to focus.". printed name is "Blot-Lot Bay".

chapter Rain Day Drain

the Rain Day Drain is a useful thing. description is "It's weird-looking, but it can't be too hard to use if you need a plumbing-related task.". printed name is "Rain-Day-Drain".

book Was Us Way 1 3

Was Us Way is south of What Hut Way. It is in Brain Reign Bay. printed name of Was Us Way is "[if sco-talk-skid is true]Wham-Am Way[else]Was Us Way[end if]". shorttext of Was Us Way is "[if sco-talk-skid is true]Wham[else]Was[end if]". description is "The southwest corner of Brain Reign Bay's inner ring. Passages lead north or east.".

understand "wham am way" and "wham am" and "wham/am way" and "wham/am" as Was Us Way when sco-talk-skid is true.

chapter Kid Say Skid

Kid Say Skid is a booky person in Was Us Way. "[skid] stands here, whining about how OkayCo was all well and good when they were less worldly, but now OkayCo is so basic and the [factual] are totally so much more lifelike.". talk-text is "[skid] expounds on why everything has gone down the drain. OkayCo is so bad, they've even poisoned Brain Reign Bay, which isn't what it used to be, now that people like you have found the inner circle (no offense.) [skid] keeps up a real rhythm here, almost giving you outsiders credit for something, before getting all 'On the other hand...' It's hard to get a word in edgewise.". printed name of Kid Say Skid is "Kid-Say-Skid". description is "[skid] gesticulates constantly while complaining.".

check talking Kid Say Skid:
	if last-helpbook is Shut Hut Say:
		say "You realize ways to break up [skid]'s rhythm. All this seeing both sides of things is just an excuse to rattle on. But you are not having any of it. [skid] skulks off, mentioning the people in CHARGE of the [factual] would know what to do with you, and it's not fair, and one day [skid] will learn. But really, your interrupting is incredibly hurtful. You seemed nice, but [skid] guessed you were wrong.[paragraph break]You feel guilty for a bit. Perhaps you were too harsh. But then you remember other people who talked over you and blasted you for making them do all the conversational work.";
		increment the score; [cmd:t kid say skid]
		now sco-talk-skid is true;
		moot kid say skid;
		the rule succeeds;

check going east in Was Us Way:
	if Kid Say Skid is touchable, say "[skid] brushes you back. 'No offense, but that's getting awfully close to the ... well, the really important and interesting people. I wouldn't want you to rub off on them. I mean, it might help make you more interesting, but it'd make them less interesting, and that's just not cool. I mean, if I have to stay here, so do you.'[paragraph break]Looks like you have someone else to get out of the way." instead;

book Whacks Axe Way 2 3

Whacks Axe Way is east of Was Us Way. It is in Brain Reign Bay. It is renameable and wally. printed name of Whacks Axe Way is "[if Chase Ace Che is moot]Weavin['] Even[else if Whacks Axe Way is altnamed]Wax Axe[else]Whacks Axe[end if] Way". shorttext of Whacks Axe Way is "[if Chase Ace Che is moot]Weavin['][else if Whacks Axe Way is altnamed]Wax[else]Whacks[end if]". "Passage runs east-west here[if chase ace che is not moot][axe-status][end if]."

check going south in Whacks Axe Way when whacks axe way is not altnamed: say "The axe would come down on you." instead;

to say axe-status: say ". A big axe blocks your way south. [if whacks axe way is altnamed]But it's wax, so it can't really hurt[else]It doesn't look lethal, but it might just smack you back[end if]"

understand "wax" and "wax axe/way" and "wax axe way" as Whacks Axe Way when Whacks Axe Way is ever-alt.

understand "weavin even way" and "weavin even" and "weavin/even way" and "weavin/even" as Whacks Axe Way when Chase Ace Che is moot.

section between Whacks and Boil

this is the whack-block rule: if Whacks Axe Way is not altnamed, say "The whacks-axe would get you in its current state." instead;

check going south in Whacks Axe Way when did-see-axe is true: abide by the whack-block rule;

check going north in Bless Less Bay when did-see-axe is true: abide by the whack-block rule;

after printing the locale description when player is in Whacks Axe Way or player is in Bless Less Bay:
	now location of player is visited;
	if did-see-axe is false and Bless Less Bay is visited and Whacks Axe Way is visited and Whacks Axe Way is ever-alt:
		if player is in Whacks Axe Way:
			say "You wonder what the axe could be blocking. It probably isn't just there for fun. The land is a bit elevated here, and you see down to ... [Bless Less Bay]! Perhaps this shortcut will be handy, later.";
		else:
			say "Your gaze shifts north. You see something familiar--the axe in [whacks axe way]! You would not have caught it if you hadn't been there. But looking a bit further, you determine there must be a passage up north. This may be useful, later.";
		change south exit of Whacks Axe Way to Bless Less Bay;
		change north exit of Bless Less Bay to Whacks Axe Way;
		change down exit of Whacks Axe Way to Bless Less Bay;
		change up exit of Bless Less Bay to Whacks Axe Way;
		now did-see-axe is true;
	continue the action;

book Waffle Awful Way 3 3

Waffle Awful Way is east of Whacks Axe Way. It is south of Wit It Way. It is in Brain Reign Bay. printed name of Waffle Awful Way is "[if sco-use-clear-ear-clay is true]Wangle-Angle Way[else]Waffle-Awful Way[end if]". shorttext of Waffle Awful Way is "[if sco-use-clear-ear-clay is true]Wangle[else]Waffle[end if]". "The path curves west and north here[if sco-use-clear-ear-clay is true]--the [static] no longer[else], but a [static][end if] blocks the way north.".

understand "wangle angle way" and "wangle angle" and "wangle/angle way" and "wangle/angle" as Waffle Awful Way when sco-use-clear-ear-clay is true.

chapter Attic Stay Static

the Attic Stay Static is scenery in Waffle Awful Way. "It's huge, and it's blocking your way north.". printed name is "Attic-Stay-Static".

book Burnin Earnin Bay 4 3

Burnin Earnin Bay is a beachroom in Brain Reign Bay. It is south of Brood Rude Bay. printed name is "[if sco-use-lit-jay is false]Burnin['] Earnin['] Bay[else]Briefer Reefer Bay[end if]". shorttext is "[if sco-use-lit-jay is false]Burnin['][else]Briefer[end if]". indir is west. "A north-south shoreline. You feel [if sco-use-lit-jay is true]no real rush to go anywhere with [aunt] gone[else]nervous and worried you aren't doing enough, quickly enough[end if]."

understand "briefer reefer bay" and "briefer reefer" and "briefer/reefer bay" and "briefer/reefer" as Burnin Earnin Bay when sco-use-lit-jay is true.

Cant Aunt Kay is a person in Burnin Earnin Bay. printed name is "Can't-Aunt Kay". "[one of]A stereotypical grey-haired aunt shakes her head at you. 'I never got where I am today by adventuring,' she reprimands you. Before you can ask if it is anywhere worth going, she assures you that this silly adventuring will stop this instant. Oh, maybe you can go back, but you aren't going further south. Not if [cant] has anything to do with it![or][cant] shakes her head at how you are wasting your life adventuring, and for what? OkayCo?[stopping]". description is "A stereotypical stern grey-haired aunt."

check going south in Burnin Earnin Bay when sco-use-lit-jay is false: say "[cant] wags a finger at you. 'You've probably already been wandering around enough. All this wandering won't lead to anything constructive!' Lost in this logic is whether or not she is doing anything constructive, but her intimidating glare freezes you." instead;

chapter Urn Stay Stern

the Urn Stay Stern is a useful thing. description is "Just looking at it, you feel as though you can scowl naturally at will. Actually, you try to smile while looking at it, but that doesn't last.". printed name is "Urn-Stay-Stern".

book Blingling Bay 0 4

Bling Ling Bay is a beachroom in Brain Reign Bay. It is south of Blurring Luring Bay. shorttext is "[if sco-use-gem is false]Bling[else]Bring[end if]". printed name is "[if sco-use-gem is false]Blingling[else]Bring Ring[end if] Bay". "The southwest corner of Brain Reign Bay. Passages are north and east.".

understand "blingling" and "blingling bay" as Bling Ling Bay.

understand "bring/ring" and "bring/ring bsay" and "bring ring" as Bling Ling Bay when sco-use-gem is true.

chapter ring stay string

the ring stay string is a useful thing. description is "It's looped together. Probably handy for working through a maze.". printed name is "ring-stay string".

check wearing ring stay string: say "It's not very fashionable. It's good enough as a help device." instead;

book Blame Lame Bay 1 4

Blame Lame Bay is a beachroom in Brain Reign Bay. It is east of Bling Ling Bay. printed name is "[if sco-talk-sid is true]Blame Lame[else]Brave Rave[end if] Bay". shorttext is "[if sco-talk-sid is true]Blame[else]Brave[end if]". indir is north. "An east-west shoreline.".

understand "brave rave bay" and "brave rave" and "brave/rave bay" and "brave/rave" as Blame Lame Bay when sco-talk-sid is true.

chapter Id Say Sid

Id Say Sid is a booky person in Blame Lame Bay. "[one of]A person walks back and forth, ranting about how people do not appreciate how he makes their life more exciting. When he sees you, he immediately gives you personal attention. He does seem exciting at first ... but then, he gets exhausting[or][Sid] continues to rant. He can't be right, but he's also vague enough, he's not disprovable[stopping].". printed name is "Id-Say Sid". talk-text is "[sid] sends you for a loop for a while. If you've made it this far, you obviously do not have high standards for excitement, etc. He can't really chalk it up to being patient. Surely you'd have found something better to do? Perhaps it isn't too late? And perhaps you should ask for more, even if you don't deserve it and won't get it, because it's the principle of the thing?[paragraph break]Another two minutes of gish-galloping dissuades you, momentarily, from exploring more fully.". description is "[sid] thinks you're staring a bit too closely. 'Selfish, selfish, selfish. I give you all this excitement, you don't give me any back.'"

check going east in Blame Lame Bay: if sco-talk-sid is false, say "[sid] stops you and throws a bunch of reasons at you why you probably shouldn't, also adding that you should feel guilty you morally obliged him to spend so much energy haranguing you, even if he did enjoy it. You just don't quite have the conviction to blow him off." instead;

check talking Id Say Sid:
	if last-helpbook is Wrong Stay Strong:
		say "Sid rambles on for a bit, but thanks to [wrong stay], you've not just learned but internalized how and why not to take the bait. You calmly explain that perhaps your adventure is not exciting enough for him, but it's good enough for you, and while he's at it, why doesn't he find someone with more hope of being converted to someone interesting? You're sure he has the initiative to find them.[paragraph break][sid] can't believe your rudeness. He storms off, saying you will get what's coming, and you'll look back and see how pointless it all was, you woefully un-self-aware bum.";
		increment the score; [cmd:t id say sid]
		moot id say sid;
		now sco-talk-sid is true;
		the rule succeeds;

book Bless Less Bay 2 4

Bless Less Bay is a beachroom in Brain Reign Bay. It is east of Blame Lame Bay. It is in Brain Reign Bay. indir is north. printed name of Bless Less Bay is "[if ice day dice is allscored]Browned Round[else if sco-ray-roil is true]Boil Oil[else]Bless Less[end if] Bay". shorttext of Bless Less Bay is "[if ice day dice is allscored]Browned[else if sco-ray-roil is true]Boil[else]Bless[end if]". "Along this east-west shore, [if ice day dice is allscored]The burnt-out areas remind you of the oil you extracted[else if sco-ray-roil is false]everything seems calm. You sense there must be more to this place than is obvious at the moment[else]the oil created from the [raid] bubbles colorfully and magically to the south, but it is too hot to enter. It seems like one thing one moment, another the next. Maybe it can become something useful to you[end if]."

understand "boil oil bay" and "boil oil" and "boil/oil bay" and "boil/oil" as Bless Less Bay when sco-ray-roil is true.

chapter oils

a diceoil is a kind of thing. it is usually useful. the description of a diceoil is usually "You don't want to observe [the item described] too closely, or it might fall out of the [dice]. It's there for when you need to use it.".

the Oil Brae Broil is a loneuse diceoil. printed name is "Oil-Brae-Broil".

the Oil Fey Foil is a diceoil. printed name is "Oil-Fey-Foil".

the Oil Ley Loyal is a diceoil. printed name is "Oil-Lay-Loyal".

the Oil May Moil is a diceoil. printed name is "Oil-May-Moil".

the Odd Say Sod is a diceoil. printed name is "Odd (Say) Sod".

book Blubber Lubber Bay 3 4

Blubber Lubber Bay is a beachroom in Brain Reign Bay. It is east of Bless Less Bay. printed name is "[if sco-use-slop-march is true]Burst Erst[else]Bold Old[end if] Bay". shorttext is "[if sco-use-slop-march is true]Bold[else]Burst[end if]". indir is north. "This is a west-east beach[if sco-use-slop-march is true], clearer now with the [march] gone[else], but you're probably not going anywhere around with the [march] to the east dancing aggressively[end if]."

understand "bold old bay" and "bold old" and "bold/old bay" and "bold/old" as Blubber Lubber Bay when sco-use-slop-march is true.

chapter Arch May March

The Arch May March is needy scenery in Blubber Lubber Bay. "The [march] dances back and forth to the left, like a particularly tenacious basketball defender, or at least the bottom half of one. Well, of a thirty-foot-tall basketball player. It glides laterally, effortlessly. This isn't strictly marching, but then again, it's bigger than you, so you don't want to get pedantic with it. Perhaps it's more than it wants YOU to get marching.". printed name of Arch May March is "Arch May-March".

book Blown Lone Bay 4 4

Blown Lone Bay is a beachroom in Brain Reign Bay. It is south of Burnin Earnin Bay. It is east of Blubber Lubber Bay. printed name of Blown Lone Bay is "[if chase ace che is moot]Bend/End[else if blown-guardians-gone]Blown Lone[end if] Bay". shorttext of Blown Lone Bay is "[if chase ace che is moot]Bend[else]Bracing[end if]". "You feel particularly invigorated in this southeastern corner of Brain Reign Bay. Water blocks you south and east, but you can go back west or north."

understand "bend end bay" and "bend end" and "bend/end bay" and "bend/end" as Blown Lone Bay when chase ace che is moot.

understand "bracing racing bay" and "bracing racing" and "bracing/racing bay" and "bracing/racing" as Blown Lone Bay when blown-guardians-gone.

section corner guarding

after going (this is the Blown Lone guard reorg rule):
	if noun is Blown Lone Bay or noun is Blubber Lubber Bay:
		if sco-use-slop-march is false, move Arch May March to noun;
	if noun is Blown Lone Bay or noun is Burnin Earnin Bay:
		if sco-use-lit-jay is false, move Cant Aunt Kay to Burnin Earnin Bay;
	continue the action;

chapter Chase Ace Che

Chase Ace Che is a moody person in Blown Lone Bay. talk-text is "Chase Ace Che looks you up and down. 'You don't look very fast. You're not worth my time to go chase.'". "[one of]A person quits running in place for a bit to introduce themselves as Chase Ace Che. They're always up for a race, if you're worthy[or][if sta-chase-b is false]Chase Ace Che continues doing mini-sprints[else]Chase Ace Che is still chasing you[end if][stopping].". description is "Man! He's in shape!". [nopunc]

check talking Chase Ace Che:
	if raw-mood of "race":
		say "'OK, let's have a race. I'm awfully hard to beat. But maybe you'll find a way.'";
		now sta-chase-b is true;
		start-the-chase;
		the rule succeeds;

section Runt Gay Grunt

the Runt Gay Grunt is a useful thing. description is "Apparently it's supposed to make working out more fun.". printed name is "Runt-Gay-Grunt".

section Ag Bay Bag

the Ag Bay Bag is an ingredient. description is "[chase] gave it to you, and it's just full of all sorts of actual vegetables and powdered vegetable meal-substitute. You're not brave enough to try any of it on your own, nor do you think you'd have the skill to mix it with anything else.". [nopunc]

book Raw Stay Straw

Raw Stay Straw is a room. It is in Un Fey Fun. "You feel peace here. It's not quite an ol['] gay goal, but it's good enough. There's no real way out except back above.". shorttext is "Straw". printed name is "Raw-Stay Straw".

chapter Add Day Dad

Add Day Dad is a needy person in Raw Stay Straw. "[one of]A radiant-looking man smiles as you climb down. 'Alas, I am pinned down here for reasons too weird to mention. But I am [dad].[or][dad] waits here.[stopping]". talk-text is "'I am pinned here right now for reasons too long to relate, [if sco-use-cam-dad is true]but thank you for letting me do my part to help the cause[else]so I cannot get my message out directly. But perhaps you can bring my message to those who need it[end if].'". description is "For being spiritually imprisoned, he's very calm. It gives you hope you can deal with the rest of whatever you need to deal with.". printed name is "Add-Day Dad".

book All Hay Hall

There is a room called All Hay Hall. It is in Un Fey Fun. shorttext is "All". description is "[one of]Man! you wonder where they get all this hay from. It's probably not relevant, but there must be an I've-Hay Hive someplace. [or][stopping]You're under the [hay hill], but you can climb back up. [if ready-final-battle]Your REND END command to the Raid-Aid Ray blasted a hole in the floor here. You can go further down to where ... UNDER THEY THUNDER[else]You definitely hear thundering under. You must be close[end if].". printed name is "All-Hay Hall".

check going down in Hay Hall:
	unless ready-final-battle, say "You can't find a way down. But there must be one." instead;
	say "It's a bit of a jump, and you might get hurt. But you pull out the [pole] and slide down it. Once at the bottom, it collapses, and the [fade] zaps it. Handy!";
	moot ol pay pole;

chapter Leet Fey Fleet

the Leet Fey Fleet are plural-named needy people. description is "They are all sorts of weird shapes and sizes, and they all look to you for guidance.". "You don't know what to say. [if player is in floored lord fey]You feel like you have more to do. They don't seem to be able to take on, physically, [spread] by themselves. They need allies. You need to find some[else if sco-ankh-flank is true]. Just one last show of leadership should do the trick[else]They seem overmatched at the moment, but perhaps you can find a way to cut the [throng] down to size[end if].". [nopunc]

book Grand and Gray Land and Ley

there is a room called Grand and Gray Land and Ley. It is in Un Fey Fun. "A wide-open subterranean space. The noise of battle cries, or at least of lashing out and insults, permeates the area.". shorttext is "Grand/Land". [nopunc]

after printing the locale description when player is in Grand and Gray Land and Ley and did-spread-taunt is false:
	say "[spread] mocks you for [if did-hey-hop is true]spending all that time just to help these bums--someone with your drive could work with more INTERESTING people. You could even become one. Well, more of one. Yes, that's it[else]taking a shortcut. That's just not honest. I mean, it is when the [flame] do it, because they're busy being exciting, but you aren't. No offense. Still, you have potential to join the dark side. Which really isn't the dark side[end if]. You wonder how he KNOWS whether you jumped ahead, and you're surprised he is showing any respect for you at all. Maybe he's not so bad? No, no...";
	now did-spread-taunt is true;

section generic people stuff

for printing a locale paragraph about a person (called per) in Gray Land:
	if per is mentioned, continue the action;
	say "Here, [spread], leader of the [flame], rallies the [throng] against the [swarm] and [fleet]. It is the final battle, and [if sco-ankh-flank is true]it seems like you could just about defeat the [throng] with one more command[else]the [throng] seems too powerful at the moment. Perhaps there's something you can do to reduce it[end if].[paragraph break]You watch as both sides band and bay: [one of]they need a hand, and ... hey[or]many calls for Rand and Ray[or]calls for gourmand (pronounced wrong) and gourmet[or]echoes of OH, BAND AND OBEY[cycling]! There must be something (or two similar things) you can do, for better or worse, to bring things to a close.";
	now all people in Gray Land are mentioned;
	continue the action;

every turn when player is in Gray Land:
	if player has ankh bay bank:
		say "Your [ankh] pulses. There is one [if did-skip-ankh is true]thing you probably need to do with it, here[else]last thing it can do[end if].";
	else if ankh bay bank is moot and player has Plan An Play:
		say "Looking at [plan an play], the title blurs to [i]Planned and Play[r]. That doesn't quite make sense. Or does it?";
	else:
		increment noclue-count;
		if noclue-count > 2, say "There must be something, or two things, you can do to bring things to a conclusion.";

chapter Ed Spray Spread

Ed Spray Spread is a person in Gray Land. description is "He's not particularly big, or powerful. He almost seems to be beckoning to you, as if to say, you're almost good enough for him and too good for OkayCo. That's not how it should work ... is it?". printed name is "Ed Spray-Spread". talk-text is "Now is not the time for diplomacy.". "Ed should not have an individual description."

chapter Wrong They Throng

the Wrong They Throng are plural-named people in Gray Land. "The [throng] gather behind [spread].". description is "They look pretty upset you've breached their sacred place.". printed name is "Wrong-They-Throng". talk-text is "Now is not the time for diplomacy."

chapter Warm Say Swarm

the Warm Say Swarm are plural-named people in Gray Land. "The [swarm] gather behind you.". description is "They are looking to you for guidance and stability. You can't let them down ... or can you?". talk-text is "A pep talk isn't necessary. And you're not good at them, anyway.". printed name is "Warm-Say Swarm".

chapter standandstaying

standandstaying is an action applying to nothing.

understand the command "stand and stay" as something new.

understand "stand and stay" as standandstaying when player is in Grand and Gray.

carry out standandstaying:
	say "Yes. That is all there is left to do. You are worried you are not doing anything, but apparently, the [fleet] and [swarm] take it as a calm leadership style and confidence in THEIR abilities. [spread] and the [throng] are routed.[paragraph break]Back at Am-Hey-Ham, everyone enjoys a nice, relaxing, boring chat about, well, any old thing. Nobody feels they have to make excuses.";
	if player has plan an play, say "[line break]But then the work of full recovery starts. You pull out [play]. Some of the advice seems simple and boring, but positive. You find it hard to accept. Some people still bring up concerns the [flame] had. But people talk it out and recognize they were in bad faith. The healing process will go quicker.";
	say "[line break]And when it's time for you to head home to the real world, or what you thought was the real world, it is of course Rusher-Usher Ray who shows you the way back.[paragraph break]You find yourself more insulated against having to make excuses for not getting in everyone's face. People even seem to think you may be a bit uppity for not sharing. You're hiding something. But what?[paragraph break]Over the years you hear 'Crusty Rusty K' and even, ironically 'Cravin['] Ravin['] K.' Which always makes you smile a bit.";
	increment the score; [cmd: stand and stay]
	end the story finally saying "WELL! SAY! SWELL!";
	if score < 20 and opt-stay-stop is true:
		say "Thanks for completing the game. I hope you enjoyed the overview, and I understand if the full game might overstay its welcome. But if you want to disable the [stop] and see more, you're welcome to try.";
	else if score < 70:
		say "Thank you for completing the game. It is not easy, even with the help items. I hope you it, and I'd be honored if you replayed the longer mode in full.";
	else if did-hey-hop is false:
		say "Congratulations on completing the game without OP HEY HOP! I'm grateful you took the time to look into all the silliness.";
	the rule succeeds.

chapter strandandstraying

strandandstraying is an action applying to nothing.

understand the command "strand and stray" as something new.

understand "strand and stray" as strandandstraying when player is in Grand and Gray.

carry out strandandstraying:
	say "For whatever reason, A heel turn! You look to your faded ankh and wonder how many eighths this would cost you around Lord British. Not that you care. Perhaps you have seen the light, that the [factual] are more 'interesting' and 'real' than OkayCo.[paragraph break]You are certainly too cool for silly wordplay-based text adventure games chock full of slightly tortuous pronunciation-based jokes.[paragraph break]You leave the [swarm] to their fate--you know their weaknesses. As they are routed, they cry 'EVIL-WAY WEEVIL!' But you are totally too based to care. You whisper to [spray] what a bunch of chumps they are: they were probably biased against evil before they met anyone evil, and that's more evil than actually being evil.[paragraph break]Wow! Acceptance from [spread]! Whether or not this lasts is another story. One you don't deserve to know for selling out OkayCo, you bum. But if he doesn't, you're in big trouble. After all, wiping out OkayCo cut your contact with the real world.";
	if player has plan an play, say "[line break]To get in good with [spread], you pull out [play], which you worked so hard to acquire. You laugh and tear it up. He doesn't seem to appreciate it as much as he should. You wonder if, perhaps, he is getting a bit soft, and the [flame] requires new leadership.";
	end the story finally saying "DEFECTOR / EFFECTOR DAY";
	say "I was going to congratulate you on making it and thank you for playing, but never mind, you meanie.";
	the rule succeeds.

volume Old Fey Fold

book Frowned Round Fey 2 1

Frowned Round Fey is a room in Old Fey Fold. "At this nexus where you first entered the Old Fey Fold, you can go north or east[if sco-use-day-doll is true]. It's totally peaceful here now that you've literally made a friend[else if sco-talk-bryce is true]. You feel energy pulsing through here, as if you are allowed to partake of some of the fey's magic[else]. It's a bit overwhelming, this magic area[end if].". printed name of Frowned Round Fey is "[if sco-use-day-doll is true]Friend Rend Fey[else if sco-talk-bryce is true]Factor-Actor Fey[else]Frowned-[']Round Fey[end if]". shorttext of Frowned Round Fey is "[if sco-use-day-doll is true]Friend[else if sco-talk-bryce is true]Factor[else]Frowned[end if]".

understand "friend rend fey" and "friend rend" and "friend/rend fey" and "friend/rend" as Frowned Round Fey when sco-use-day-doll is true.

understand "factor actor fey" and "factor actor" and "factor/actor fey" and "factor/actor" as Frowned Round Fey when sco-talk-bryce is true.

last-room of Old Fey Fold is Frowned Round Fey.

check going in Frowned Round Fey:
	if Ice Bray Bryce is touchable:
		say "[bryce] holds you back. 'Where do you think you're going? You don't seem very exciting, but I don't think you have a PLAN. You should probably stay here where it's boring.' Before you can ask [bryce] why he is staying somewhere so boring, he begins complaining about the people and entities he has to deal with these days.[paragraph break]You'll have to be less direct dealing with him." instead;
		if opt-ease-play is true, pep Ice Bray Bryce;
		the rule succeeds;
	if sco-use-day-doll is false, say "You feel something pulling you back. The [frowned] seems alive with possibilities. They could bring something lifeless to life, if you just believed." instead;

chapter Ice Bray Bryce

Ice Bray Bryce is a songy person in Frowned Round Fey. "[one of]Of course someone has made it here before you. That someone wonders why you bothered. They just won't stop talking, and you aren't forceful enough to interrupt them. They introduce themselves as [bryce][or][bryce] continues babbling about how he is too good for this place without showing the slightes inclination to leave[stopping].". talk-text is "[bryce] doesn't shut up. He assures you his dialogue is much more enlightening than Ramblin['] Amblin['] Ray, so you should be grateful he is foisting it upon you so generously. And any pain you feel is just jealousy of his mad conversational skillz.". description is "[bryce] seems to feed off your attention and get louder for a second without skipping a beat.". printed name is "Ice-Bray Bryce".

check talking Ice Bray Bryce:
	if last-song is Smiled Mild Say:
		say "You initiate the conversation and calmly let all of [bryce]'s well-thought-out abuse go over your head. He snorts in contempt at first, but after a few minutes, it really gets to him. Why did you start this conversation if you weren't going to listen to him? Do you even care about the effort he puts into things? Could you at least show some emotion like a REAL person? With [smiled] echoing through your head, you suddenly realize a few truths about him and people like him. You always figured they weren't as smart and happy and with-it and well-liked as they pretended to be, but they may even be far short of that. Yet, at the same time, the song prevents you from smiling TOO much.[paragraph break]But it is all too much for [bryce], who tramps away looking for someone else to give a Life Education to.";
		moot Ice Bray Bryce;
		increment the score; [cmd: T ICE BRAY BRYCE]
		now sco-talk-bryce is true;
		the rule succeeds;

chapter Iffy Clay Cliffy

Iffy Clay Cliffy is a loneuse person. "Gritty, itty, gray.". talk-text is "A nod. Odd? Nay.[paragraph break][cliffy] may not be able to speak, but he is eager to help you.". description is "[if sco-use-function-cliffy is true]A bit smaller than before, but still as energetic.[else if sco-use-cliffy-cracked is true]Broken and lifeless for the moment.[else]Eager to follow you around and help, but how?[end if]". [nopunc]

book Fright Right Fey 3 1

Fright Right Fey is a room in Old Fey Fold. it is east of Frowned Round Fey. "An [hark] curves to the north, south, and west. It's [if sco-use-string-hark is true]not worth visiting, but just looking at it reminds you of all you learned when going through it[else if sco-talk-self is true]less intimidating with [self] gone[else]supposed to be welcoming, but it's pretty intimidating[end if]."It is in Old Fey Fold. printed name of Fright Right Fey is "[if sco-use-string-hark is true]Flight Light Fey[else]Fright Right Fey[end if]". shorttext of Fright Right Fey is "[if sco-use-string-hark is true]Flight[else]Fright[end if]".

understand "flight light fey" and "flight light" and "flight/light fey" and "flight/light" as Fright Right Fey when sco-use-string-hark is true.

chapter Elf Say Self

Elf Say Self is a booky person in Fright Right Fey. talk-text is "[elf say self] certainly has exciting things to say about themselves and their numerous trips through the [hark], but you find yourself unable to keep up. They honestly wonder why they are wasting their time on you. You feel obliged to apologize for not keeping up and not appreciating the excitement they've brought into your life, at nontrivial personal expense.". "[one of]An elf is babbling here, not caring who is listening. They look up at you and continue talking about themselves, then briefly asking if you have anything to add about them. You do not. 'Well, I DID ask,' they say, continuing their monologue.[or][self] continues to babble about themselves, making sure you are paying attention.[stopping]". description is "[self] interprets your eye contact as permission to talk a bit louder and faster.". printed name is "Elf Say-Self".

check entering Ark Hey Hark:
	if sco-use-string-hark is true, say "You already gained knowledge." instead;
	if sco-talk-self is false, say "[self]'s yammering about all it learned in the [hark] is remarkably light on substance, but it's overwhelming enough to scare you from entering." instead;
	say "The [hark] looks quite big inside. Almost mazy. You sense you need a plan, perhaps with some material, to ensure you didn't get lost." instead;

check talking Elf Say Self:
	if last-helpbook is Yawn On Yay, say "[elf say self] begins yammering excitedly about all it learned in the [hark]. Your eyes gloss over. You can't help it. Well, you sort of can. But you just let yourself go. Yawning is, perhaps, the greatest insult [elf say self] could get, well beyond being argued at. [elf say self] asks if, perhaps, they are not exciting enough for you, but by then you can't help yawning, and worse ... you make them yawn, too. They ask, in desperation, why you rudely throw such mild approval back in their face, after all the time they spent crafting such backhanded compliments. But all you can do is yawn once more. [self] throws their hands up and walks away.";
	increment the score; [cmd:t elf say self]
	moot elf say self;
	now sco-talk-self is true;
	the rule succeeds;

chapter Ark Hey Hark

the Ark Hey Hark is needy scenery in Fright Right Fey. printed name is "Ark-Hey-Hark". "It's quite cavernous inside. [if sco-use-string-hark is true]You don't need to revisit it again, as you got enough knowledge the first time[else]You could learn quite a bit, provided you didn't get lost there[end if].".

book Foul Owl Fey 2 0

Foul Owl Fey is north of Frowned Round Fey. It is in Old Fey Fold. shorttext is "[if sco-use-bait-howl is true]Fair[else]Foul[end if]". printed name is "[if sco-use-bait-howl is true]Fair Air[else]Foul Owl[end if] Fey". "The path forks in a T here: south, east and west[if sco-use-bait-howl is true]. Without [howl] around, you can move freely[end if]."

understand "fair air fey" and "fair air" and "fair/air fey" and "fair/air" as Foul Owl Fey when sco-use-bait-howl is true.

check going in Foul Owl Fey when Owl Hey Howl is touchable: if noun is west or noun is east, say "Unfortunately, the [howl] swoops all around and prevents you from going [noun]." instead;

chapter Owl Hey Howl

Owl Hey Howl is a needy person in Foul Owl Fey. printed name is "Owl-Hey-Howl". "Unfortunately, an [howl] is blocking you from going anywhere but back south.". description is "You might be able to get by it, but you'd get sorely scratched. It seems to be in hunting mode.".

book Floored Lord Fey 3 0

Floored Lord Fey is east of Foul Owl Fey. It is in Old Fey Fold. printed name of Floored Lord Fey is "[if sco-use-stew-greedy is true]Fam-Am[else if sco-use-treat-greedy is true]Feast East[else]Floored (Lord)[end if] Fey". shorttext of Floored Lord Fey is "[if sco-use-stew-greedy is true]Fam[else if sco-use-treat-greedy is true]Feast[else]Floored[end if]". "A wide open area. [if sco-use-stew-greedy is true]Nice memories of the feast linger[else if sco-use-treat-greedy is true]Perhaps you can make it a full feast area[else]Perhaps in happier times, it would be a place for social interaction and revels[end if]. [flake] blocks passage in every direction except back west.". noway-text is "[flake] is not to be swum in. It's dangerous even for magical creatures."

understand "feast east fey" and "feast east" and "feast/east fey" and "feast/east" as Floored Lord Fey when sco-use-treat-greedy is true.

understand "fam am fey" and "fam am" and "fam/am fey" and "fam/am" as Floored Lord Fey when sco-use-stew-greedy is true.

check going west in Floored Lord Fey:
	abide by the can-i-goto rule;

chapter Up K Cup

the Up K Cup is a useful thing. description is "It's pretty plain, except for a smiley face. It reminds you of a souvenir cup you found and treasured when you were very young.". printed name is "Up-K?-Cup".

chapter Lake Fey Flake

Lake Fey Flake is scenery in Floored Lord Fey. "It's so nice and mesmerizing but also impossible to cross. You don't need to, anyway.". printed name is "[if sco-use-stew-greedy is true]Loch Fey-Flock[end if]"

understand "loch fey flock" and "loch fey" and "loch/fey flock" and "loch/fey" as Lake Fey Flake when sco-use-stew-greedy is true.

chapter Greedy Edie Gray

Greedy Edie Gray is a needy person in Floored Lord Fey. talk-text of Greedy Edie Gray is "'Crumb? Um, CRAY!' Edie Gray relates how she'd like to provide a feast once everything is done, but that would require 1) something worth feasting on and 2) something worth feasting about. Perhaps you can help![paragraph break]She's not especially greedy. She hopes. But she feels that way, because she'll need a LOT of food.". "[if sco-use-stew-greedy is true][greedy] sits back happily, still probably reminiscing about the great feast.[else][one of]'Oh! Someone who could help! I'm [greedy]. I guess people think I'm greedy because I'd like to hold a big feast here. In the east fey. I think we may need snacks to start.'[or]Greedy Edie Gray paces about here, muttering something about a feast.[stopping][end if]". description is "[greedy] isn't greedy, per se, but she knows she is asking a lot, and so she FEELS greedy asking.". [nopunc]

chapter Pot Say Spot

the Pot Say Spot is a useful thing. description is "It's a pot for cooking. And it certainly is eye-catching. But apparently, it's magical, too.". printed name is "Pot-Say-Spot".

book Fork Orc Fey 1 0

Fork Orc Fey is west of Foul Owl Fey. It is in Old Fey Fold. "It's not quite a crossroads here, but paths lead west, south and east.". printed name of Fork Orc is "[if sco-use-bugs-stork is true]Foldin['] Olden Fey[else]Fear [']Ere Fey[end if]". shorttext of Fork Orc Fey is "[if sco-use-bugs-stork is true]Foldin['][else]Fear[end if]".

understand "foldin olden fey" and "foldin olden" and "foldin/olden fey" and "foldin/olden" as Fear [']Ere Fey when sco-use-bugs-stork is true.

chapter orc stay stork

the Orc Stay Stork is a needy person in Fork Orc Fey. "An [stork], a speedy little attack animal, seems intent on stopping you from doing anything but returning as you came.". talk-text is "It gives the animal equivalent of an ack-hey hack.". description is "The [stork] pecks about for food.". printed name is "Orc-Stay-Stork".

check going in Fork Orc Fey when sco-use-bugs-stork is false: if noun is south or noun is west, say "The [stork] blocks you and pecks at you. It's pretty aggressive!" instead;

book Fear [']Ere Fey 0 0

Fear Ere Fey is west of Fork Orc Fey. It is in Old Fey Fold. "With the [if sco-use-plant-tractor is true][stall][else][fog][end if] almost encircling you, the only way back is east.". printed name of Fear Ere Fey is "[if sco-use-plant-tractor is true]Farm Arm Fey[else]Fear [']Ere Fey[end if]". shorttext of Fear Ere Fey is "[if sco-use-plant-tractor is true]Farm[else]Fear[end if]".

understand "farm arm fey" and "farm arm" and "farm/arm fey" and "farm/arm" as Fear Ere Fey when sco-use-plant-tractor is true.

chapter Tractor Tray

there is a person called Tractor Trey in Fear Ere Fey. he is needy. printed name is "Tractor Actor Trey". talk-text is "'Hick? Ick! Hey!'". description is "[tractor] seems quite pleased with his ostensible heritage, down to the Add-Play Plaid he is wearing.". "[tractor], a sort of Orc, stands his ground here, adding to the atmosphere, or trying to.".

understand "actor" and "tractor trey" and "actor trey" and "tractor actor trey" as Tractor Trey when Tractor Trey is touchable.

chapter augh fey fog

the Augh Fey Fog is scenery in Fear Ere Fey. "You can't see through it, and you definitely don't want to walk through it. But at least it hasn't totally enveloped you.". printed name is "Augh-Fey Fog".

chapter tall say stall

the tall say stall is a latinable. it is scenery. printed name is "[if tall say stall is allscored]Tall (Say)[else]All-Stay[end if] Stall". known-rule of tall say stall is stall-known rule. guess-table of tall say stall is table of stall guesses. midpart is "-Say-". description is "It's obviously a place for animals[if tall say stall is unscored], but what type? [else]. [end if] SAY? is carved into it. It's divided into [(total-score of tall say stall) in words] compartments.". clue-chunk of tall say stall is "compartment". clue-chunk-plural of tall say stall is "compartments". preuse-text of tall say stall is "You need to find what sort of animals would fit in the [tall say stall].".

check entering tall say stall: say "It is for animals, not for you." instead;

this is the stall-known rule:
	if sco-use-plant-tractor is true, the rule succeeds;
	the rule fails;

book Fill Ill Fey 1 1

Fill Ill Fey is south of Fork Orc Fey. It is in Old Fey Fold. "You feel [if sco-talk-dork is true]peaceful[else]unsettled[end if] here on this north-to-west road.". printed name of Fill Ill Fey is "[if sco-talk-dork is true]Flak Lack Fey[else]Fill Ill Fey[end if]". shorttext of Fill Ill Fey is "[if sco-talk-dork is true]Flak[else]Fall[end if]".

understand "flak lack fey" and "flak lack" and "flak/lack fey" and "flak/lack" as Fill Ill Fey when sco-talk-dork is true.

Orc Day Dork is a booky person in Fill Ill Fey. "[dork], almost certainly a dork at night, too, bloviates here, blocking your way west.". description is "Geez! You didn't think orcs could be this dorky, but it is. Of course, being an orc, it's physically imposing enough to push you around. And it wants to. It seems to have some great moral conviction why you're staying here, and that's that.". printed name is "Orc Day-Dork". talk-text is "[dork] spends a while orcsplaining to you how your quest is pretty much devoid of meaning and really corny and cheesy and not really up to its literary standards. It's impressive and intimidating, and you almost fool yourself into thinking you learned something from it. Once you've cooled down, though, you realize you haven't.[paragraph break]It seems [dork] is just there to stop you from doing what you want. You don't even have the guts to say 'Hate-ate, hey?' You need to learn to cope before [dork]'s 'exciting' rhetoric exhausts your resistance."

check talking Orc Day Dork:
	if last-helpbook is Nerd Erd Nay:
		say "Orc Day-Dork's blather starts up again, but you've learned techniques to let that sort of thing blow over. You let [dork]'s lecture run its course. After about fifteen minutes, it finally wonders why it bothers, and after ten more minutes, it actually stops bothering. You didn't realize you were smiling, but you must've been, because as it walks away, it calls 'Eek! Gay geek!' before kicking a small tube of ... something. [function], whatever that is. You pick it up.";
		now player has unction fey function;
		now sco-talk-dork is true;
		increment the score; [cmd:T ORC DAY DORK]
		the rule succeeds;

some Unction Fey Function is a singular-named useful thing. "Some [function] lies here. It doesn't look particularly toxic.". description is "It touts its ability to heal magical things, but only for people who have been kind enough to animals. Right now, it feels [if need-score of tall say stall > 2]a bit lumpy, as if you couldn't squeeze the unction out[else]soft enough to squeeze and apply[end if].". printed name is "Unction Fey-Function".

book Far Are Fey 0 1

Far Are Fey is west of Fill Ill Fey. It is in Old Fey Fold. printed name of Far Are Fey is "[if sco-use-proof-falter is true]Fix-Icks Fey[else]Far-Are Fey[end if]". shorttext of Far Are Fey is "[if sco-use-proof-falter is true]Icks[else]Far[end if]". "You've reached an edge of the fey territory here. The only passage is back west. [if sco-use-proof-falter is true]The [falter] has been covered, and no more evil can sneak through from the Freezin[']-Reason Fey[else]An [falter] stands here. You feel a physical and spiritual chill coming from it[end if]."

understand "fix icks fey" and "fix icks" and "fix/icks fey" and "fix/icks" as Far Are Fey when sco-use-proof-falter is true.

check going east in Far Are Fey when block-far-east: say "The [foil] may dry out. There's not much to do here." instead;

chapter Altar Fey Falter

the Altar Fey Falter is needy scenery in Far Are Fey. "[if sco-use-proof-falter is true]It's sealed tight now[else]It's still leaking in evil from the Freezin[']-Reason Fey[end if].". printed name is "Altar Fey-Falter".

volume Laden-Aidin' Ley

book Lack Ack Ley 1 1

Lack Ack Ley is a room in Laden Aidin' Ley. "The only physical way out here is up north via an [mark]. [if sco-use-wedge-mark is true]You chipped away enough at it with the wedge, you can go up[else]But it is too smooth to climb at the moment[end if].". printed name of Lack Ack Ley is "[if sco-use-wedge-mark is true]Ladder Adder Ley[else]Lack Ack Ley[end if]". shorttext of Lack Ack Ley is "[if sco-use-wedge-mark is true]Ladder[else]Lack[end if]".

understand "ladder adder ley" and "ladder adder" and "ladder/adder ley" and "ladder/adder" as Lack Ack Ley when sco-use-wedge-mark is true.

check going up in Lack Ack Ley: try going north instead;

check going north in Lack Ack Ley: if sco-use-wedge-mark is false, say "You slip on the way up. If only you could carve in some leg- and foot-holds!" instead;

last-room of Laden Aidin' Ley is Lack Ack Ley.

chapter Ark May Mark

the Ark May Mark is needy scenery in Lack Ack Ley. "[if sco-use-wedge-mark is false]It looks sturdy but too smooth and tall to climb up[else]You chipped away at it to create makeshift stairs, so you can climb up north now[end if].". printed name is "Ark-May-Mark".

book Loaf Oaf Ley 1 0

Loaf Oaf Ley is north of Lack Ack Ley. It is in Laden Aidin' Ley. printed name of Loaf Oaf Ley is "[if sco-use-stern-sophie is true]Learn Earn[else]Loaf Oaf[end if] Ley". shorttext of Loaf Oaf Ley is "[if sco-use-stern-sophie is true]Learn[else]Loaf[end if]". "The land has opened up here from the south. You can go east and west at this intersection.".

understand "learn earn ley" and "learn earn" and "learn/earn ley" and "learn/earn" as Loaf Oaf Ley when sco-use-stern-sophie is true.

check going in Loaf Oaf Ley:
	if noun is down, try going south instead;
	if noun is east or noun is west:
		if sco-use-stern-sophie is false, say "You're distracted by the shenanigans of [so-so]. They're not especially GOOD shenanigans, but they bring a raw -- if over-needy cheer to your adventure." instead;

chapter Oafy Say Sophie

Oafy Say Sophie is a needy female person in Loaf Oaf Ley. "[bug-together].". description is "Her smile is as big as [soapy]'s frown.". printed name is "Oafy-Say Sophie".

to say so-so: say "[one of][soapy] and [sophie][or][sophie] and [soapy][at random]"

for printing a locale paragraph about a person (called per) in Loaf Oaf Ley:
	if per is mentioned, continue the action;
	if per is Oafy Say Sophie or per is Opie Say Soapy:
		say "[one of]Two people squabble back and forth, quickly identifying themselves as [so-so]. They're distracting enough to be mildly amusing and not as annoying as those super-popular idiots with huge YouTube followings for no reason. You guess you should be entertained. It's been a long adventure, and they're trying so hard for attention, you feel bad not smiling[or][so-so] continue their dubious hijinks. You haven't met anyone else who's tried to make you laugh, so you feel emotionally blackmailed into seeming amused[stopping].";
		now all people in Loaf Oaf Ley are mentioned;
	continue the action;

chapter Opie Say Soapy

Opie Say Soapy is a person in Loaf Oaf Ley. "[bug-together].". description is "His frown is as big as [soapy]'s smile.". printed name is "Opie Say-Soapy".

book Losin Oozin Ley 0 0

Losin Oozin Ley is west of Loaf Oaf Ley. It is in Laden Aidin' Ley. printed name of Losin Oozin Ley is "[if sco-use-loyal-lovin is true]Loftin['] Often[else]Losin['] Oozin['][end if] Ley". shorttext of Losin Oozin Ley is "[if sco-use-loyal-lovin is true]Loftin['][else]Losin['][end if]". "The path bends west-to-south here. Off to the side is Lake Ache-Ley, an ugly little pond in this magic area.".

understand "loftin often ley" and "loftin often" and "loftin/often ley" and "loftin/often" as Losin Oozin Ley when sco-use-loyal-lovin is true.

check going south in Losin Oozin Ley: if sco-use-flu-bark is false, say "You are pushed back by some ethereal force. You feel unworthy to visit whatever is behind there. Yet." instead;

chapter Lake Ache Ley

Lake Ache Ley is needy scenery in Losin Oozin Ley. "It doesn't appear very deep, but it is very murky. An eyesore, and it smells none too nice, too. Perhaps you could clear it up.". printed name is "Lake Ache-Ley"

chapter Oven Ley Lovin

the Oven Ley Lovin is a needy thing. description is "It's suitable for cooking food made with love and care.". printed name is "Oven-Ley-Lovin[']". "The [lovin] you loosened from [lake ache] lies here now.".

book Law Aw Ley 0 1

Law Aw Ley is south of Losin Oozin Ley. It is in Laden Aidin' Ley. printed name of Law Aw Ley is "[if sco-use-prattle-slot is true]Lending Ending[else]Law (Aw)[end if] Ley". shorttext of Law Aw Ley is "[if sco-use-prattle-slot is true]Lending[else]Law[end if]". "This is a lonely outpost with the only way back north. [if sco-use-prattle-slot is false]A [prison] stands tall. It must hold something critical[else]Knocking down the prison that used to stand here felt like a big step towards tying things up[end if]."

understand "lovin oven ley" and "lovin oven" and "lovin/oven ley" and "lovin/oven" as Law Aw Ley when sco-use-prattle-slot is true.

chapter Risen Pay Prison

the Risen Pay Prison is scenery in Law Aw Ley. "It's very opaque. Entry is currently barred by a [if sco-use-salt-slot is false][ought slay][else]talkative [lot say][end if].". printed name is "Risen-Pay Prison".

chapter Ought Slay Slot

the Ought Slay Slot is needy scenery in Law Aw Ley. "Boy! It's potentially lethal! You can't even get near it to unlock it or whatever. Maybe there is some way to make it less lethal. Maybe just annoying.". printed name is "Ought-Slay Slot".

chapter Lot Say Slot

the lot say slot is needy scenery. "It's more annoying than the [ought slay] but less dangerous. It's probably easier to deal with for good.". printed name is "Lot-Say Slot"

chapter Dove of Day

the Dove of Day is a useful thing. "You should have the Dove of Day at all times.". description is "It looks peaceful and all that sort of thing. Cynics might find it too peaceful.". [nopunc]

check talking dove of day: say "You don't need to. It radiates peace, and stuff." instead;

book Loader Odor Ley 2 0

Loader Odor Ley is a beachroom in Laden Aidin' Ley. It is east of Loaf Oaf Ley. printed name is "[if sco-use-plots-pork is false]Loader Odor Ley[else]Link Ink Ley[end if]". shorttext is "[if sco-use-plots-pork is false]Link[else]Loader[end if]". indir is west. "The path bends west-to-south here.".

understand "link ink ley" and "link ink" and "link/ink ley" and "link/ink" as Loader Odor Ley when sco-use-plots-pork is false.

check going south in Loader Odor Ley: if sco-use-plots-pork is false, say "Not with the [pork] blocking you." instead;

chapter Orc Pay Pork

The Orc Pay Pork is a needy person in Loader Odor Ley. "[one of]A smelly orc blocks your way to the south. It is potentially not as annoying as the other orcs you've seen, but it's still in the way. It's rather well-dressed, making it an [pork][or]The [pork] still waits, blocking the way south, waiting for payment[stopping].". description is "The [pork] stares back with contempt and rubs its fingers in a universal gesture for money.". printed name is "Orc-Pay-Pork".

book Lashin Ashen Ley 2 1

Lashin Ashen Ley is a room in Laden Aidin' Ley. It is south of Loader Odor Ley. printed name of Lashin Ashen Ley is "[if sco-use-flu-bark is true]Lucky Ucky Ley[else]Lashin['] Ashen Ley[end if]". shorttext of Lashin Ashen Ley is "[if sco-use-flu-bark is true]Lucky[else]Lashin'[end if]". "An [bark] surrounds you on all sides except back north. [if sco-use-flu-bark is false]Awful[else]Cheerful[end if] noises emanate from it."

understand "lucky ucky ley" and "lucky ucky" and "lucky/ucky ley" and "lucky/ucky" as Lashin Ashen Ley when sco-use-flu-bark is true.

chapter Ark Bay Bark

the Ark Bay Bark is needy scenery in Lashin Ashen Ley. printed name is "Ark [if sco-use-flu-bark is true]Ley Lark[else]Bay Bark[end if]". "It makes [if sco-use-flu-bark is true]much happier noises now it's fixed[else]weird moaning and retching noises[end if]."

check entering Ark Bay Bark: say "Too dangerous. You [if sco-use-flu-bark is true]stopped[else]need to stop[end if] whatever's pouring out from there."

volume Eee Say Sea

[these are arranged alphabetically]

book Isle Away Awhile

Isle Away Awhile is an isleroom in Eee Say Sea. "This is a good place to recuperate, but nothing here would further your quest.". shorttext is "Awhile". printed name is "Isle Away-Awhile".

after looking in Isle Away Awhile when did-whale-exhaust is true:
	say "Now you're recharged, you can continue your quest.";
	now did-whale-exhaust is false;
	continue the action;

book Isle Bay Bile

Isle Bay Bile is an isleroom in Eee Say Sea. shorttext is "Bile". "Yuck! There's not much to explore here, but that might be a good thing.". printed name is "Isle Bay-Bile".

the ick stay stick is a useful thing in Isle Bay Bile. "An ick-stay stick has weathered the horribleness of this isle. It might be handy somewhere yucky.". description is "It seems clean, weathered by the time it spent [in-here of Isle Bay Bile]. You could probably [b]USE[r] it to poke around somewhere messy or unclean.". printed name is "ick-stay stick".

book Isle Day Dial

Isle Day Dial is an isleroom in Eee Say Sea. "Well, it's not quite a dial, but an own fey phone (the retro kind) sits here in the center. You [if sco-use-phone is true]already turned it, though, so your work here is done[else]could probably USE it to turn it[end if].". shorttext is "Dial". printed name is "Isle Day-Dial".

the own fey phone is loneuse scenery in Isle Day Dial. "It's made like a standard rotary phone, as a hat-tip to magical, and less technological, days of yore. It's obviously an instrument of some power.". printed name is "own-fey phone".

understand "dial" as own fey phone when player is in Isle Day Dial and own fey phone is in Isle Day Dial.

book Isle Fey File

Isle Fey File is an isleroom in Eee Say Sea. "[one of]It's not too bad here. Thankfully, it's not v. vile. And yes -- there is a file here! You read it. It's notes, from the reclusive Riggy Iggy Raye. It describes coordinates and basic arithmetic of how to get the Reach Each Ray to point somewhere else beyond the Clout Lout Cay and Brain Reign Bay. All this is surprisingly intuitive and memorable.[or]Not much to do here now you read the file[if Frowned Round Fey is unvisited]. In fact, you feel a longing to visit the new area this place tipped you off to[end if].[stopping]". shorttext is "File". printed name is "Isle Fey-File".

book Isle Gay Guile

Isle Gay Guile is an isleroom in Eee Say Sea. shorttext is "Guile". "You just feel a bit more well-adjusted here. And a bit sneaky. Not sleazy sneaky, but sneaky enough to avoid malicious mind-game traps.". printed name is "Isle Gay-Guile".

the Plus Us Play is a useful plainbook in Isle Gay Guile. "Something called a Plus Us Play waits here. It is a combination of communication system and weird games.". description is "It's, well, meant to make occasions more social. You're not sure how.". printed name is "Plus-Us Play".

book Isle May Mile

Isle May Mile is an isleroom in Eee Say Sea. shorttext is "Mile". description is "This is a narrow isle, but you can see to each edge, and there's not much to do here.". printed name is "Isle May-Mile".

Sprawl All Spray is a twoway thing in Isle May Mile. "Someone has left a bottle of Sprawl All Spray, whatever that is, here.". description is "Apparently, it makes vegetation cover the immediate area and also repels pests. It is currently [if sco-use-sprawl-creep is true]empty[else if sco-use-may-more-sprawl is true]full[else]about half-full[end if]. But apparently, you can refill it. It's not aerosol--more one of those bulby-perfumy things.". printed name is "Sprawl-All Spray".

understand "bottle" as Sprawl All Spray.

book Isle Pay Pile

Isle Pay Pile is an isleroom in Eee Say Sea. "Lots of useless currency here.". shorttext is "Pile". printed name is "Isle Pay-Pile".

chapter old gay gold

the old gay gold is a thing in Isle Pay Pile. "But wait! There's some old gay gold. Not much. Not much at all. Surely it must be worth something.". indefinite article is "some". description is "The old gay gold has a smile (my, I'll say) carved into it.". [nopunc]

check taking old gay gold when old gay gold is not carried:
	unless raw-mood of "rich", say "You don't feel up to wealth, even modest wealth. You need a way to change that." instead;

after taking old gay gold:
	say "On taking the old gay gold, you no longer feel money-hungry.";
	zap-mood "rich" and false;

book Isle Ray Rile

Isle Ray Rile is an isleroom in Eee Say Sea. "[if clever lever k is touchable]About the only thing worth noting on this isle is a lever, labeled CLEVER LEVER, K?[else]There's nothing left to do here now that you pulled the clever lever.[end if] ". shorttext is "Rile". printed name is "Isle Ray-Rile".

chapter Clever Lever K

the clever lever k is loneuse scenery in Isle Ray Rile. "It's a lever, so you may want to [b]U(SE)[r] it if and when the time is right. It doesn't look particularly heavy. Inscribed in the lever is the name of its creator: Riggy Iggy Raye.". printed name is "Clever Lever (K?)".

book Isle Stay Style

Isle Stay Style is an isleroom in Eee Say Sea. "This is a place where you could, um, stay.". shorttext is "Style". printed name is "Isle Stay-Style".

The Rock Fey Frock is a wearable useful thing in Isle Stay Style. description is "It seems a bit gaudy. You couldn't wear it. Perhaps it would cause the wearer substantial embarrassment, or perhaps its garishness might repel the right sort of entity.". "A [frock] lies here. Nobody is around to claim it. So you can probably take it, if you want.". printed name is "Rock-Fey Frock".

check wearing frock: say "No, it's a bit much for you." instead;

book Isle Tray Trial

Isle Tray Trial is a trayroom in Eee Say Sea. shorttext is "Trial". "This is the center of an east-west strip of island. I need to improve this text, but it's totally optional to do anything more than take the oafy tray here.". noway-text is "You can go west or east or take the [b]SHIP[r] back, but not [noun].". printed name is "Isle Tray-Trial".

An oafy tray is a useful thing in Isle Tray Trial. description is "It's obviously a sort of white-elephant prize that's been passed along as a 'joke' to the next 'clever prankster' as a sign of 'appreciation.' And now, someone has (perhaps) left it for you![paragraph break]To pass on to someone with horrible aesthetics, of course. To pass it on to someone else.". "An oafy tray lies here,. My goodness, it's tacky, but it's probably not coated with poison, or anything. Even though this is Isle Tray Trial, the oafy tray still looks out of place here.". [nopunc]

report taking the oafy tray:
	say "You look around, half ashamed to pick up something so gaudy.";
	the rule succeeds;

after printing the locale description when player is in Isle Tray Trial:
	if plan an play is not off-stage, continue the action;
	if sta-announced-trays is true, continue the action;
	now sta-announced-trays is true;
	if number of carried win-trays < 6, say "You feel unprepared for whatever you need to do here. You doubt it is even necessary. And yet, sometimes you need to do unnecessary things for other people. Or, perhaps, sometimes you have to say no, I don't have the time, I did my best, and I hope you understand.";
	if number of carried win-trays is 5 and player does not have eyeing tray:
		say "[line break]A voice booms: 'Greetings, seeker. You have not yet tried and failed enough to be fully prepared for the [trial]. There are ways to do so, even if you have already succeeded greatly. Doing so will help you understand how others less skilled make, and learn from, their own mistakes.[paragraph break]'Eek! Say! Seek!' the voice echoes.";
	continue the action;

chapter Plan An Play

there is a plainbook called Plan An Play. Printed name is "Plan an['] Play". description is "This book will be no help to you in your quest, but it describes the process of healing after many people have put you down and how to do so with joy and without putting others down. This will be handy for OkayCo once you help them defeat the [flame]."

chapter Beast East Bay

Beast East Bay is a trayroom in Eee Say Sea. It is east of Isle Tray Trial. "This is the west edge of an east-west island strip.". shorttext is "Beast". indir is west. printed name is "Beast-East Bay".

chapter West Est Way

West Est Way is a trayroom in Eee Say Sea. It is west of Isle Tray Trial. printed name is "West-Est Way". shorttext is "West". indir is east. "You're at the west end of a long east-west island."

volume regular verbs

check examining:
	if noun is a direction, say "Looking in any direction makes sense, but unfortunately, it won't offer any clues in [this-game]." instead;

chapter smelling

the block smelling rule is not listed in any rulebook.

table of smellies
smell-thing	smell-text
rose gay grows	"Hard to imagine anyone wouldn't enjoy the [rose]'s scent, unless they were really wrong-headed." [this should come first, or some plain thing]
Ink Stay Stink	"You don't want to smell the [stink]. Really."
ale stay stale	"An unpleasant smell of dried alcohol."
Mel Say Smell	"Best not. Probably drenched in Ew-Phey-Phew cologne."
Or May More	"[pine-say]."
Sprawl All Spray	"[pine-say]."
Raid Aid Ray	"The funny smell makes you think, in a fit of brief snark, the [raid] is also a reek-eek ray[if can-smell-ankh]. Perhaps there's another weird smell in here, too, that might open magic[end if]."

to decide whether can-smell-ankh:
	if got-score of raid aid ray > 4 and did-ray-ankh is false, yes;
	no;

to say pine-say: say "The scent of the [sprawl] overwhelms anything and reminds you of the Pine-Say-Spine, which is kind of weird, because you've never been there, and it's not in this game"

check smelling:
	if noun is in Sci I Say, say "It does smell kind of funny in here. Funny enough, you think 'Reek, eek, ray!'[paragraph break][if got-score of raid aid ray is 0]You wonder if the creators of the ray left the smell in on purpose[else]You can't imagine this would be a setting that works[end if]." instead;
	if noun is location of player:
		repeat through table of smellies:
			if smell-thing entry is touchable:
				say "([the smell-thing entry] has the strongest scent)[paragraph break]";
				say "[smell-text entry][line break]";
				the rule succeeds;
	repeat through table of smellies:
		if noun is smell-thing entry:
			say "[smell-text entry][line break]";
			the rule succeeds;
	say "Nose-ohs? Nay[one of] (most places or things won't have any distinctive smell, and for the few that do, it will be a minor clue)[or][stopping]." instead;

chapter dropping

check dropping: say "You never need to drop anything in this game. Not even to change your name to Drop-Op Dre." instead;

chapter inventory

check taking inventory:
	if player does not have Haul All Hey, say "You aren't carrying anything yet. Maybe talking to Ernie J might get you some stuff to start." instead;
	now all things carried by player are marked for listing;
	now Haul All Hey is unmarked for listing;
	now all helpbooks are unmarked for listing;
	now all diceoils are unmarked for listing;
	now iffy clay cliffy is unmarked for listing;
	now all win-trays are unmarked for listing;
	say "In your Haul-All-Hey:[line break]";
	if number of ingredients carried by player > 0 and sco-use-treat-greedy is true:
		say "  (cooking ingredients: [list of ingredients carried by player])[line break]";
		now all ingredients are unmarked for listing;
	if in-haul is 0, say "  Nothing you can really do anything exciting with. Yet. ";
	list the contents of the player, with newlines, indented, including contents, giving inventory information, with extra indentation, listing marked items only;
	if number of carried helpbooks > 0, say "You [if in-haul is 0]do, however,[else]also[end if] have some literature to help you along: [list of carried helpbooks].";
	if did-raid-aid-mood is true, report-ray-mood;
	note-helpbooks;
	now temp-conditional-line-break is false;
	if iffy clay cliffy is carried by the player:
		say "Iffy Clay Cliffy is also [if iffy-hurt]tucked away carefully for when you can heal him[else]zooming around your ankles, care-free[end if].";
	else:
		now temp-conditional-line-break is true;
	if last-out-room is not Start Art Stay and mrlp is Am Hey Ham, say "[invline]You also remember you last visited [last-out-room], so you can go back there with [b]MO[r].";
	if number of win-trays enclosed by the player > 0, say "[invline]You also have a budding tray collection: [a list of win-trays carried by the player].";
	the rule succeeds;

to say invline:
	if temp-conditional-line-break is true:
		now temp-conditional-line-break is false;
		say "[line break]";

to note-helpbooks:
	if ever-helpbook is false, continue the action;
	if undone-helpbooks is 0:
		say "You have some miscellaneous information rattling around in your head from the books in [Breeding], but it doesn't seem to matter any more.";
		continue the action;
	if debug-state is true, say "[undone-helpbooks] helpbooks undone: [list of undone helpbooks]";
	process the finished-reading-rule of last-helpbook;
	if the rule succeeded:
		say "[last-helpbook] seems to have served you well. Maybe you should gain knowledge from another book from [tough].";
	else:
		say "While this isn't a physical possession, you also have retained a good bit of knowledge from [last-helpbook]. ";

to report-ray-mood:
	repeat through table of Raid Aid Ray Guesses:
		if is-set entry is true:
			let need-new be false;
			if there is a finished-with entry:
				process the finished-with entry;
				now need-new is whether or not the rule succeeded;
			if there is a desc-text entry:
				say "You [if need-new is true]no longer[else]still[end if] feel [desc-text entry][if need-new is true]. Maybe there's something else the Raid Aid Ray can help you with[end if].";
			continue the action;
	say "The mood(s) you once felt from the Raid Aid Ray have passed."; [?? are there any more?]

section after-item listing rule(s)

after printing the name of please ease play while taking inventory: say " ([if ever-ease-play is false]on, and you may not want to (U)se it unless you really want a challenge[else if opt-ease-play is true]on[else]off[end if])"

after printing the name of who ooh hey while taking inventory: say ", to help you with what's named what"

after printing the name of aid fey fade while taking inventory: say ", to eliminate possessions no longer of use"

after printing the name of Ankh Bay Bank while taking inventory: say " ([got-score of ankh bay bank] of [total-score of ankh bay bank] loop-sectors [is-are of got-score of ankh bay bank] dark)"

after printing the name of Hour Pay Power while taking inventory: say " ([pay-power-minutes] charging-minutes left)";

after printing the name of Rover Over Ray while taking inventory: say " (a flashlight)"

after printing the name of Hoarder Order Hey while taking inventory: say " (a rake)"

after printing the name of Unny Bay Bunny while taking inventory: say " (dead, and evil too, so don't worry)"

after printing the name of Ice Day Dice while taking inventory: say " ([if number of carried diceoils is 0]empty[else]containing [list of carried diceoils][end if])";

to decide which number is in-haul:
	let X be the number of things carried by the player;
	decrease X by number of helpbooks enclosed by the player;
	if player has Haul All Hey, decrement X;
	decide on X;

chapter listening

the block listening rule is not listed in any rulebook.

[	if lop is a puzroom and lop is listeny, say "You hear voices in contrast yelling [if player is in At Fray Frat]'Freezin!' / 'Easin[']!'[else if player is in Swing Ing Sway]'Swell! / [']Ell!'[else if player is in still ill stay]'Stun!' / 'Un!'[end if] It seems [balance-text of okay-guesses of location of player]." instead;]

check listening:
	let lop be location of player;
	if player is in Start Art Stay, say "Music to the north." instead;
	if player is in Air Stay Stare, say "'Our way: WAR!' booms under." instead;
	if player is in Breeding Reading Bay or player is in Ovel Nay Novel, say "Nice and secluded. No chance for a din-in day." instead;
	if player is in Sci I Say, say "[if did-raid-aid-ray is false]At first, silence. Then, a song about how it can be a Road Ode Ray. For your road ahead. Perhaps that is a clue[else if ray-needs-rile]The Ring-Ing Ray is annoying to listen to. More importantly, you need to fix it[else]The raid-aid ray is, from the noise it makes, a rumble [']umble ray[end if]." instead;
	if noun is Whale Ail Way and lower bay blower is touchable, try listening to lower bay blower instead;
	if noun is lower bay blower, say "The [blower] emits a weird but catchy tune. Reading [ooh hey who], you recognize it as a mashup of two similarly named songs, one being [one of][']Ope May Mope[or]Mopin['] [']Opin Mae[in random order]. Hmm, a bit odd, but perhaps it is a clue how to get the [blower] to safety. After all, it is a smart mammal, but it can't speak." instead;
	if noun is a song:
		say "You are [if noun is last-song]still[else]now[end if] hearing [noun].";
		if did-ever-song is false, bold-note "You can EXAMINE this song at any time in the future to get it back in your head.";
		now did-ever-song is true;
		now last-song is noun;
		try examining noun instead;
	if player is in Sing Ing Say:
		if number of songs in sing ing say is 0, say "No more songs left to listen to." instead;
		increment cur-song-index;
		if cur-song-index > number of entries in song-list, now cur-song-index is 1;
		let last-song be entry cur-song-index in song-list;
		try listening to last-song instead;
	say "Noise? Oy's? Nay[one of] (most places won't have any distinctive background noise, and for the few that do, it will be a minor clue)[or][stopping]." instead;

chapter going (nowhere)

the don't go diagonal rule is listed first in the check going rules.

check going nowhere (this is the don't go diagonal rule):
	if noun is diagonal, say "You don't need diagonal directions in this game." instead;

definition: a direction (called dir) is watery:
	unless noun is cardinal, no;
	unless location of player is a beachroom, no;
	unless the room noun of location of player is nothing, no;
	if dir is indir of location of player, no;
	yes;

to say how-out of (rm - a room):
	if rm is an isleroom:
		say "You can take the [b]SHIP[r] back to the bays";
	else:
		say "You may need to solve a puzzle to open up passages or get out of here"

check going nowhere:
	let num-vi be number of viable directions;
	let lis-vi be list of viable directions;
	if noun is watery, say "A swim-whim-say like that'd likely lead a Drowned Round Day. [if num-vi is 0][how-out of location of player][else]You can go [list of viable directions], though[end if]." instead;
	if noway-text of location of player is not empty, say "[noway-text of location of player][line break]" instead;
	if mrlp is Eee Say Sea:
		if location of player is isle-no-ship:
			say "You're at a dead end, here. You can go back [indir of location of player] or just take the [b]SHIP[r] directly.";
		else:
			say "This isle is small enough, there's nowhere to explore, really. You can really only use the [b]SHIP[r] to go back.";
		the rule succeeds;
	say "You can't go [noun]. ";
	if number of viable directions is 0:
		say "In fact, you need a special command to figure a way of here.";
	else:
		say "[if number of viable directions is 1]The only way to go is back[else]You can only go [list of viable directions][end if][if mrlp is omable]. You can also [om] back to Start Art Stay[end if]." instead;

to say vi-1: if number of viable directions is 1, say "back "

chapter attacking

the block attacking rule is not listed in any rulebook.

check attacking: say "[next-rand of table of nonviolence]" instead;

chapter kissing

the block kissing rule is not listed in any rulebook.

check kissing: say "No voice proclaims 'Kiss is [']K.' Better not get too affectionate." instead;

chapter swearing obscenely

the block swearing obscenely rule is not listed in any rulebook.
the block swearing mildly rule is not listed in any rulebook.

check swearing mildly: try swearing obscenely instead;

check swearing obscenely:
	if Rude Pay Prude is touchable, say "That might be swearing for the sake of swearing. Maybe if you had some direction to it." instead;
	say "[one of][or]Swearing? Wearing, say![paragraph break][or]Snotty? Naughty, say![paragraph break][or]Crass! Cray![paragraph break][stopping]Your Saint-Ain't Say fails to transport you to Us Cay. Or Erst Cay." instead;

chapter yes/no

the block saying yes rule is not listed in any rulebook.
the block saying no rule is not listed in any rulebook.

check saying yes: say "[one of]Oh, gay go![or]Er, say sure![in random order]" instead;

check saying no: say "[one of]Nuh-uh. Nay.[or]Oh, neigh no![or]Our say: sour![in random order]" instead;

chapter singing

the block singing rule is not listed in any rulebook.

to decide whether i-could-sing:
	if player is in Weird Eared Way and ears fey fears are in Weird Eared Way, yes;
	no;

check singing:
	if i-could-sing, say "This is a place where a song may do good, but it may happen naturally. So you may wish to TALK to anyone in your way or try to go by an obstacle." instead;
	if mrlp is Clout Lout Cay, say "You're not Elton John, so this location is not changed to Croc-Rock Cay." instead;
	if mrlp is Laden Aidin' Ley, say "No new song creeps in your head. This isn't Load Ode Ley." instead;
	if last-song is not itty day ditty:
		say "You have [last-song] in your mind. That's good enough." instead;
	say "A flash of poetic inspiration strikes you! You dream up a song called [next-rand of table of your songs]. Well, the lyrics. But you can't match a tune to it." instead;

chapter waiting

check waiting:
	if mrlp is Brain Reign Bay, say "Wrong stay-strong!" instead;
	if mrlp is Am Hey Ham, say "Steady Eddie, stay!" instead;
	say "[one of]Odd play. Plod.[or]Oh, lay low![in random order][line break]You sort of hope you will blink your eyes and find yourself in Aiding Way, but no luck." instead;

chapter eating

procedural rule while eating something: ignore the carrying requirements rule.

the can't eat unless edible rule is not listed in any rulebook.

check eating:
	if noun is Eight Bay Bait, say "It's not for you to eat." instead;
	if noun is an ingredient, say "The [noun] seems to be an ingredient for something else." instead;
	if noun is Ooh Stay Stew, say "No. It's for others. A whole bunch of others." instead;
	if noun is Treat Eat Tray, say "Oh no. Once you start, you won't be able to stop." instead;
	if noun is Jus Us Jay, say "Whoah, dude. There's a more adventurous way to consume that." instead;
	if noun is a person, say "Sick! Ick! Say!" instead;
	say "Tea, eh? (You don't need to eat anything in this game. Well, not directly.)" instead;

chapter sleeping

the block sleeping rule is not listed in any rulebook.

check sleeping: say "Oh, Z-day. Dozy, you think, but you picture a bunch of monsters ganging up on you with this battle cry: 'Eep! Slay!'" instead;

chapter jumping

the block jumping rule is not listed in any rulebook.

check jumping: say "Hop-ops! Hey! (No ump named Jay appears to stop you.)" instead;

chapter reading

[this must come after reaching]

reading is an action applying to one thing.

understand the command "read" as something new.
understand "read [thing]" as reading.

does the player mean reading a now-readable thing:
	say "[list of now-readable things].";
	it is very likely;

understand "r [a thing]" as reading when not r-is-reaching.

understand "r" as reading when not r-is-reaching.

rule for supplying a missing noun when reading:
	if number of touchable helpbooks is 1:
		now the noun is a random touchable helpbook;
		continue the action;
	if number of now-readable things is 1:
		now the noun is a random now-readable thing;
		continue the action;
	if number of now-readable things is 0:
		say "There's nothing to read (or reach to) at the moment.";
		reject the player's command;
	say "I can't figure what you'd like to read. Please be more specific. You can choose from: [list of now-readable things][if raid aid ray is touchable]. If you want to [b]REACH[r], you need to specify a place[end if].";
	reject the player's command;

carry out reading:
	if noun is a helpbook and noun is not a pagedbook:
		try examining the noun instead;
	if the noun provides the property ever-read, now noun is ever-read;
	if noun is a pagedbook and total-pages of noun is 0:
		say "I haven't implemented what, precisely, is in [noun], but the important thing is, the game notes you've read it. This obviously must be fixed before release.";
		now noun is fully-read;
		the rule succeeds;
	if noun is a pagedbook:
		if cur-page of noun is 0:
			say "You begin reading [noun].[paragraph break]";
			increment cur-page of noun;
		else:
			increment cur-page of noun;
			if cur-page of noun > total-pages of noun:
				now cur-page of noun is 1;
				say "You cycle back to the beginning of [noun].[paragraph break]";
			else:
				say "(page [cur-page of noun] of [total-pages of noun])[paragraph break]";
		choose row cur-page of noun in book-pages of noun;
		say "[my-page entry][line break]";
		now read-yet entry is true;
		if cur-page of noun is total-pages of noun:
			say "[line break]And that's the end.";
			now noun is fully-read;
		the rule succeeds;
	repeat through table of readables:
		if noun is thing-to-read entry:
			process the read-rule entry;
			the rule succeeds;
	say "[one of]Reading is identical to examining for pretty much everything unless specifically indicated if you EXAMINE. So we're going to examine [the noun][or]Examining [the noun][stopping], instead.";
	try examining the noun instead;

table of readables
thing-to-read	read-rule
ankh bay bank	read-ankh rule
ice day dice	read-dice rule
odd pay pod	read-pod rule
raid aid ray	read-raid rule
hip say ship	read-ship rule
eat chez sheet	read-sheet rule
tall say stall	read-stall rule

section reading rules [xxreadrul]

this is the read-ankh rule:
	if ankh bay bank is unscored, say "Once you figure a way [the ankh] works, you can READ it to see what you did." instead;
	say "The loop is divided into [total-score of ankh bay bank] sectors. From where the loop connects with the stem, clockwise, you see[if did-skip-ankh-points is true] (hey, wait, you didn't do all of these):[paragraph break]";
	print-done-guessed ankh bay bank;

this is the read-dice rule:
	if ankh bay bank is unscored, say "Once you figure a way to fill [the dice], you can READ it to see what you did." instead;
	say "The [dice] are divided into [total-score of ice day dice] sectors. Clockwise from what appears to be 12:00, you see:[paragraph break]";
	print-done-guessed ice day dice;

this is the read-pod rule:
	if odd pay pod is unscored, say "Once you buy something from [the pod], you can READ it to see what you've bought." instead;
	say "[paul] has divided [the pod] into eight parts:[paragraph break]";
	print-done-guessed odd pay pod;

this is the read-raid rule:
	if raid aid ray is unscored:
		say "[line break]Unfortunately, the settings are too smudgy to read. You remember Eddie J saying that setting the ray correctly might help fix that. Maybe knowing a few settings might help you figure some others.";
		continue the action;
	let current-set be false;
	say "You read the settings of the raid aid ray:[paragraph break]";
	print-done-guessed raid aid ray;
	process the read-ray-current rule;

this is the read-ray-current rule:
	repeat through table of Raid Aid Ray Guesses:
		if is-set entry is true:
			say "Currently it's set to [firstof of w1 entry] [firstof of w2 entry].";
			the rule succeeds;
	say "The ray isn't set to anything at the moment.";

this is the read-sheet rule:
	say "You see a list of [if hip say ship is allscored]all the dining-related businesses you stopped by[else if hip say ship is unscored]places to eat, or you will, once you've been to one[else]possible dining establishments to visit, or establishments you've been[end if]:[line break]";
	print-done-guessed Eat Chez Sheet;

this is the read-ship rule:
	say "You see a list of [if hip say ship is allscored]all the places you've been[else if hip say ship is unscored]places to go[else]possible places to go and places you've been[end if]:[line break]";
	print-done-guessed hip say ship;
	if hip say ship is not allscored, say "[line break]The huts are rather weird, though. You get the feeling EAT could be anywhere in the name."

this is the read-stall rule:
	say "There are mini-stalls arranged in a horseshoe. They [if tall say stall is unscored]will probably contain animals[else]contain the animals you summoned and rescued[end if]:[line break]";
	print-done-guessed tall say stall;
	if tall say stall is not allscored, say "[line break]SAY seems to be the operative word, here."
[zzreadrul]

section rfing

chapter rfing

rfing is an action applying to one thing.

understand the command "ra" as something new.

understand "ra" as rfing.
understand "ra [something]" as rfing.

carry out rfing:
	if the noun is not a helpbook, say "You can't mark [the noun] as fully read." instead;
	let total-unread be 0;
	repeat through book-pages of noun:
		if read-yet entry is true, next;
		increment total-unread;
		now read-yet entry is true;
	say "[the noun] [if total-unread is 0]has already been[else]is now marked as[end if] fully read[if total-unread > 1]. You skipped [total-unread] page[plur of total-unread][end if].";
	the rule succeeds.

volume special verbs

chapter interheying

to inter-set (ts - a truth state):
	if debug-state is true, say "[list of helpbooks].";
	say "You are [if opt-hinter-reading is ts]already[else]now[end if] [if ts is false]not [end if]getting a HINTER from [shelf elf] if you TALK to him[if player is not in Breeding Reading Bay] once you get back to Breeding Reading Bay[end if].";
	now opt-hinter-reading is ts;

interheying is an action out of world.

understand the command "inter hey" as something new.

understand "inter hey" as interheying when player is in Breeding Reading Bay.

carry out interheying:
	inter-set false;
	the rule succeeds.

chapter hintering

hintering is an action out of world.

understand the command "hinter" as something new.

understand "hinter" as hintering.

carry out hintering:
	inter-set true;
	the rule succeeds.

chapter ay/eh

a thing has a number called ehval. the ehval of a thing is usually 0.

definition: a thing is ehish if its ehval > 0.

does the player mean taking an ehable thing: it is likely.

ehing is an action applying to one thing.

understand the command "eh" as something new.
understand the command "ay" as something new.

understand "eh [something]" as ehing.
understand "ay [something]" as ehing.
understand "eh" as ehing.
understand "ay " as ehing.

rule for supplying a missing noun while ehing:
	let Q be list of touchable ehable things;
	let R be the number of entries in Q;
	if R > 1:
		say "You have more than one thing or person to inquire about, here: [the Q].";
	else if R is 1:
		now the noun is entry 1 of Q;
	else:
		say "There's nothing too esoteric or obscure here. I hope."

carry out ehing:
	repeat through table of ehs:
		if noun is eh-thing entry:
			say "[eh-text entry][line break]";
			the rule succeeds;
	say "Unfortunately, I don't have any detailed information about [the noun]. EH/AY is generally reserved for people and things whose names don't follow the naming conventions.";
	the rule succeeds.

definition: a thing (called the-eh) is ehable:
	if the-eh is an eh-thing listed in table of ehs, yes;
	no;

table of ehs
eh-thing	eh-text
Ellie J	"Jelly, slang for jealous."
Ellis J	"Jealous."
Emlyn Gray	"Gremlin. In other words, something annoying that gums things up."
Ernie J	"Ernie J is here to help you with your journey."
gem	"[one of]The gem is part of a puzzle, so I won't spoil it unless you EH or AY again[or]The gem belongs to someone. It needs initials. What initials, well, that's a puzzle[stopping]."
K	"Carin['], whether you're Aaron or Erin. I'll cheat a bit in the game with a soft 'ing' as well as a silent H. I hope the effect is amusing."

chapter useing

global-flips is a number that varies. global-flips is 0.

check useoning (this is the adjust first or second useon noun as useful rule):
	if second noun is Ellie J:
		now second noun is Ellis J;
	if noun is Ellie J:
		now noun is Ellis J;
	if second noun is a latinable or noun is a latinable:
		if second noun is Raid Aid Ray or noun is Raid Aid Ray:
			if did-break-ray is true:
				if noun is rod or second noun is rod, continue the action;
			say "No, that's not the right part to repair the [raid]." instead;
		say "[if noun is a latinable][preuse-text of noun][else][preuse-text of second noun][end if]" instead;
	if second noun is an ingredient and noun is an ingredient:
		say "[if chef-ingredients-got is 0]You're not a cook, so you wouldn't have success combining [the noun] and [the second noun][else]Perhaps [feedin] would be able to put things together better than you could[end if]." instead;
	if noun is an ingredient and second noun is a person:
		if second noun is not feedin eden faye, say "The [noun] seems more like it can make part of a bigger meal. [second noun] is not a chef." instead;
	if noun and second noun are flippable:
		if debug-state is true, say "Flipping [noun] and [second noun]";
		increment global-flips;
		if global-flips is 2:
			if debug-state is true:
				say "WARNING flipped twice.";
			else:
				try useoning second noun with noun;
	now global-flips is 0;

to decide whether (t1 - a thing) and (t2 - a thing) are flippable:
	if t1 is a person:
		if t2 is not a person, yes;
	no;

useoning it with is an action applying to two things.

understand the command "use" as something new.

carry out useoning:
	if debug-state is true, say "DEBUG: USEONing [noun] on [second noun].";
	repeat through table of useons:
		if noun is u1 entry and second noun is u2 entry:
			if there is a pre-rule entry, abide by the pre-rule entry;
			if there is a post-rule entry, process the post-rule entry;
			if there is a get-point entry:
				process the get-point entry;
				if the rule succeeded, increment the score;
			else:
				increment the score;
			if v1 entry is true, moot u1 entry;
			if v2 entry is true, moot u2 entry;
			if there is a new-item entry, now player has new-item entry;
			[if debug-state is true, say "[u1 entry] mooted: [v1 entry]. [u2 entry] mooted: [v2 entry]. [if there is a new-item entry]Received [new-item entry][else]No new item[end if]. [location of u1 entry]. [location of u2 entry].";]
			the rule succeeds;
		if noun is u2 entry and second noun is u1 entry:
			if debug-state is true, say "DEBUG: flip. USE [u2 entry] on [u1 entry].";
			try useoning u1 entry with u2 entry instead;
	abide by the wide ranging useon rule;
	say "You don't seem to need to use, um, USE [the noun] on [the second noun].";
	the rule succeeds.

this is the wide ranging useon rule:
	if second noun is a person:
		if noun is Sprawl All Spray, say "People may be figurative pests but not literal." instead;
		if noun is Rock Fey Frock, say "You aren't going to force anyone to wear the [frock]." instead;
		if noun is old gay gold, say "You don't seem to need to barter with [the second noun]." instead;
	if noun is ick stay stick or second noun is ick stay stick, say "Not gross enough to use the [stick] on." instead;
	if noun is at bay bat or second noun is at bay bat, say "The [bat] is probably better used for reflexive defense, when you are surprised." instead;

chapter useoning

useing is an action applying to one thing.

understand the command "use" as something new.

understand "use [thing]" as useing.
understand "u [thing]" as useing.

understand "use [thing] on/with [thing]" as useoning it with.
understand "u [thing] on/with [thing]" as useoning it with.

check useing:
	if noun is a latinable, say "[preuse-text of noun]" instead;
	if noun is a person and noun is not iffy clay cliffy, say "No, using other people is in line with the [flame]'s views." instead;
	if noun is player, say "No, USE something you're carrying." instead;
	if noun is a helpbook:
		say "The only use for a book is reading it, so let's try that.";
		try reading noun instead;

carry out useing:
	repeat through table of oneuse:
		if noun is u1 entry:
			if there is a use-rule entry, abide by the use-rule entry;
			if there is a get-point entry:
				process the get-point entry;
				if the rule succeeded, increment the score;
			else:
				increment the score;
			if vanish entry is true, moot noun;
			if there is a new-item entry, now player has new-item entry;
			process the post-rule entry;
			the rule succeeds;
	say "You can't seem to find a way to USE [the noun] on its own. " instead;
	if noun is not enclosed by the player, say "[line break]" instead;
	repeat through table of useons:
		if u1 entry is noun or u2 entry is noun, say "But maybe on or with something else, you could get results." instead;
	say "[line break]";
	the rule succeeds.

section use thing on text

definition: a thing (called th) is oneuseable:
	repeat through table of oneuse:
		if u1 entry is th, yes;
	no;

justusing is an action applying to one thing and one topic.
rjustusing is an action applying to one topic and one thing.

understand "u [thing] on [text]" as justusing.
understand "u [text] on [thing]" as justusing (with nouns reversed).

understand "use [thing] on [text]" as justusing.
understand "use [text] on [thing]" as justusing (with nouns reversed).

carry out justusing:
	if debug-state is true, say "[the noun] [the second noun].";
	if noun is oneuseable:
		say "You can just USE [the noun].";
	else:
		say "I couldn't figure what you wanted to use [the noun] with.";

chapter talking

talking is an action applying to one thing.

understand the command "talk" as something new.

does the player mean talking an npcish person: it is very likely.

rule for supplying a missing noun when talking:
	if number of npcish things is 0:
		say "There's nobody else here to talk to.";
		reject the player's command;
	if number of npcish things > 1:
		say "That is ambiguous. You can talk to [list of npcish things].";
		reject the player's command;
	now the noun is a random npcish thing;

understand "talk to [something]" as talking.
understand "talk [something]" as talking.
understand "t to [something]" as talking.
understand "t [something]" as talking.

understand "t" as talking.

carry out talking:
	if noun is not a person, say "You don't get much response." instead;
	if talk-text of noun is empty, say "[noun] has nothing to say but should. BUG." instead;
	say "[talk-text of noun][line break]";
	now noun is talked-to;
	the rule succeeds.

report talking (this is the acknowledge you talked to someone important rule):
	if noun is Sham Ham Shay:
		move ads chez chad's to Ovel Nay Novel;
		move Odder Fey Fodder to Ovel Nay Novel;
		move This Is They to Ovel Nay Novel;
		move Blab Lab Bay to Ovel Nay Novel;
		move ESP PSA to Ovel Nay Novel;
		move ashtray to Ovel Nay Novel;
		now did-talk-sham is true;
	continue the action;

section talking checks [xxtalkcheck]

check talking Cross Ross K:
	if raw-mood of "raw":
		say "Cross Ross K begins some woe-is-me spiel, but you say 'awww' just right. He continues, and you sit strong. You're obviously not a very good person to whine constructively at, and that's quite selfish of you. Ross K goes off to find someone more willing to listen to his profound despair and complaints.";
		moot Cross Ross K;
		now sco-talk-cross is true;
		increment the score; [cmd: t cross ross k]
		the rule succeeds;

check talking Ernie J:
		if Ernie J is talked-to, say "'Step inside for something to read before our next chat.'" instead;

check talking Hood Say Should:
	if last-helpbook is not I Slay Sly:
		say "[should] isn't interested in you. You're not smooth enough.";
		the rule fails;
	if not raw-mood of "rat":
		say "You could probably get [should] interested in you, but unfortunately, you have no way to ditch [should].";
		the rule fails;
	if did-talk-should is false:
		say "[should] smiles. 'I like you. So, you have something to show me?' [should] waits for your next move.";
		now did-talk-should is true;
		the rule succeeds;
	if player is in Cop Op Cay:
		say "You make a bit of small talk with [should]. Slowly, [should] begins confessing some shady activities. The [scam] picks it up. And oh, is there gaffling and the like! Said gaffling knocks the [scam] from its perch before [should] is carried away. And after said gaffling, you notice something fell from [should]'s pocket. A gem! It was stolen from someone, for sure. But whom?";
		increment the score; [cmd:T HOOD SAY SHOULD]
		moot hood say should;
		now sco-talk-should is true;
		now player has gem;
		now player has am kay cam;
		now clamp amp clay is in Cramp Ramp Cay;
		the rule succeeds;
	else if did-talk-should is true:
		say "This might not be the place to make further small talk with [should].";
		the rule fails;

check talking MC See Em Eh:
	if raw-mood of "rap":
		say "You feel ready to accept [MC]'s rap duel challenge. You're surprised at how good you are. MC See Em Eh congratulates you on being, well, equal (not better, of course, but your doing well without curse words was a teachable moment) and is impressed enough to assure you his hype man, Shout-Out Shay, will name-drop you and to hand you a Quill-A-Equal before walking off. Or maybe a Quill-Eh-Equal. Whatever, it's something.";
		now player has Quill Eh Equal;
		now sco-talk-mc is true;
		increment the score; [cmd: t mc see em eh]
		the rule succeeds;

check talking Quiet Wyatt K:
	if raw-mood of "rowdy":
		say "Quiet Wyatt K is stuck by your outburst. It's unclear whether or not he's flattered or scared, but either way, he shrugs and gets up. He'll never be an Us-Gay Gus, but he's no longer blocking the way east, and that makes you feel--and the room seem--a little brighter.";
		increment the score; [cmd: t quiet wyatt k]
		now sco-talk-quiet is true;
		moot Quiet Wyatt K;
		the rule succeeds;

check talking rude pay prude:
	if last-helpbook is Where Say Swear:
		say "You consult [swear]. Now is the time. It's not just about how, but where, to swear, and you do so. The [prude] is shocked enough to leave. As the [prude] leaves, the Charred Hard Cay becomes cheerier. Some of the charred bits crack open!";
		now sco-talk-prude is true;
		increment the score; [cmd: T RUDE PAY PRUDE]
		the rule succeeds;

check talking Shelf Elf Shay: if Who Ooh Hey is off-stage, now player has Who Ooh Hey;

[zztalkcheck]

volume option verbs

chapter rming

rming is an action applying to nothing.

understand the command "rm" as something new.

understand "rm" as rming.

carry out rming:
	now opt-short-names is whether or not opt-short-names is false;
	say "Short room view is now [on-off of opt-short-names] for visited rooms.";
	the rule succeeds.

chapter tding

tding is an action applying to nothing.

understand the command "td" as something new.

understand "td" as tding.

carry out tding:
	now opt-track-done is whether or not opt-track-done is false;
	say "Tracking done rooms is now [on-off of opt-track-done].";
	the rule succeeds.

chapter bding

bding is an action applying to nothing.

understand the command "bd" as something new.

understand "bd" as bding.

carry out bding:
	now opt-block-done is whether or not opt-block-done is false;
	say "Blocking done rooms is now [on-off of opt-block-done].";
	the rule succeeds.

volume meta verbs

chapter thinking

the block thinking rule is not listed in any rulebook.

this is the initial-help rule:
	if note-om-mo is true:
		if Sci I Say is unvisited, say "The Raid Aid Ray west of [here-there of Start Art Stay] is something you'll need to look at eventually." instead;
		continue the action;
	if mrlp is Am Hey Ham:
		if Ernie J is not talked-to, say "Try talking to Ernie J first." instead;
		if Breeding Reading Bay is unvisited, say "Not much to think about yet. Try going inside[of-room of Start Art Stay] for more help materials." instead;
		if Shelf Elf Shay is not talked-to, say "Try talking to [shelf elf shay] now." instead;
		if Sci I Say is unvisited and note-om-mo is false, say "You may wish to look west[of-room of Start Art Stay], but you can also just use the Reach Each ray to leave." instead;
		say "You can use the Reach Each Ray[in-room of Start Art Stay] to explore new areas, [if got-score of raid aid ray is 2]especially now you temporarily broke[else if got-score of raid aid ray is 1]or you can poke more at[else if got-score of raid aid ray is 0]or you can try to figure[end if] the Raid Aid Ray[in-room of Sci I Say][if raid-think-later]. Then you'll be able to retry your good ideas with more success[end if]." instead;

carry out thinking:
	abide by the initial-help rule;
	let any-think be false;
	repeat through table of thinkentries:
		process the think-rule entry;
		unless the rule succeeded, next;
		if any-think is false, say "THINGS THAT SHOULD WORK LATER:[line break]";
		now any-think is true;
		say "[think-unready entry][line break]";
	if Isle Away Awhile is thought-yet:
		if sco-use-cable-blower is true:
			say "Now you're exhausted, you could use that trip [if player is not in Oats Bay]from Oats Bay [end if]to Isle Away Awhile you considered before.";
		else:
			say "Isle Away Awhile would be nice to visit once you are exhausted.";
		the rule succeeds;
	let it be list of thought-yet islerooms;
	let ii be number of entries in it;
	if ii > 0:
		say "You [if any-think is true]also [end if]thought up [if ii > 1]another isle[else]other isles[end if] worth exploring while exhausted from moving the whale: [list of thought-yet islerooms].";
		now any-think is true;
	if any-think is false, say "You think back to everything you tried. Was there anything that should've worked, but didn't quite? Not that you can remember. Well, if you do get a good guess, it will pop up here.";

[we'd like to use everything as, say, 3 variables and "ready" and "unready" text but I don't see as clean a way to do this in Inform as, say, Python. This code is emphatically Not Good Enough, but it works well enough. The alternative is to have a lot of repetitive code in the Think Display Rules belpw.]

table of thinkentries
think-rule	think-unready
think-ankh-clank rule	"There must be somewhere with vulnerable clay to CLANK the ankh."
think-ankh-flank rule	"You tried to FLAY FLANK with the ankh, but you weren't in a combat[if player is in grand and gray land and ley]. You are now. Go for it[end if]."
think-ankh-prank rule	"There must be somewhere to PRAY as a PRANK with the ankh."
think-cliffy-small rule	"You need to figure a way to [if sco-use-cliffy-cracked is false]use a smaller version of Cliffy[else]make Cliffy better again[end if] to reach in the [small]."
think-foil-proof rule	"You need to find a place where the [proof] could cover something before using the [foil] on it."
think-function-cliffy rule	"You tried to use the [function] on Cliffy, [if sco-use-cliffy-cracked is false]but he wasn't injured yet[else]but the [function] is still too lumpy[else]and maybe now you can try again[end if]."
think-lit-jay rule	"You need to find a place to light the [jus] that might annoy and shock someone who deserves it."
think-plus-churchin rule	"You need to feel a bit more loose around [Churchin] before you use [plus us play] in his presence."
think-pole-hold rule	"You could maybe use the [pole] on the [hold] with [smell] gone."
think-proof-falter rule	"You need to find some material that would meld the [proof] to the [falter]."
think-raid-aid-ray-use rule	"[if sco-use-clever is false]How to set the Raid Aid Ray after fixing it:[else]You've fixed the Raid Aid Ray, so now you can try setting it to[end if] [raw-ray-todo]."
think-rend-end rule	"You tried to REND END when you weren't close enough to the end, [if final-battle-points is 2]but you're close, now[else if final-battle-points is 1]and while you've gotten closer, there's still a bit to go[else]and you still don't have any allies to help you finish anything you start[end if]."
think-rod-ray rule	"Maybe you can use the odd ray rod on the Raid Aid Ray if it breaks again."
think-saw-slumber rule	"You need to find the right place to cut up the [slumber] with the [saw]."
think-seat-greedy rule	"[if sco-use-seat-greedy is true]Now [feedin] has something to put food in, she may be able to use the ingredients you offered earlier[else]You need to find something for [feedin] to put food into[end if]."
think-stick-clumsy rule	"You need a bit more skill to poke the [clumsy] with the [stick]."
think-string-hark rule	"You need to get rid of [self] to use the [string] on the [hark]."
think-use-clever rule	"[if did-break-ray is false]You didn't see any reason to use the Clever Lever, yet[else]Maybe you can use the Clever Lever now[end if]."
think-use-phone rule	"[if Blight Light Bay is unvisited]You didn't have any reason to use the fey own phone when you first tried[else]Perhaps you can use the fey own phone now you've seen unnatural darkness[end if]."
think-vg-mj rule	"[if sco-vg-mj is false]The gem is somebody's in Blingling Bay, but to use it, you need to find whose it is[else]You figured who owned the gem, so maybe you can go back to Blingling Bay and use it now[end if]."
think-visor-blot rule	"You tried to use the [visor] on [blot], but it wasn't charged."

to decide whether raid-think-later:
	repeat through table of Raid Aid Ray Guesses:
		if tried-yet entry is true and can-work entry is true, yes;
	no;

[thkchk.py can verify below]

section think display rules [xxthink]

this is the think-ankh-clank rule: if thinkable of think-ankh-clank and sco-ankh-clank, the rule succeeds;

this is the think-ankh-flank rule: if thinkable of think-ankh-flank and sco-ankh-flank, the rule succeeds;

this is the think-ankh-prank rule: if thinkable of think-ankh-prank and sco-ankh-prank, the rule succeeds;

this is the think-cliffy-small rule: if thinkable of think-cliffy-small and sco-use-cliffy-small, the rule succeeds;

this is the think-foil-proof rule: if thinkable of think-foil-proof and sco-use-foil-proof, the rule succeeds;

this is the think-lit-jay rule: if thinkable of think-lit-jay and sco-use-lit-jay, the rule succeeds;

this is the think-plus-churchin rule: if thinkable of think-plus-churchin and sco-use-plus-churchin, the rule succeeds;

this is the think-pole-hold rule: if thinkable of think-pole-hold and sco-use-pole-hold, the rule succeeds;

this is the think-proof-falter rule: if thinkable of think-proof-falter and sco-use-proof-falter, the rule succeeds;

this is the think-raid-aid-ray-use rule: if raid-think-later, the rule succeeds;

this is the think-rend-end rule: if think-rend-end is true and sco-rend-end is false, the rule succeeds;

this is the think-rod-ray rule: if thinkable of think-rod-ray and sco-use-rod-ray, the rule succeeds;

this is the think-saw-slumber rule: if thinkable of think-saw-slumber and sco-use-saw-slumber, the rule succeeds;

this is the think-function-cliffy rule: if thinkable of think-function-cliffy and sco-use-function-cliffy, the rule succeeds;

this is the think-seat-greedy rule: if thinkable of think-seat-greedy and sco-use-seat-greedy, the rule succeeds;

this is the think-stick-clumsy rule: if thinkable of think-stick-clumsy and sco-use-stick-clumsy, the rule succeeds;

this is the think-string-hark rule: if thinkable of think-string-hark and sco-use-string-hark, the rule succeeds;

this is the think-use-clever rule: if thinkable of think-use-clever and sco-use-clever, the rule succeeds;

this is the think-use-phone rule: if thinkable of think-use-phone and sco-use-phone, the rule succeeds;

this is the think-vg-mj rule: if thinkable of think-vg-mj and sco-use-gem, the rule succeeds;

this is the think-visor-blot rule: if thinkable of think-visor-blot and sco-use-visor-blot, the rule succeeds;

[zzthink]

section think display stubs

to say raw-ray-todo:
	let settings-so-far be 0;
	repeat through table of Raid Aid Ray Guesses:
		if tried-yet entry is true and can-work entry is true:
			if settings-so-far > 0, say ", ";
			say "[firstof of w1 entry]/[firstof of w2 entry]";
			increment settings-so-far;

chapter scoreing

to say-visit-total (reg - a region):
	if number of visited rooms in reg is 0:
		say "You haven't visited anywhere in [reg] yet.";
	else if number of unvisited rooms in reg is 0:
		say "You've visited everywhere in [reg].";
	else:
		say "You've visited [number of visited rooms in reg] of [number of rooms in reg] rooms in [reg].";

to list-good-bad (LA - a latinable):
	repeat through guess-table of LA:
		if can-work entry is true and worked-yet entry is false, say "DEBUG: [LA] to-do: [firstof of w1 entry] [firstof of w2 entry].";

check requesting the score:
	if Ernie J is in Start Art Stay, say "You need to start your adventure by TALKing to Ernie J." instead;
	say "Your current score is [score] out of a maximum of [maximum score].";
	repeat with LA running through latinables:
		if LA is allscored:
			say "You have done all you could with [the LA].";
		else if LA is not unscored:
			say "You found [got-score of LA] way[plur of got-score of LA] to work [the LA].";
			if debug-state is true:
				list-good-bad LA;
	say-visit-total Brain Reign Bay;
	say-visit-total Clout Lout Cay;
	if debug-state is true, say "DEBUG: good guesses = [global-good-guesses].";
	the rule succeeds;

chapter creditsing

creditsing is an action out of world.

understand the command "credits" as something new.

understand "credits" as creditsing.

carry out creditsing:
	say "Thanks to (alphabetically) Wade Clarke, Chris Conley, dgtziea, Dark Star, Arthur DiBianca, Anssi RÃ¤isÃ¤nen, Brian Rushton, Wesley Werner and Ingrid Wolf for testing. They helped you to, um, seize ease, say.[paragraph break]All of my games can be a bear to test but this one felt particularly weird. So I am grateful for their patience with bugs and with the confusing stuff even after the bugs were fixed and their general good questions that tipped off more than they thought they did. And for helping my procrastinating self get going.[paragraph break]No matter how good or bad my game might be, I appreciate their efforts in helping make it closer to my goal.";
	the rule succeeds.

chapter abouting

abouting is an action out of world.

understand the command "about" as something new.

understand "about" as abouting.

carry out abouting:
	say "[i]Under They Thunder[r] was originally written for the 2019 IFComp. It started out as a silly 'of course it can't go anywhere' idea, and while it's limited, it's also got few enough possibilities I didn't lose myself, and I hope the wrinkles on a theme are interesting. I always like guess-the-verb in parser games if it's well done, and the, uh, mechanic here seemed not to be too esoteric. But the game strayed a bit. So I had to shelve it for later.[paragraph break]I spent a lot of times listing this game's weakness and realizing some people just wouldn't like it, but it gave me enough genuine laughs, and I hope it does for you, too. It seemed to flip quickly from 'way too small for a real game' to 'way too big to be accessible,' but I hope there's value in it, and maybe it will inspire you to try something odd.";
	say "[line break][b]CREDITS[r] tells who patiently discovered and helped me smash bugs both technical and narrative, while [b]VERBS[r] or just [b]V[r] gives a rundown of the main verbs you will want or need to use.";
	the rule succeeds.

chapter verbsing

verbsing is an action applying to nothing.

understand the command "verbs" as something new.
understand the command "verb" as something new.
understand the command "v" as something new.

understand "verbs" as verbsing.
understand "verb" as verbsing.
understand "v" as verbsing.

carry out verbsing:
	say "This game doesn't require many of the standard parser verbs. I have also tried to abbreviate the verbs this game does use. You can move in the four major directions with N, S, E, W and (more rarely) up/down with U and D.";
	say "[line break]You can [b]U[r]/[b]USE[r] (an item) to use it in general in a room, or you can [b]U[r]/[b]USE[r] (item) [b]ON/WITH[r] (item) to use two items together--you don't have to be holding both. Note [b]U[r] by itself just goes up. This replaces the regular parser verbs.";
	say "[line break]You can [b]T[r] (a person) as shorthand for [b]TALK TO[r].";
	say "[line break]Some locations may seem incomplete. You may need a special verb or verbs to figure out what to do.";
	if note-om-mo is true, say "[line break]If you are in the main region, [om-help] will return you home. Then [mo-help] will send you to the last place you were at beyond the home region[if mrlp is Am Hey Ham], currently [last-out-room][end if].";
	if player is in Start Art Stay and reach each ray is in Start Art Stay, say "[line break]You can [b]R[r] or [b]REACH[r] any area depicted in the [heart art].";
	say "[line break][b]READ[r]ing something sometimes gives a bit more information than [b]X/EXAMINE[r]ing it, especially if it is a book. [b]RA[r] marks a long book as finished. [b]R[r] is a shortcut. It should not clash with [b]REACH[r]. Also, [b]SMELL[r] and [b]LISTEN[r] may give minor clues in rooms where background noises or odors are indicated.";
	say "The [please] can be used with PEP (something). This will give clues[if opt-ease-play is false], though you will need to USE the [please] first to turn it on.";
	if sco-use-cable-blower is true and player is not in Gray Land, say "[line break][b]OP HEY HOP[r] will also jump you to the final battle, where you only need a couple of commands to win.";
	say "[line break]You can also see a list of [b]META[r] verbs not critical to the game but possibly informative. ([b]I[r])nventory, [b]SCORE[r] and [b]THINK[r] (which may clue you to current tasks, or things you did that were on the right track) are the main ones.";
	say "[line break]You can also see [b]OPTIONS[r] ([b]OPTS[r] or [b]OPT[r] also works).";

chapter optsing

optsing is an action applying to nothing.

understand the command "opts" as something new.
understand the command "opt" as something new.
understand the command "options" as something new.

understand "opt" as optsing.
understand "opts" as optsing.
understand "options" as optsing.

carry out optsing:
	say "You can toggle short room names with [b]RM[r]. Short room names are currently [on-off of opt-short-names].";
	say "You can toggle ignoring done dead-end rooms with [b]TD[r]. Ignoring done dead-end rooms is currently [on-off of opt-block-done].";
	say "You can toggle tracking finished rooms with [b]BD[r]. Tracking dead ends is currently [on-off of opt-track-done].";
	if any-local-opts:
		say "[line break]VERBS LOCAL TO THIS ROOM:";
		if player is in Breeding Reading Bay:
			say "[line break]  [b]HINTER[r] lets [shelf elf] kibitz on the books you read, but [b]INTER HEY[r] keeps [shelf elf] quiet. Hinting is currently [on-off of opt-hinter-reading].";
	the rule succeeds.

chapter metaing

metaing is an action applying to nothing.

understand the command "meta" as something new.

understand "meta" as metaing.

carry out metaing:
	say "[b](I)NVENTORY[r] tells you what you are carrying.";
	say "[b]SCORE[r] tells your current score.";
	say "[b]THINK[r] tells you about any puzzles you may have partially figured or points you to the next place to look.";
	say "[b]EH[r] or [b]AY[r] will give you information about something that doesn't obviously conform to the game's general, uh, structure. If it is part of a puzzle, you will be warned first, before potential spoilers.";
	say "[line break][b]ABOUT[r] and [b]CREDITS[r] will give you information about the game and the people who helped me make it better.";
	the rule succeeds.

volume irregular verbs

book gotoing (if we have time to implement it)

this is the can-i-goto rule:
	if player is in grand and gray land and ley, say "This is the final confrontation! There's no way back." instead;
	if in-any-chase, say "Unfortunately, you can't just vanish while [cur-chaser] is chasing you." instead;
	if goading-should, say "Unfortunately, you can't just vanish with [should] around. Well, you could, but it'd get sticky. You will be able to dispose of [hood]." instead;
	if sco-use-stew-greedy is true and sco-use-grunt-flab is false, say "You're too full. You aren't up to moving around right now. You might say you're in an ... ate-stay state.[paragraph break]You could use a quick workout to shake off the extra pounds and torpor here." instead;

book actions

chapter cussing (game specific)

pigcussing is an action out of world.

understand "itshay" and "apcray" and "uckfay" and "amday" and "amnday" as pigcussing.

carry out pigcussing: say "[one of]Ame-shay[or]Acky-tay[or]Anguage-lay[in random order]!";

chapter xyzzying

xyzzying is an action applying to nothing.

understand the command "xyzzy" as something new.

understand "xyzzy" as xyzzying.

carry out xyzzying:
	say "A hollow voice booms 'Ugh! Play!' Well, you couldn't have expected it to boom 'Oho, yay.'";
	the rule succeeds.

chapter opheyhoping

opheyhoping is an action applying to nothing.

understand the command "op hey hop" as something new.

understand "op hey hop" as opheyhoping.

check opheyhoping:
	if Isle Away Awhile is unvisited:
		if in-beta is true:
			say "You shouldn't have been informed of this command yet, but since you're a beta tester, I'll let you take a look at it. Go ahead anyway? Saying no will show you what the end-player will see.";
			if the player consents:
				say "OK.";
				continue the action;
		say "You may be looking ahead a bit. You need to reach the inner ring of Brain Reign Bay and rest up before using this warp command." instead;

carry out opheyhoping:
	say "You jump ahead...";
	move player to Grand and Gray Land and Ley;
	move Leet Fey Fleet to Grand and Gray Land and Ley;
	if not-guessed of ankh bay bank > 1, now did-skip-ankh-points is true;
	if player does not have ankh bay bank, now did-skip-ankh is true;
	repeat through table of ankh bay bank guesses:
		if can-work entry is true:
			if ankh-check entry is ankh-flay-flank rule:
				now worked-yet entry is false;
			else:
				now worked-yet entry is true;
	say "[line break]...you're not left with much. Except what [ernie j] gave you to start[if player does not have ankh bay bank]. But wait! A glowing ankh appears in your hands! This probably didn't happen by accident[end if].";
	now player has Ankh Bay Bank;
	now did-hey-hop is true;
	the rule succeeds.

book options

[ please ease play / harder ardor hey ]

book do endgame

to do-endgame:
	say "YOU WIN!";
	end the game in victory;

volume blocking

chapter roomblock rule(s)

the roomblock rules are a room based rulebook.

a roomblock rule for a room (called rm) (this is the blockcheck rule):
	if opt-block-done is false, continue the action;
	process the block-room-rule of rm;
	if the rule succeeded:
		say "You're done in [rm] any possible rooms connected to it, and since you have the block-done option turned on, I am rejecting this command.";
		the rule fails;

check going when opt-block-done is true:
	let rm be the room noun of location of player;
	if rm is nowhere, continue the action;
	abide by the blockcheck rule for rm;

chapter rule definitions

section Brain Reign Bay definitions

[xxruledefbrain]

block-room-rule of Bleak Leak Bay is trivially false rule.
done-room-rule of Bleak Leak Bay is done-bleak-leak-bay rule.

done-room-rule of Bling Ling Bay is done-blingling-bay rule.
block-room-rule of Bling Ling Bay is trivially false rule.
this is the done-blingling-bay rule: if sco-use-gem is true, the rule succeeds;

[zzruledefbrain]

section Clout Lout Cay definitions

[xxruledefclout]

block-room-rule of Charred Hard Cay is trivially false rule.
done-room-rule of Charred Hard Cay is done-charred-hard-cay rule.

[zzruledefclout]

section Eee Say Sea definitions

[xxruledefsea]

done-room-rule of Beast East Bay is done-beast-east-bay rule.
block-room-rule of Beast East Bay is block-done-isle-tray-trial rule.

done-room-rule of Isle Bay Bile is done-isle-bay-bile rule.
block-room-rule of Isle Bay Bile is done-isle-bay-bile rule.

done-room-rule of Isle Day Dial is done-isle-day-dial rule.
block-room-rule of Isle Day Dial is done-isle-day-dial rule.

done-room-rule of Isle Gay Guile is done-isle-gay-guile rule.
block-room-rule of Isle Gay Guile is done-isle-gay-guile rule.

done-room-rule of Isle May Mile is done-isle-may-mile rule.
block-room-rule of Isle May Mile is done-isle-may-mile rule.

done-room-rule of Isle Stay Style is done-isle-stay-style rule.
block-room-rule of Isle Stay Style is done-isle-stay-style rule.

done-room-rule of Isle Tray Trial is done-isle-tray-trial rule.
block-room-rule of Isle Tray Trial is block-done-isle-tray-trial rule.

done-room-rule of West Est Way is done-westest-way rule.
block-room-rule of West Est Way is block-done-isle-tray-trial rule.

[zzruledefsea]

chapter rule code

section Brain Reign Bay code

[xxrulecodebrain]

this is the done-bleak-leak-bay rule: if sco-use-clod-sleek is true, the rule succeeds;

[zzrulecodebrain]

section Clout Lout Cay code

[xxrulecodeclout]

this is the done-charred-hard-cay rule: if gem is not in Charred Hard Cay, the rule succeeds;

[zzrulecodeclout]

section Eee Say Sea code

[xxrulecodesea]

this is the block-done-isle-tray-trial rule: if Isle Tray Trial is finished and West Est Way is finished and Beast East Bay is finished, the rule succeeds;

this is the done-isle-bay-bile rule: if oafy tray is not in Isle Bay Bile, the rule succeeds;

this is the done-isle-day-dial rule: if sco-use-phone is true, the rule succeeds;

this is the done-isle-gay-guile rule: if Plus Us Play is not in Isle Gay Guile, the rule succeeds;

this is the done-isle-may-mile rule: if Sprawl All Spray is not in Isle May Mile, the rule succeeds;

this is the done-isle-stay-style rule: if frock is not in Isle Stay Style, the rule succeeds;

this is the done-isle-tray-trial rule: if Isle Tray Trial is finished, the rule succeeds;
this is the done-beast-east-bay rule: if Beast East Bay is finished, the rule succeeds;
this is the done-westest-way rule: if West Est Way is finished, the rule succeeds;

[zzrulecodesea]

volume parser manipulation and errors and disambiguation

rule for asking which do you mean (this is the bypass disambiguation rule):
	if current action is reaching:
		say "You may need to be more specific where you want to reach. Each location's first word should be unique.";
		bypass disambiguation;
		the rule succeeds;
	continue the action;

book move-break and move-no-break

to move-no-break-at-all (rm - a room):
	move the player to rm, without printing a room description;
	say "[b][location of player][r][line break]";
	say "[description of location of player]"; [stupid stuff to get rid of line break]

to move-no-break (rm - a room):
	move-no-break-at-all rm;
	say "[line break]";

book undo and other meta commands

chapter undo

report undoing an action:
	say "'Un-say, son,' a voice booms, oblivious to your gender.";
	the rule succeeds;

rule for deciding whether to allow undo:
	if player is in Ere Say Seer:
		say "Cheater Eater Che stares at you a bit. Whether or not you cheated or intended to cheat with UNDO, your fear of Che pulling out an Ouch-Slay-Slouch overcomes your willingness to double-dip with hints. Of course, you could still SAVE and RESTORE, but I didn't want to make things too easy.";
		deny undo;
	allow undo;

chapter meta

check saving the game for the first time: say "An irrelevant nuisance voice whispers 'Store or stay?'";

book command pre-reading

volume Clout Lout Cay

book Cold Old Cay 0 0

to decide which number is cay-score:
	decide on boolval of sco-vg-clamber + boolval of sco-vg-clues;

Cold Old Cay is a beachroom in Clout Lout Cay. printed name of Cold Old Cay is "[if cay-score is 2]Cased Aced Cay[else if cay-score is 1]Caught-Ought Cay[else]Cold Old Cay[end if]". shorttext of Cold Old Cay is "[if cay-score is 2]Cased[else if cay-score is 1]Caught[else]Cold[end if]". description is "You are at the northwest corner of [clout]. [clay-in-old-cay]."

understand "caught ought cay" and "caught ought" and "caught/ought cay" and "caught/ought" as Cold Old Cay when cay-score > 1.

understand "cased aced cay" and "cased aced" and "cased/aced cay" and "cased/aced" as Cold Old Cay when cay-score is 2.

last-room of Clout Lout Cay is Cold Old Cay.

to say clay-in-old-cay:
	if cay-score is 0:
		say "It's too treacherous to just walk south through some amber clay or east through some ooze clay, but maybe you can figure out";
	else if cay-score is 2:
		say "You figured ways both east and south";
	else:
		say "You've sort of figured how to get started here. You can go [if sco-vg-clamber is true]south now, though ooze clay blocks your way east[else]east now, though amber clay blocks your way south[end if]";

chapter amber clay

the amber clay is scenery in Cold Old Cay. "It's certainly steep. Maybe there is a way to get up it.". [nopunc]

section clambering

clambering is an action applying to nothing.

understand the command "clamber" as something new.

understand "clamber" as clambering when player is in Cold Old Cay.

carry out clambering:
	if sco-vg-clamber is true:
		say "You already clambered. You can just walk south. So you do.";
		try going south instead;
	say "Yes, you practice going up, and after a few falls, you get the hang of it. Just as you get near the top, the amber clay collapses in a slow mudslide, making a much easier path south once it stops.[paragraph break]Unfortunately, a good chunk of the clay gets on your hands. The [fade] doesn't zap it, so you have to find a plastic bag to dump the yucky stuff in. [ooh hey who] labels it as [slop]. Perhaps because it wasn't zapped, it might be useful later.";
	increment the score; [cmd: CLAMBER]
	now sco-vg-clamber is true;
	moot amber clay;
	now player has op slay slop;
	the rule succeeds.

section op slay slop

the Op Slay Slop is a useful thing. description is "Fortunately, you managed to wipe most of it off before dumping it in the [haul]. Hooray for having hands! But it could probably gum up ops for more dexterous entities than yourself.". printed name is "Op-Slay Slop".

chapter ooze clay

the ooze clay is scenery in Cold Old Cay. "It's too porous to walk through without paying close attention, but you're not sure what to look for.". [nopunc]

chapter cluesing

cluesing is an action applying to nothing.

understand the command "clues" as something new.

understand "clues" as cluesing when player is in Cold Old Cay.

carry out cluesing:
	if sco-vg-clues is true:
		say "You already looked for clues. You can just walk east. So you do.";
		try going east instead;
	say "You experiment a bit--what part of the ooze clay is safe to walk on? How can you notice it? When does your foot sink? And eventually you track an easy path through. It's really only about twenty feet across, and the pattern's easy enough to remember after going back and forth a couple times.";
	increment the score; [cmd: CLUES]
	now sco-vg-clues is true;
	moot ooze clay;
	the rule succeeds.

book Cop Op Cay 1 0

Cop Op Cay is a beachroom in Clout Lout Cay. It is east of Cold Old Cay. "A passage runs east-west here. [if scam cam say is touchable][one of]You feel you're being watched, and after you look around, you see ... a [scam]. It's watching for any sort of indiscretion[or]The [scam] is still watching you[stopping][else]It's much more peaceful with the [scam] gone[end if].". shorttext is "Amber". indir is south. printed name is "Cop-Op Cay".

chapter scam cam say

the scam cam say is scenery in Cop Op Cay. "You don't want to look too closely at the [scam], because it is almost certainly watching you.". printed name is "scam cam (say)".

chapter am kay cam

the am kay cam is a twoway thing. printed name is "am-[']kay cam". description is "[cam-desc]."

to say cam-desc:
	if sco-use-cam-dad is true:
		say "It has very uplifting message from [dad]. It's not for you, but it's for somebody, or some group";
	else:
		say "It seems far less sinister than the [scam] that was watching you in [Cop Op Cay]. Currently [if did-use-power-cam is true]it's powered back up[else]it doesn't seem operable. Not broken, just, no battery[end if]"

book Cramp Ramp Cay 2 0

Cramp Ramp Cay is a beachroom in Clout Lout Cay. It is east of Cop Op Cay. "[if sco-use-oafy-tray-emlyn is false]Oh man! You could go up the ramp to the east, but it's too steep[else]With Emlyn Gray gone, the way up east does not seem so bad[end if][if clamp amp clay is touchable]. Some clamp amp clay has been revealed under what used to be the cramp ramp. What could fit in there?[else].[end if]". printed name is "[if sco-use-oafy-tray-emlyn is false]Cramp Ramp[else]Clamp Lamp[end if] Cay". shorttext is "[if sco-use-oafy-tray-emlyn is false]Cramp[else]Clamp[end if]". indir is south.

understand "clamp lamp cay" and "clamp lamp" and "clamp/lamp cay" and "clamp/lamp" as Cramp Ramp Cay when sco-use-oafy-tray-emlyn is true.

chapter Clamp Amp Clay

the clamp amp clay is needy scenery. "Perhaps you don't precisely need a lamp to fit in here.". printed name is "clamp-amp clay".

chapter Emlyn Gray

Emlyn Gray is a needy person in Cramp Ramp Cay. talk-text of Emlyn Gray is "Emlyn Gray talks about himself at length, about how he deserves an award for just being himself and has never gotten one, and that is proof society is bogus. No possible amount of erudition or conversational skills could stop this. Perhaps a gift might shut him up.'". "[one of]'Hi! You know who I am, right? Emlyn Gray! Never heard of me? Boy, you need to get out more.'[or]Emlyn Gray continues to preen as if expecting a compliment or gift for imparting such 'wisdom.'[stopping]". description is "[emlyn] looks pleased with himself, then looks disappointed you're not pleased enough with him.". [nopunc]

understand "gremlin" as Emlyn Gray.

check going east in Cramp Ramp Cay when Emlyn Gray is touchable: say "Emlyn Gray stops you. 'Oh, no. I can't let you do that. Well, I can, but I don't want to. I'm just that sort of annoying. So annoying, I deserve an award!'[paragraph break]There's only room for one person on the cramp ramp to the east, and Emlyn Gray won't move just BECAUSE." instead;

book Cruddy Ruddy Cay 3 0

Cruddy Ruddy Cay is a beachroom in Clout Lout Cay. It is east of Cramp Ramp Cay. indir is south. printed name is "[if sco-talk-should is true]Cresting Resting Cay[else]Cruddy Ruddy Cay[end if]". shorttext is "[if sco-talk-should is true]Cresting[else]Cruddy[end if]". "[if sco-talk-should is true]It's much more relaxed here with Hood-Say-Should gone. You can go east or west without thinking of things[else]This isn't a very fun place, especially with someone seedy nearby. There's no hope of continuing east unless you figure a way past them, but you can go back west[end if]."

understand "cresting resting cay" and "cresting resting" and "cresting/resting cay" and "cresting/resting" as Cruddy Ruddy Cay when sco-talk-should is true.

chapter Hood Say Should

Hood Say Should is a complex person in Cruddy Ruddy Cay. talk-text is "[should] browbeats you for a bit, saying you don't want to be virtue-signalling by telling on them when they haven't done anything, and how your type belongs more in Wimp-Imp Way.[paragraph break]Perhaps you need to change up your style.". description is "[hood] regards you back, shiftily.". "[one of]Someone paces around here, not wanting to be seen. When they turn their back, you have a look in [who]. You recognize them as [hood say should][or][should] continues to pace around[stopping].". printed name is "Hood-Say-Should".

check going east in Cruddy Ruddy Cay:
	if Hood Say Should is in Cruddy Ruddy Cay, say "[should] blocks you from going east. 'I may bend the rules, but you really don't want to go east. That's too much. You might annoy some powerful people.'" instead;

check going when goading-should:
	if noun is east, say "[should] would rough you up for trying to double back like that." instead;
	if noun is west and player is in Cop Op Cay, say "No. You think you want to be here. It should be simple to get [should] to confess to their alleged crimes." instead;

after going when goading-should:
	if location of player is not location of hood say should, try should hood say going west;
	continue the action;

book Cracked Wracked Cay 4 0

Cracked Wracked Cay is a beachroom in Clout Lout Cay. It is east of Cruddy Ruddy Cay. shorttext is "[if sco-use-cliffy-cracked is true]Cloud[else]Cracked[end if]". printed name is "[if sco-use-cliffy-cracked is true]Cloud-Loud Cay[else]Cracked Wracked Cay". "[if sco-use-cliffy-cracked is false]It's surprisingly dry for such a coastline. If you were very small, you might almost want to explore some of the cracks[else]You're almost surprised not to see rain-gay grain now this northeast corner of Clout Lout Cay has been irrigated[end if]. You can go south or west.".

understand "cloud loud cay" and "cloud loud" and "cloud/loud cay" and "cloud/loud" as Cruddy Ruddy Cay when sco-use-cliffy-cracked is true.

check going south in Cracked Wracked Cay: if sco-use-cliffy-cracked is false, say "There's no way south, unless you were really small." instead;

book Clothing Loathing Cay 0 1

Clothing Loathing Cay is a beachroom in Clout Lout Cay. It is south of Cold Old Cay. indir is east. "[if sco-use-frock-stark is true]You still feel you're being watched in this north-south passage, but that's probably all in your head[if-no-clay][else]An Ark-Stay-Stark blocks your way south, but you can go back north[end if].". printed name is "[if sco-use-frock-stark is true]Clear Leer Cay[else]Clothing Loathing Cay[end if]". shorttext is "[if sco-use-frock-stark is true]Clear[else]Clothing[end if]".

understand "clear/leer cay" and "clear leer cay" and "clear/leer" as Clothing Loathing Cay when sco-use-frock-stark is true.

to say if-no-clay: if did-rename-clear is false, say "--you sense maybe there is something to do here"

check going south in Clothing Loathing Cay: if sco-use-frock-stark is false, say "Waves of malevolence from the Ark-Stay-Stark force you back north. You can't remove your clothes, so you may need a magic solution, here." instead;

section Clear Ear Clay

the Clear Ear Clay is a loneuse thing. description is "You're pretty sure this will clear your ear, but you need to wait to use it until you hear something odd.". printed name is "Clear-Ear Clay".

after printing the locale description of Clothing Loathing Cay:
	if clay-in-clear is true:
		say "Oh my! What's this? Some [clear ear clay]. It must have dropped out when you pulled the levers back in [start]. You pick it up. It's not too gross. You never know when you might need to hear something important.";
		now player has clear ear clay;
		now clay-in-clear is false;
	continue the action;

section Ark Stay Stark

the Ark Stay Stark is needy scenery in Clothing Loathing Cay. "Naked rock you'd feel uncomfortable passing through or by.". printed name is "Ark-Stay-Stark".

book Break Ache Brae 1 1

Break Ache Brae is a room in Clout Lout Cay. printed name of Break Ache Brae is "[if sco-use-lever-stone is true]On Brae Brawn[else]Break Ache Brae[end if]". shorttext of Break Ache Brae is "[if sco-use-lever-stone is true]Brawn[else]Break[end if]". "The passage for this inner part of Clout Lout Cay curves south and east[if own stay stone is in Break Ache Brae]. But an Own Stay Stone blocks the way east at the moment[end if].".

understand "on brae brawn" and "on brae" and "on/brae brawn" and "on/brae" as Break Ache Brae when sco-use-lever-stone is true.

chapter Own Stay Stone

the Own Stay Stone is needy scenery in Break Ache Brae. "It blocks the way east. You'd need a lot of strength to move it out of the way. A combination of muscle and science.". printed name is "Own-Stay Stone".

check going east in Break Ache Brae:
	if Own Stay Stone is not moot, say "Not with the [stay stone] in the way." instead;
	abide by the can-i-broke rule;

this is the can-i-broke rule:
	if own stay stone is not moot or imp say simp is not moot, say "As you go [noun], a horrendous monster blows you back. It is an Either-Brae Breather! And with only one Brae to breathe at, it can focus its full strength on you." instead;
	if Broke Oak Brae is not visited, say "You go [noun] and brave a horrible monster that can only be known as the Either-Brae Breather. But ... with both ways open, it can't decide which way to breathe. It spends so much time trying to spin around and breathe each way, it dizzies itself out, spins around, and falls down the hill, exhausted.";

book Broke Oak Brae 2 1

Broke Oak Brae is east of Break Ache Brae. It is in Clout Lout Cay. shorttext of Broke Oak Brae is "[if sco-use-moil-che is true]Breach[else if sco-use-replace-this is true]Broad[else]Broke[end if]". printed name of Broke Oak Brae is "[if sco-use-moil-che is true]Breach Each[else if sco-use-replace-this is true]Broad Odd[else]Broke Oak[end if] Brae". "[if sco-use-moil-che is true]You can see the passage south leading up to the center here. Or[else][stakes] block the way south, but[end if] you can look around west and east.".

understand "breach each brae" and "breach each" and "breach/each brae" and "breach/each" as Broke Oak Brae when sco-use-moil-che is true.

understand "broad odd brae" and "broad odd" and "broad/odd brae" and "broad/odd" as Broke Oak Brae when sco-use-replace-this is true.

chapter Chop Op Che

Chop Op Che is a needy person in Broke Oak Brae. "[Chop] sits here, exhausted. Whatever spell was cast on him is preventing him from using his strength.". description is "A strong looking fellow, but disconsolate. There appears to be some mental barrier, and you need to find the cure.". talk-text is "'I shouldn't feel so spent, but I do. And thinking about how and why just makes me more spent. Maybe you can help?'". printed name is "Chop-Op Che"

section Axe Hey Hacks

Chop Op Che carries the Axe Hey Hacks. printed name of Axe Hey Hacks is "Axe-Hey-Hacks". description of Axe Hey Hacks is "Too heavy for you to use. But maybe you could help [chop] use it.".

chapter Aches Stay Stakes

the Aches Stay Stakes are scenery in Broke Oak Brae. "The [stakes] would probably hurt you pretty badly if you tried to go past. They're pointy and tall and criss-crossy.". printed name is "Aches-Stay Stakes".

book Brag Agh Brae 3 1

Brag Agh Brae is east of Broke Oak Brae. It is in Clout Lout Cay. printed name of Brag Agh Brae is "[if sco-talk-simp is true]Brothers/Others[else]Brag (Agh)[end if] Brae". shorttext of Brag Agh Brae is "[if sco-talk-simp is true]Brothers[else]Brag[end if]". "This passage near the back of Clout Lout Cay's inner ring leads west and south.".

understand "brothers others brae" and "brothers others" and "brothers/others brae" and "brothers/others" as Brag Agh Brae when sco-talk-simp is true.

check going west in Brag Agh Brae:
	if imp say simp is not moot, say "The [simp] dissuades you. Oh, sure, you're pretty good, and maybe it's a bummer to stop here, but what if you failed even closer to the end? You'd feel worse. So, best you stop and feel pretty good about yourself. After all, the big bad guys are more likely to make you feel even worse than, you know, giving up and going home.[paragraph break]The [simp] smirks, expecting praise for seeing the issue so differently. Of course there are ways to refute it, but the way it said things--well, it left you dizzy." instead;
	abide by the can-i-broke rule;

chapter imp say simp

Imp Say Simp is a person in Brag Agh Brae. printed name is "Imp Say-Simp". "[one of]You hear a forced laugh, then a loud 'HHEEYY!' followed by faux-reverence. [hey who] indicates you have run into an [simp] blocking the way west[or]The [simp] continues to assure you it will do anything for you if you just ask except, y'know, quit blocking the way west[stopping].". description is "Smug. Condescending. Confident their small talk will paralyze you or make you give up."

check talking imp say simp:
	if last-helpbook is Flatter At Er Flay:
		say "The [simp] tries some penny-ante flattery, but you're ready for it. And for the 'fair and balanced' negging that follows. The discussion goes on for a bit, but the [simp] rapidly loses interest, sensing you are not an easy mark. It wanders away, and while you're worried it didn't ask some REALLY tough questions, well, you did what you could.";
		moot imp say simp;
		increment the score; [cmd: t imp say simp]
		now sco-talk-simp is true;
		the rule succeeds;

book Utter Clay Clutter 4 1

Utter Clay Clutter is a beachroom in Clout Lout Cay. It is south of Cracked Wracked Cay. shorttext is "[if sco-use-hoarder-clutter is false]Utter[else]Clean[end if]". printed name is "[if sco-use-hoarder-clutter is false]Utter Clay Clutter[else]Clean Lean Cay[end if]". indir is west. "[if sco-use-hoarder-clutter is true]You've made a north-south passage here[else]It's so messy here. You can only go back north until you clean things up[end if].".

understand "clean lean cay" and "clean lean" and "clean/lean cay" and "clean/lean" as Utter Clay Clutter when sco-use-hoarder-clutter is true.

check going south in Utter Clay Clutter:
	if sco-use-hoarder-clutter is false, say "Maybe there's a passage south, but it's too messy right now." instead;

chapter Udder Bay Butter

the Udder Bay Butter is an ingredient. description is "You will be glad to know that the producers of Udder Bay Butter are opposed to animal cruelty. There is a picture of a cow on the front saying 'Ow, [']K?' inside a red circle with a line through it.". [nopunc]

book Charred Hard Cay 0 2

Charred Hard Cay is a beachroom in Clout Lout Cay. It is south of Clothing Loathing Cay. shorttext is "[if sco-talk-prude is true]Chappy[else]Charred[end if]". printed name of Charred Hard Cay is "[if sco-talk-prude is true]Chappy-Happy[else]Charred Hard[end if] Cay". "So much here has been carbonised. Not much seems to be left. You can go north and south.". indir is east.

understand "cheap heap cay" and "cheap heap" and "cheap/heap cay" and "cheap/heap" as Charred Hard Cay when sco-talk-prude is true.

the Rude Pay Prude is a booky person in Charred Hard Cay. talk-text of Rude Pay Prude is "The [prude] stares intently at you, as if to say 'Crude? Say, screwed!' You feel guilty even maybe possibly eliciting such a profane thought from such an imposing person.". description is "You can't really bring yourself to look at [the Prude]. You'd feel guilty staring.". "[one of]A person who can only be a [prude] looks up and gazes sharply at you. They can't STOP you being here, but they aren't going to let you just wander around[or]You find yourself unable to break the [prude]'s gaze[stopping].". printed name is "Rude-Pay Prude".

check going south in Charred Hard Cay:
	if sco-talk-prude is false, say "'You really don't want to know what's to the south. You might be trespassing or something. It's even fuller of turpitude than here. Trust me. All this wandering ... it's suspicious, you know. Even if you're not a criminal, you're taking attention away from us surveilling them.'[paragraph break]The [prude] didn't really make sense, but you know how moralistic types are. They throw stuff at the wall, and just enough sticks.[paragraph break]You felt like lashing out to counter all that, but you weren't sure how." instead;
	now sco-talk-prude is true;
	moot rude pay prude;

[ol Kay Cole]

chapter gem

the gem is a loneuse thing. "A gem lies here. It has to be someone's. But whose?". description is "[if sco-vg-mj is false]The gem is unadorned. It's not yours, but someone's. Whose?[else]It belongs to MJ, whoever that is. Now to find MJ![end if]". [nopunc]

chapter mjing

mjing is an action applying to nothing.

understand the command "mj" as something new.
understand the command "m j" as something new.

understand "mj" and "emjay" and "mjay" as mjing when gem is not in Charred Hard Cay.
understand "m j" and "em jay" and "m jay" as mjing.

carry out mjing:
	if sco-vg-mj is true, say "You already monogrammed the gem." instead;
	say "Yes. That must be it. The gem must belong to MJ. Now to find MJ. They probably aren't, like, wearing a nametag.";
	now sco-vg-mj is true;
	increment the score; [cmd: mj]
	the rule succeeds.

book Briar Ire Brae 1 2

Briar Ire Brae is south of Break Ache Brae. It is in Clout Lout Cay. printed name of Briar Ire Brae is "[if sco-use-broil is true]Bramble Amble[else]Briar Ire[end if] Brae". shorttext of Briar Ire Brae is "[if sco-use-broil is true]Bramble[else]Briar[end if]". "[if sco-use-broil is false]Dry briars block your way north. They are too tangled to cut down. So right now, you can only go back south[else]You cleared a way north with the [broil], but you can go back south, too[end if]."

understand "bramble amble brae" and "bramble amble" and "bramble/amble brae" and "bramble/amble" as Briar Ire Brae when sco-use-broil is true.

book Ill Hay Hill 2 2

Ill Hay Hill is south of Broke Oak Brae. It is in Clout Lout Cay. printed name of Ill Hay Hill is "[if sco-use-pole-hold is true]Ol['] Hay Hole[else]Ill Hay Hill[end if]". shorttext of Ill Hay Hill is "[if sco-use-pole-hold is true]Hole[else]Hill[end if]". "You can go back north here[if sco-use-pole-hold is true], but the real adventure seems to be below, to the side of the [heap][end if].".

understand "ol hay hole" and "ol hay" and "ol/hay hole" and "ol/hay" as Ill Hay Hill when sco-use-pole-hold is true.

chapter Mel Say Smell

Mel Say Smell is a needy person in Ill Hay Hill. "[one of]Someone stands at the top of the hill, holding his nose. 'No offense, but ...' he waves his non-nose-holding hand. 'You may think you smell, but you don't. I know these things. I am MEL-SAY-SMELL. I'm in charge around here.'[or][smell] continues to stalk around here, alternately beating his chest and holding his nose.[stopping]". talk-text is "[smell] coughs as if you had lit a cigar full of week-old decayed trash. You probably aren't going to argue him.". description is "Mel wrinkles his nose and sniffs. He doesn't look in the mood for conversation or thoughtful silence. General talking at you, yes.". printed name is "Mel-Say-Smell".

chapter Old Hay Hold

the Old Hay Hold is needy scenery in Ill Hay Hill. "Its walls, roof and floor are made out of hay. [if sco-use-grows-smell is false]You can't get to it with [smell] blocking the way[else]Somehow, [smell] escaped through it. You may need to poke about to find the way down[end if].". [nopunc]

chapter Eep Hay Heap

the Eep Hay Heap is scenery in Ill Hay Hill. "It's what's left of the Old Hay Hold.". printed name is "(eep) hay heap".

book Brawl All Brae 3 2

Brawl All Brae is south of Brag Agh Brae. It is in Clout Lout Cay. "It's north-south here, [if sco-use-bat is false]but the brawl makes it unlikely you can go north without adequate defense[else]an easy walk with the brawl gone[end if].". printed name of Brawl All Brae is "[if sco-use-bat is true]Breezy Easy Brae[else]Brawl All Brae[end if]". shorttext of Brawl All Brae is "[if sco-use-bat is true]Breezy[else]Brawl[end if]".

understand "breezy easy brae" and "breezy easy" and "breezy/easy brae" and "breezy/easy" as Brawl All Brae when sco-use-bat is true.

check going north in Brawl All Brae: if sco-use-bat is false, say "You tiptoe north. You almost make it, but one foot soldier from each side of the pointless brawl pulls you back. You're defenseless against them frog-marching you and shoving you back south." instead;

book Crude Rude Cay 4 2

Crude Rude Cay is a beachroom in Clout Lout Cay. It is south of Utter Clay Clutter. indir is west. shorttext is "[if sco-talk-mc is true]Class[else]Crude[end if]". printed name is "[if sco-talk-mc is true]Class Clay[else]Crude Rude Cay[end if].". "A north-south passage."

MC See Em Eh is a moody person in Crude Rude Cay. printed name is "MC See-Em-Eh". talk-text is "MC See-Em-Eh begins talking in rhymes, and ... well, it's pretty good even though Pig Latin lends itself to some pretty cheap ones. It's an impressive mix of personal and political self-awareness, though MC See-Em-Eh's language is not the cleanest--it falls well short of Public Enemy or Ice-T--and it just seems like MC See-Em-Eh doesn't NEED to use any profanity at all.[paragraph break]MC See-Em-Eh gestures to you, but you shrug. Perhaps with a bit of verbal skill, you might impress MC See-Em-Eh a bit more.". "[MC] stands here, rhyming and maybe using a little more profanity than strictly necessary. More disturbing, though, is that [MC] won't let you go south.". description is "[MC] beatboxes silently. Perhaps [MC] is waiting for a friendly lyrical duel, or something close enough.".

the Quill Eh Equal is a useful thing. description is "It's what [MC] used to write rhymes. It's a bit inaccurately named, because [MC]'s poems didn't scan or rhyme. And yet it makes you feel it's not bad to break certain rules sometimes.[paragraph break]Perhaps it could be handy for someone else with a creative, or even a political, bent.". printed name is "Quill-Eh-Equal".

book Cheap Heap Cay 0 3

Cheap Heap Cay is a beachroom in Clout Lout Cay. It is south of Charred Hard Cay. shorttext is "[if sco-ankh-clank is false]Cheap[else]Caught[end if]". indir is east. "[if sco-ankh-clank is true]There's nothing to be caught, here, but there's nothing that will catch you. You can go north and south unobstructed here right now[else]You can go back north with no problem. The south is walled off with [clashin]. It feels quite odd. You may need some magic from others to dispel (spell-day?) it[end if].". printed name of Cheap Heap Cay is "[if sco-ankh-clank is true]Caught Aught[else]Cheap Heap[end if] Cay".

understand "caught aught cay" and "caught aught" and "caught/aught cay" and "caught/aught" as Cheap Heap Cay when always-no.

check going south in Cheap Heap Cay: if sco-ankh-clank is false, say "The south way is walled off with clay." instead;

section clashin ashen clay

the clashin ashen clay is scenery in Cheap Heap Cay. printed name is "clashin['] ashen clay". "It seems like a contradiction--clashin['] and ashen. And it is. You feel paralyzed around it, almost."

chapter Odd Ray Rod

the Odd Ray Rod is a useful thing. description is "It seems to pulse with energy. Perhaps it can be used to recharge some sort of machine.". [nopunc]

does the player mean doing something with odd ray rod: it is very unlikely.

book Bricky Icky Brae 1 3

Bricky Icky Brae is south of Briar Ire Brae. It is in Clout Lout Cay. printed name of Bricky Icky Brae is "[if imp prey primp is moot]Brash Ash[else]Bricky Icky[end if] Brae". shorttext of Bricky Icky Brae is "[if imp prey primp is moot]Brash[else]Bricky[end if]". "A passage with ways north and east."

understand "brash ash brae" and "brash ash" and "brash/ash brae" and "brash/ash" as Bricky Icky Brae when imp prey primp is moot.

check going north in Bricky Icky Brae when Imp Prey Primp is touchable: say "You're not getting around [primp] that easily.";

chapter Imp Prey Primp

Imp Prey Primp is a person in Bricky Icky Brae. talk-text is "[primp] seems utterly uninterested in reason. In fact, it doesn't even seem to understand what you are saying. It being legitimately evil and all, perhaps you need a more spontaneous expression of holiness, or at least of not being a terrible person.". "[one of]An imp struts around here, leering and strutting. It must be an [primp][or][if sta-chase-c is true]The [primp] continues to strut after you[else]The [primp] struts around vainly[end if][stopping].". description is "[primp] grins slyly at you under a glistening quiff.". printed name is "Imp Prey-Primp".

check talking Imp Prey Primp:
	if in-any-chase, say "No, you already got [primp] chasing you." instead;
	if last-song is Your Pay Pure:
		say "[primp] just can't abide that sort of ostentatious holiness. It squawks in rage and rises up.";
		now sta-chase-c is true;
		start-the-chase;
		the rule succeeds;

book Brat At Brae 2 3

Brat At Brae is east of Bricky Icky Brae. It is north of Crumbling Rumbling Cay. It is in Clout Lout Cay. printed name of Brat At Brae is "[if Odd Pay Pod is allscored]Bring-Ing Brae[else]Brat-At Brae[end if]". shorttext of Brat At Brae is "[if Odd Pay Pod is allscored]Bring[else]Brat[end if]". "The way down and south is not bad[if did-west-brat is true], but you can also go east and west[else if did-east-brat is true], and you can also go east[else], but there doesn't appear to be any other way[end if].".

understand "bring ing brae" and "bring ing" and "bringing brae" and "bringing" and "bring/ing brae" and "bring/ing" as Brat At Brae when Odd Pay Pod is allscored.

chapter All Pay Paul

check talking Pay Paul: if player does not have Old Gay Gold, say "[paul] ignores you completely. You don't have any currency for him." instead;

There is a person called All Pay Paul. Pay Paul is a person in Brat At Brae. printed name is "All-Pay Paul". description is "[paul] stares back. He's just in the mood to deal.". talk-text of Pay Paul is "Day [']e'll deal...' he mutters to himself. He's probably only interested in selling you what's in the [pile], and if you can't figure it out, that's your loss.". "All-Pay Paul waits by his [pod] here, waiting to barter for [if Odd Pay Pod is unscored]money, probably[else]more of your old gay gold[end if]."

chapter trade aid tray (not a real tray)

the trade aid tray is a useful thing. description is "While you've been swapping things a lot so far in your adventure, you get the feeling this tray is more for people who might trade as a living. Maybe it's the indecipherable, important-looking shorthand carved all over it.". printed name is "trade-aid tray".

understand "aid tray" and "aid" as ace tray when player has ace tray.

understand "trade" as a mistake ("[if player does not have ace tray]You're not sure what to trade for[else]It's no longer really just an aid tray[end if].") when aid tray is not off-stage.

chapter Odd Pay Pod

[the eight play plate is a thing. "It looks like it has eight uses, but you're not sure for what."]

the Odd Pay Pod is a latinable in Brat At Brae. description is "Mostly junk, but perhaps there's something worth buying in there. [paul] looks over greedily as you browse. What could you pay for?". help-verb is "P". known-rule of Odd Pay Pod is pile-known rule. guess-table is table of Odd Pay Pod guesses. printed name is "Odd-Pay Pod".

this is the pile-known rule:
	if Brat At Brae is visited, the rule succeeds;
	the rule fails;

section Hour Pay Power

the Hour Pay Power is a useful thing. description is "It probably as just enough to charge whatever items you need. It looks like it has [if pay-power-minutes is 60]a full charge[else][pay-power-minutes] of 60 minutes left, and you remember using it [pay-power-used] times[end if].". indefinite article is "an". printed name is "Hour-Pay-Power".

to decide what number is pay-power-used: decide on boolval of did-use-power-flab + boolval of did-use-power-cam + boolval of did-use-power-saw + boolval of did-use-power-visor.

to decide what number is pay-power-minutes:
	let temp be 60;
	if did-use-power-flab is true, decrease temp by 32;
	if did-use-power-saw is true, decrease temp by 16;
	if did-use-power-visor is true, decrease temp by 8;
	if did-use-power-cam is true, decrease temp by 4;
	decide on temp;

section rattle pay prattle

the Rattle Pay Prattle is a useful thing. printed name is "Rattle-Pay-Prattle". description is "It'd be corny to shake it at an actual person. But perhaps it is useful elsewhere."

section Ol Pay Pole

the Ol Pay Pole is a useful thing. printed name is "Ol['] Pay Pole". description is "It's currently collapsed, but it could telescope out to help you, I don't know, vault over an obstacle [if sco-use-pole-sink is true]like, well,0 the sink, [end if]or work your way down through open space."

section lots pay plots

the Lots Pay Plots are a useful thing. description is "Really just an IOU.". printed name is "Lots-Pay-Plots".

section Oof Prey Proof

the Oof Prey Proof is a twoway thing. description is "It's a weird sort of tarp, so it could theoretically cover something, as long as it didn't get blown away[if sco-use-foil-proof is true]. Now that you used the [foil] on it, it shouldn't[end if].". printed name is "Oof-Prey-Proof".

section Ooh Flay Flu

The Ooh Flay Flu is a useful thing. description is "It's really just a jar of pills. But a warning states that it's not for human consumption.". indefinite article is "some". printed name is "Ooh-Flay-Flu".

book Brought Ought Brae 3 3

Brought Ought Brae is east of Brat At Brae. It is in Clout Lout Cay. It is south of Brawl All Brae. printed name of Brought Ought Brae is "[if sco-talk-shame is true]Brace Ace Brae[else]Brought Ought Brae[end if]". shorttext of Brought Ought Brae is "[if sco-talk-shame is true]Bring[else]Brace[end if]". "The southeast corner of the inner ring of Clout Lout Cay.".

understand "brace ace brae" and "brace ace" and "brace/ace brae" and "brace/ace" as Brought Ought Brae when sco-talk-shame is true.

check going north in Brought Ought Brae:
	if sco-talk-shame is false, say "[shame] dissuades you from going to a new place. Man, they're GOOD at it. You're not going to be able to debate them and prove to them you deserve to see a bit more of [clout]. You'll need a different sort of encouragement." instead;

check talking Shame Aim Shay:
	if last-song is Lo Gay Glow:
		say "As [shame] begins talking down to you, you involuntarily start whistling [lo gay glow]. 'No! Stop that!' [shame] yells. 'I'm an esteemed member of the [factual], and I have better things to do than put up with this!' But you can't help yourself.[paragraph break][shame] labels you as utterly not worth bothering with, if you're going to be clueless and like that.' The guilt trip works. You stand around bewildered for a whole minute, and you realize you HAVE been clueless. You didn't notice [shame] leaving.";
		moot Shame Aim Shay;
		now sco-talk-shame is true;
		increment the score; [cmd: T SHAME AIM SHAY]
		the rule succeeds;

chapter Shame Aim Shay

Shame Aim Shay is a person in Brought Ought Brae. talk-text is "[shame] talks you down from going north. There's a fight going on. Do you really think you can dispel it all by yourself? With strength or violence? No offense, but ...". "[shame] stands here, watching you from the north, as if you should just go back west already.". description is "His crooked half-smile reminds you of fellow students who made fun of teachers and other students behind their backs.". printed name is "Shame-Aim Shay".

book Crowdy Rowdy Cay 4 3

Crowdy Rowdy Cay is a beachroom in Clout Lout Cay. It is south of Crude Rude Cay. "Another north-south passage. [if sco-use-sprawl-creep is false]There's considerable vegetation here. With the right care, it feels like it could burst[else]A nice wooded area free of pests[end if].". printed name of Crowdy Rowdy Cay is "[if sco-use-sprawl-creep is true]Close Lows Cay[else]Crowdy Rowdy Cay[end if]". shorttext of Crowdy Rowdy Cay is "[if sco-use-sprawl-creep is true]Close[else]Cant[end if]".

understand "close lows cay" and "close lows" and "close/lows cay" and "close/lows" as Crowdy Rowdy Cay when sco-use-sprawl-creep is true.

The Eep Cray Creep is a needy thing in Crowdy Rowdy Cay. "An Eep-Cray Creep, looking vaguely like a giant ant, blocks your way south. It seems, oddly, to be avoiding any vegetation as it paces back and forth.". description is "The [creep] doesn't look lethal, but it isn't going to let you past. Maybe you can find some sort of repellent, or some way to tangle it up.". printed name is "Eep-Cray-Creep".

check taking Eep Cray Creep: say "It's more a question of it not taking you." instead;

check going south in Crowdy Rowdy Cay: if Eep Cray Creep is touchable, say "The [Creep] dances in front of you and prevents you from passing without too much trouble. While it doesn't block you form entering the forested area, that area is too thick to walk through, anyway." instead;

the Ant Play Plant is a useful thing. description is "Somehow, miniature (but probably harmless) versions of the Eep Cray Creep are crawling up and down the plant. Thanks to [who], you know they are harmless. But someone less enlightened might not know that.". printed name is "Ant-Play Plant".

book Cornery Ornery Cay 0 4

Cornery Ornery Cay is a beachroom in Clout Lout Cay. It is south of Cheap Heap Cay. printed name is "[if sco-ankh-prank is true]Call-All Cay[else]Cornery Ornery Cay[end if]". shorttext is "[if sco-ankh-prank is true]Call[else]Cornery[end if]". "The path rounds north to east here, with water to the south and west.".

understand "call all cay" and "call all" and "call/all cay" and "call/all" as Cornery Ornery Cay when sco-ankh-prank is true.

chapter Churchin Urchin Che

Churchin Urchin Che is a needy person in Cornery Ornery Cay. printed name is "Churchin['] Urchin Che". "[churchin] paces back and forth here, looking a bit too pious. He seems to want people to know they're being ignored.". talk-text is "'Sinnin['] Say!'". description is "[churchin] sniffs piously at you."

chapter Is Mo Gay Gizmo

the Is Mo Gay Gizmo is a useful thing. printed name is "Is-Mo[']-Gay Gizmo". description is "Just looking at this makes you feel happier. There's a warning label on it saying it isn't guaranteed to make anyone happy, but it will probably repel those who can't be helped for a good long while, particularly those who need to be the happiest, or least miserable, in the room."

book Clues Lose Cay 1 4

Clues Lose Cay is a beachroom in Clout Lout Cay. It is east of Cornery Ornery Cay. "[if Crumbling Rumbling Cay is visited]Passage leads east and west here[else]You can only go back west here. It's walled off to the east[end if][if sco-x-clumsy is false]. Some clumsy (um, see) clay is piled up here. Not very high, and it's pretty holey, but solid. Easy to imagine something valuable slipping through it[else].". printed name is "[if sco-x-clumsy is true]Clues-Lose Cay[else]Clever Ever Clay[end if]". shorttext is "[if sco-x-clumsy is true]Clues[else]Clumsy[end if]". indir is north.

sco-x-clumsy is a truth state that varies.

understand "clever ever clay" and "clever ever" and "clever/ever clay" and "clever/ever" as Clues Lose Cay when sco-x-clumsy is true.

the Clumsy Um See Clay is needy scenery in Clues Lose Cay. "It's kind of icky. Perhaps if you had the right way to poke through it, you might find something. It's also the sort of structure where something would get lost and drop, Pachinko-style, through the various holes. But it's hard yet slimy, and you don't want to deal with it directly.". printed name is "Clumsy (Um, See) Clay".

the Or May More is a useful thing. description is "Apparently, there's some sort of condensed vapor in here. There are the usual instructions not to put it by an open flame, but you can probably USE it on whatever it needs to refill.". printed name is "Or-May-More".

this is the face-the-flea rule:
	if Clues Lose Cay is visited and Cruel Rule Cay is visited, continue the action;
	say "As you go [noun], [a flea] comes into view and starts pestering you. You don't know what lies ahead of it, and it bugs you enough, you wonder if it'd be easy enough to circle around, if indeed you need to see what's on the other side.[paragraph break]Perhaps you could take it down right now, but you're in no mood for a fight. Yet. But once you're pretty sure there's nowhere else to go, yeah, you'll face the flea then." instead;

check going east in Clues Lose Cay: abide by the face-the-flea rule;

book Crumbling Rumbling Cay 2 4

Crumbling Rumbling Cay is a beachroom in Clout Lout Cay. It is east of Clues Lose Cay. printed name of Crumbling Rumbling Cay is "[if sco-use-sprawl-flea is true]Ladder Adder Ley[else]Lack (Ack) Ley[end if]". shorttext of Crumbling Rumbling Cay is "[if sco-use-sprawl-flea is true]Ladder[else]Lack[end if]". indir is north. "Along this east-west shore, you note [if sco-use-sprawl-flea is true]the passage north you made with the Sprawl All Spray[else]the way up (or north) and in is not as steep as elsewhere[end if]."

understand "ladder adder ley" and "ladder adder" and "ladder/adder ley" and "ladder/adder" as Crumbling Rumbling Cay when sco-use-sprawl-flea is true.

check going north in Crumbling Rumbling Cay:
	if sco-use-sprawl-flea is false, say "You can't physically make it north. It's too steep, and the [flea] is in the way." instead;

chapter Eee Flay Flea

The Eee Flay Flea is a needy person in Crumbling Rumbling Cay. "An [Eee Flay Flea] bounces back and forth here aggressively, and yet, it doesn't quite attack you.". talk-text is "The [flea] doesn't speak, but you imagine a voice saying 'Hacked? Hey? ACT!'". description is "About as unkempt as you'd expect a giant flea to be.". printed name is "Eee-Flay Flea".

check taking Eee Flay Flea: say "It's more a question of it not taking you." instead;

book Cruel Rule Cay 3 4

Cruel Rule Cay is a beachroom in Clout Lout Cay. it is east of Crumbling Rumbling Cay. printed name of Cruel Rule Cay is "[if sco-use-grail-punk is true]Crummy Rummy Cay[else]Cruel Rule Cay[end if]". shorttext of Cruel Rule Cay is "[if sco-use-grail-punk is true]Crummy[else]Cruel[end if]". indir is north. "[if sco-use-grail-punk is true]The cold is not so biting now in this east-west segment, now you made Unk Pay-Punk (slightly) less awful[else]It's cold here, You can go west or east to get away from all that[end if].".

understand "crummy rummy cay" and "crummy rummy" and "crummy/rummy cay" and "crummy/rummy" as Cruel Rule Cay when sco-use-grail-punk is true.

check going west in Cruel Rule Cay:
	if unk pay punk is in Cruel Rule Cay, say "[punk] lets you know that only punks go that way. Punks with a suspicious agenda. You'll need to find a way to get [punk] to relax." instead;
	abide by the face-the-flea rule;

chapter Unk Pay Punk

Unk Pay Punk is a needy person in Cruel Rule Cay. talk-text is "[punk] booms: 'Liquor? Ick! Er, lay!' And yet, it's a bit too loud. He dismisses you as clearly on your way to becoming worse than Junkie Unkie J, a distant--very distant--relative who succumbed to the cheap stuff, which of course was easier to buy in quantity. He just KNOWS it in his bones. He seems impervious to anything you might have to say.". description is "You can feel the sanctimony coming from [punk], even when he's silent.". "[one of]An elderly fellow shakes his head at you, mumbling it's a shame. It's not clear what's a shame, and you're too intimidated to ask outright. 'I'm [punk],' he booms. 'I used to be an adventurer and worry about silly stuff. Not any more.' You're too scared to ask him if sitting around and yelling at random people is silly stuff.[or][punk] watches you carefully to make sure you're not starting trouble.[stopping]". printed name of Unk Pay Punk is "[if sco-use-grail-punk is true]Drunk Unk Dre[else]Unk Pay-Punk[end if]".

chapter Drunk Unk Dre

Drunk Unk Dre is a needy person. "Drunk Unk Dre waits here for a little gesture of good-will and charity.". talk-text is "'Ick, hey! (Hic!)'". description is "Almost a caricature of [punk], though it's actually an improvement how he looks now.". [nopunc]

understand "pay/punk" and "unk pay/punk" and "pay punk" and "unk pay punk" as Drunk Unk Dre when Drunk Unk Dre is not off-stage.

chapter Jus Us Jay

the Jus Us Jay is a needy thing. printed name is "Jus['] Us Jay". description is "You don't know much about brand-name marijuana, but this looks like it was meant to be used to attract someone who appreciates this sort of thing. Or, perhaps, repel someone who completely doesn't."

book Claim Lame Cay 4 4

Claim Lame Cay is a renameable beachroom in Clout Lout Cay. It is east of Cruel Rule Cay. It is south of Crowdy Rowdy Cay. printed name of Claim Lame Cay is "[if claim lame cay is altnamed]Claim Aim Clay[else]Claim Lame Cay[end if]". shorttext of Claim Lame Cay is "[if claim lame cay is altnamed]Claim[else]Claim[end if]". "[if claim lame cay is altnamed]With waters south and east, this place looks so much more desirable now you changed it with the [switch][else]Boy! This shoreline with a passage north-to-west place could really bore someone who needs their aesthetics[end if]."

understand "claim aim clay" and "claim aim" and "aim clay" and "aim" as Claim Lame Cay when Claim Lame Cay is ever-alt.

volume unsorted but critical places and things

the I Survey Visor is a twoway thing. description is "It seems a little edgy, what with the slightly tortuous mispronunciation, but [if did-use-power-visor is false]it seems out of energy[else]looking through it, a lot seems to be in different focus[end if].". printed name is "I-Survey Visor".

volume unsorted places - not for release

chapter apocryphal rooms

[Caged Aged Cay is a room.] [caged = what to flip ??]

[aiding way, aiding bay]

volume endgame

volume mapping - not for release

section Am Hey Ham area

index map with Breeding Reading Bay mapped west of Bling Ling Bay.
index map with Breeding Reading Bay mapped east of Sing Ing Say.
index map with Ovel Nay Novel mapped west of Sing Ing Say.

index map with Ere Say Seer mapped south of Sci I Say.

index map with Oft Lay Loft mapped south of Ope Nay Nope.

section Brain Reign Bay area

section Eee Say Sea area

[the isles are arranged in a 3x4 area for convenience, west of the main area.]

index map with Beast East Bay mapped west of Blurring Luring Bay.

[below should be pretty fixed]

index map with Isle Bay Bile mapped east of Isle Away Awhile.
index map with Isle Day Dial mapped east of Isle Bay Bile.
index map with Isle Fey File mapped south of Isle Away Awhile.
index map with Isle Gay Guile mapped east of Isle Fey File.
index map with Isle May Mile mapped east of Isle Gay Guile.
index map with Isle Pay Pile mapped south of Isle Fey File.
index map with Isle Ray Rile mapped east of Isle Pay Pile.
index map with Isle Stay Style mapped east of Isle Ray Rile.

index map with Beast East Bay mapped south of Isle Stay Style.

section clout area

index map with Cold Old Cay mapped east of Berth Earth Bay.

section fey area

index map with Foul Owl Fey mapped south of Cruel Rule Cay.

section ley area

index map with Loaf Oaf Ley mapped south of Blubber Lubber Bay.

section end area

index map with Raw Stay Straw mapped north of Booze Ooze Bay.
index map with all hay hall mapped north of Cop Op Cay.
index map with gray land mapped west of all hay hall.

section at the end or it goes weird

index map with Aced Way mapped east of Lashin Ashen Ley.

volume beta testing - not for release

chapter 0ing

0ing is an action applying to nothing.

understand the command "0" as something new.

understand "0" as 0ing.

carry out 0ing:
	if Ernie J is talked-to, say "You need to restart the game to try this." instead;
	say "Going to the ray.";
	try talking Ernie J;
	try going inside;
	try talking Shelf Elf Shay;
	try going outside;
	try going west;
	the rule succeeds.

book starting

when play begins (this is the beta tester basic information rule):
	say "This is a beta version. You may wish to turn the transcript on with TRANSCRIPT--it helps me see if I sent you down a blind alley, or you can just write in stuff you'd have forgotten otherwise. You can make comments with ; or * or whatever you'd like. I can figure it out.";
	say "One command that might be helpful is, at the start, 0 (the number.) This will bump you west of the entry room, having talked to everyone who greeted you.";
	now in-beta is true;

volume unsorted stuff

the lumber say slumber is a needy thing. printed name is "lumber-say-slumber". description is "It doesn't look like much. It's light-weight but sturdy. You remember how you peeled some of it off when you took it, and it regenerated. Odd.". indefinite article is "some".

chapter rooms

the Flab Ab Flay is a needy thing. description is "It's obviously some sort of home-gym contraption that is simple, but painful, to use. It could be useful [once-now of sco-got-stew] you have put on a little unwanted weight. You don't need to be super buff, but you don't want to be out of shape during crunch time, either. However, it doesn't look fun at all to use.". printed name is "Flab-Ab-Flay".

chapter things

volume beta testing - not for release

when play begins (this is the notify tester of basics rule):
	say "Remember to have a TRANSCRIPT working. It helps me get more data to help improve things to make the game clearer, etc.";

volume unsorted people - not for release

[Surer Shay is a person. Ellie Ray is a person. Edgy Ray is a person. Jolly Ollie J is a person. Sheer Hearsay is a room. Raw Stay Straw is a room.]

volume tests - not for release

include Full Monty Testing by Andrew Schultz.

a monty rule: if debug-state is true and monty-force is true, process the full monty test rule;
